/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ItemSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> BOILER_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> ICEBOX_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> HEARTH_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> HEARTH_POTION_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue ALLOW_POTIONS_IN_HEARTH;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> SOULSPRING_LAMP_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SOULSPRING_LAMP_DIMENSIONS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> FOOD_TEMPERATURES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> ITEM_TEMPERATURES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATION_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> INSULATION_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATING_ARMOR;
    public static final ForgeConfigSpec.ConfigValue<List<?>> INSULATION_SLOTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATION_SLOT_OVERRIDES;
    public static final ForgeConfigSpec.DoubleValue INSULATION_STRENGTH;
    public static final ForgeConfigSpec.IntValue WATERSKIN_CONSUME_STRENGTH;
    public static final ForgeConfigSpec.DoubleValue WATERSKIN_HOTBAR_STRENGTH;
    public static final ForgeConfigSpec.DoubleValue WATERSKIN_NEUTRALIZE_SPEED;
    public static final ForgeConfigSpec.IntValue WATERSKIN_USES;
    public static final ForgeConfigSpec.DoubleValue SOULSPRING_LAMP_STRENGTH;
    public static final ForgeConfigSpec.ConfigValue<Boolean> FIRE_RESISTANCE_BLOCKS_OVERHEATING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ICE_RESISTANCE_BLOCKS_FREEZING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> REQUIRE_THERMOMETER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> DRYING_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATING_CURIOS;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SPEC, "coldsweat/item.toml");
    }

    public static void save() {
        SPEC.save();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        ConfigSettings.Difficulty defaultDiff = ConfigSettings.DEFAULT_DIFFICULTY;
        BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Anywhere that uses item IDs also supports:", " \u2022 Tags (e.g. \"#minecraft:planks\")", " \u2022 Comma-separated lists (e.g. \"minecraft:blaze_powder,#forge:rods/blaze\")", "     Applies the setting to all listed IDs. Can use tags, regular IDs, and negation interchangeably", " \u2022 Negation (e.g. \"!minecraft:black_dye\")", "     Useful with lists/tags. Excludes the listed IDs from the setting", "     i.e. \"#forge:dyes,!minecraft:black_dye\" (all dyes EXCEPT black dye)", " Settings with \"//v\" will list elements vertically. Removing \"//v\" will list elements in one line", "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500"});
        BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines items that can be used as fuel", " \u2514\u2500\u2500 Format: [[\"item_id\", amount], [\"item_id\", amount], [...], etc]", " \u2022 item_id: The item's ID (i.e. \"minecraft:coal\").", " \u2022 amount: The amount of fuel the item provides. Higher values mean the item burns longer", " \u2304 "}).push("Fuel Items");
        BOILER_FUELS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v").defineListAllowEmpty(Arrays.asList("Boiler"), () -> ListBuilder.begin(new List[]{Arrays.asList("#minecraft:planks", 10), Arrays.asList("#minecraft:coals", 55), Arrays.asList("#minecraft:logs_that_burn", 40), Arrays.asList("minecraft:dried_kelp_block", 40), Arrays.asList("minecraft:coal_block", 500), Arrays.asList("minecraft:magma_block", 333), Arrays.asList("minecraft:lava_bucket", 1000)}).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return list.size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
            }
            return false;
        });
        ICEBOX_FUELS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v").defineListAllowEmpty(Arrays.asList("Icebox"), () -> ListBuilder.begin(new List[]{Arrays.asList("minecraft:snowball", 10), Arrays.asList("minecraft:clay_ball", 37), Arrays.asList("minecraft:snow_block", 40), Arrays.asList("minecraft:ice", 250), Arrays.asList("minecraft:clay", 333), Arrays.asList("minecraft:packed_ice", 1000)}).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return list.size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
            }
            return false;
        });
        HEARTH_FUELS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " (Negative values indicate cold fuel"}).defineListAllowEmpty(Collections.singletonList("Hearth"), () -> ListBuilder.begin(new List[]{Arrays.asList("#minecraft:planks", 10), Arrays.asList("#minecraft:coals", 55), Arrays.asList("#minecraft:logs_that_burn", 40), Arrays.asList("minecraft:dried_kelp_block", 40), Arrays.asList("minecraft:coal_block", 500), Arrays.asList("minecraft:magma_block", 333), Arrays.asList("minecraft:lava_bucket", 1000), Arrays.asList("minecraft:snowball", -10), Arrays.asList("minecraft:clay_ball", -37), Arrays.asList("minecraft:snow_block", -40), Arrays.asList("minecraft:ice", -250), Arrays.asList("minecraft:clay", -333), Arrays.asList("minecraft:packed_ice", -1000)}).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return list.size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
            }
            return false;
        });
        BUILDER.pop();
        BUILDER.push("Hearth Extras");
        HEARTH_POTION_BLACKLIST = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Potions containing any of these effects will not be allowed in the hearth", " \u2514\u2500\u2500 Format: [\"effect_id\", \"effect_id\", ...etc]", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Blacklisted Hearth Potions"), () -> ListBuilder.begin(new String[]{"minecraft:instant_damage", "minecraft:poison", "minecraft:wither", "minecraft:weakness", "minecraft:mining_fatigue", "minecraft:slowness"}).build(), it -> it instanceof String);
        ALLOW_POTIONS_IN_HEARTH = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " If true, potions can be used in the hearth to give all players in range the potion effect", " \u2304 "}).define("Allow Potions in Hearth", true);
        BUILDER.pop();
        BUILDER.push("Soulspring Lamp");
        SOULSPRING_LAMP_FUELS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines items that the Soulspring Lamp can use as fuel", " \u2514\u2500\u2500 Format: [[\"item_id\", amount], [\"item_id\", amount], [...], etc]", " \u2022 item_id: The item's ID (i.e. \"cold_sweat:soul_sprout\").", " \u2022 amount: The amount of fuel the item provides. Higher values mean the item burns longer", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Fuel Items"), () -> ListBuilder.begin(Arrays.asList("cold_sweat:soul_sprout", 4)).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return list.size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
            }
            return false;
        });
        SOULSPRING_LAMP_DIMENSIONS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the dimensions that the Soulspring Lamp can be used in", " \u2514\u2500\u2500 Format: [\"dimension_id\", \"dimension_id\", ...etc]", " \u2304 "}).defineListAllowEmpty(Collections.singletonList("Valid Dimensions"), () -> ListBuilder.begin("minecraft:the_nether").build(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Insulation");
        INSULATION_ITEMS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the items that can be used for insulating armor in the Sewing Table", " \u251c\u2500\u2500 Format (Static): [[\"item_id\", cold, hot, *\"static\", *\"{nbt}\", *fillSlots], [...], etc]", " \u251c\u2500\u2500 Format (Adaptive): [[\"item_id\", amount, adaptSpeed, \"adaptive\", *\"{nbt}\", *fillSlots], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 item_id: The item's ID (i.e. \"minecraft:iron_ingot\").", " \u2022 cold: The cold insulation the item provides.", " \u2022 hot: The heat insulation the item provides.", " \u2022 amount: The amount of insulation the item provides.", " \u2022 adaptSpeed: The speed at which the insulation adapts to the environment.", " \u2022 *static/adaptive: The type of insulation the item provides. Defaults to \"static\" if unset", " \u2022 *nbt: If set, the item will only provide insulation if it has the specified NBT tag.", " \u2022 *fillSlots: If true, the item will fill 1 slot per 2 insulation points. Otherwise, the item will fill 1 slot.", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Insulation Ingredients"), () -> ListBuilder.begin(new List[]{Arrays.asList("minecraft:leather", 1, 1), Arrays.asList("cold_sweat:chameleon_molt", 2, 0.0085, "adaptive"), Arrays.asList("cold_sweat:hoglin_hide", 0, 2), Arrays.asList("cold_sweat:goat_fur", 2, 0), Arrays.asList("#minecraft:wool", 1.5, 0), Arrays.asList("minecraft:rabbit_hide", 0, 1.5)}).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return !(list.size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) && !(list.get(1) instanceof List) || !(list.get(2) instanceof Number) && !(list.get(2) instanceof List) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Boolean));
            }
            return false;
        });
        INSULATING_ARMOR = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the items that provide insulation when worn", " ** See Insulation Ingredients for formatting.", " Enabling \"fillSlots\" will cause the armor's built-in insulation to consume the available insulation slots", " i.e. if an item has 5 insulation slots and gives one slot of cold insulation by default, it will only have 4 free slots left", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Insulating Armor"), () -> ListBuilder.begin(new List[]{Arrays.asList("minecraft:leather_helmet", 5, 5), Arrays.asList("minecraft:leather_chestplate", 7, 7), Arrays.asList("minecraft:leather_leggings", 6, 6), Arrays.asList("minecraft:leather_boots", 5, 5), Arrays.asList("cold_sweat:hoglin_helmet", 0, 10), Arrays.asList("cold_sweat:hoglin_chestplate", 0, 14), Arrays.asList("cold_sweat:hoglin_leggings", 0, 12), Arrays.asList("cold_sweat:hoglin_boots", 0, 10), Arrays.asList("cold_sweat:goat_fur_helmet", 10, 0), Arrays.asList("cold_sweat:goat_fur_chestplate", 14, 0), Arrays.asList("cold_sweat:goat_fur_leggings", 12, 0), Arrays.asList("cold_sweat:goat_fur_boots", 10, 0), Arrays.asList("cold_sweat:chameleon_helmet", 10, 0.0085, "adaptive"), Arrays.asList("cold_sweat:chameleon_chestplate", 14, 0.0085, "adaptive"), Arrays.asList("cold_sweat:chameleon_leggings", 12, 0.0085, "adaptive"), Arrays.asList("cold_sweat:chameleon_boots", 10, 0.0085, "adaptive")}).addIf(CompatManager.isToughAsNailsLoaded(), () -> Arrays.asList("toughasnails:leaf_helmet", 0, Arrays.asList(1, 1, 1, 1, 1)), () -> Arrays.asList("toughasnails:leaf_chestplate", 0, Arrays.asList(1, 1, 1, 1, 1, 1, 1)), () -> Arrays.asList("toughasnails:leaf_leggings", 0, Arrays.asList(1, 1, 1, 1, 1, 1)), () -> Arrays.asList("toughasnails:leaf_boots", 0, Arrays.asList(1, 1, 1, 1, 1)), () -> Arrays.asList("toughasnails:wool_helmet", Arrays.asList(1.5, 1.5, 1.5, 1.5, 1.5), 0), () -> Arrays.asList("toughasnails:wool_chestplate", Arrays.asList(1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5), 0), () -> Arrays.asList("toughasnails:wool_leggings", Arrays.asList(1.5, 1.5, 1.5, 1.5, 1.5, 1.5), 0), () -> Arrays.asList("toughasnails:wool_boots", Arrays.asList(1.5, 1.5, 1.5, 1.5, 1.5), 0)).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return !(list.size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) && !(list.get(1) instanceof List) || !(list.get(2) instanceof Number) && !(list.get(2) instanceof List) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Boolean));
            }
            return false;
        });
        INSULATING_CURIOS = CompatManager.isCuriosLoaded() ? BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the items that provide insulation when worn in a curio slot", " See Insulation Ingredients for formatting. This setting does not have a \"fillSlots\" option", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Insulating Curios"), () -> Arrays.asList(new List[0]), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return !(list.size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
            }
            return false;
        }) : null;
        INSULATION_SLOTS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how many insulation slots armor pieces have", " There are 4 modes for this setting:", " \u250c Static: Each armor slot (head, body, legs, feet) has a fixed number of insulation slots", " \u2514\u2500\u2500\u2500 Format: [head, body, legs, feet]", "      \u2022 head/body/legs/feet: The number of insulation slots for that armor slot", " \u250c Linear: Number of slots increases steadily with protection", " \u251c Exponential: Number of slots increases rapidly with protection", " \u251c Logarithmic: Number of slots increases with protection, with diminishing returns", " \u2514\u2500\u2500\u2500 Format: [multiplier, max-slots]", "      \u2022 multiplier: Multiplied by the armor's protection value to get the number of insulation slots", "      \u2022 max-slots: The maximum number of insulation slots an armor piece can have", " \u2304 "}).defineList("Insulation Slots", Arrays.asList("static", 4, 6, 5, 4), it -> it instanceof Number || it instanceof String);
        INSULATION_SLOT_OVERRIDES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Allows for overriding the number of insulation slots for specific items", " \u2514\u2500\u2500 Format: [[\"item_id\", slotCount, *\"{nbt}\"], [\"item_id\", slotCount, *\"{nbt}\"], [...], etc]", " \u2022 item_id: The item's ID (i.e. \"minecraft:iron_helmet\").", " \u2022 slot_count: The number of insulation slots the item should have.", " \u2022 *nbt: If set, the item will only have the specified number of insulation slots if it has the specified NBT tag.", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Insulation Slot Overrides"), () -> Arrays.asList(new List[0]), it -> it instanceof List && ((List)it).size() == 2 && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof Number && (((List)it).size() < 3 || ((List)it).get(2) instanceof String));
        INSULATION_STRENGTH = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines the effectiveness of insulating items in protecting against temperature", " \u2304 "}).defineInRange("Insulation Strength", 1.0, 0.0, Double.POSITIVE_INFINITY);
        INSULATION_BLACKLIST = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines wearable items that cannot be insulated", " \u2514\u2500\u2500 Format: [\"item_id\", \"item_id\", ...etc]", " \u2304 "}).defineListAllowEmpty(Collections.singletonList("Insulation Blacklist"), () -> Arrays.asList(new String[0]), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Consumables");
        FOOD_TEMPERATURES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines items that affect the player's temperature when consumed", " \u251c\u2500\u2500 Format: [[\"item_id\", amount, *\"{nbt}\", *duration, *stack_limit], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 item_id: The item's ID (i.e. \"minecraft:apple\").", " \u2022 amount: The amount to change the player's temperature by. Negative values are cold, positive values are hot", " \u2022 *nbt: If set, the item will only affect the player's temperature if it has the specified NBT tag.", " \u2022 *duration: If set, the player's temperature will remain increased/decreased for this amount of time (in ticks).", " \u2022 *stack_limit: If set, consuming multiple of the same item will apply stacking effects up to this limit.", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Temperature-Affecting Foods"), () -> Arrays.asList(Arrays.asList("cold_sweat:soul_sprout", -20, "{}", 1200)), it -> {
            if (it instanceof List) {
                List list = (List)it;
                return !(list.size() < 2 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof String) || list.size() >= 4 && !(list.get(3) instanceof Number));
            }
            return false;
        });
        WATERSKIN_CONSUME_STRENGTH = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how much a waterskin will change the player's body temperature when used", " \u2304 "}).defineInRange("Waterskin Strength", 50, 0, Integer.MAX_VALUE);
        WATERSKIN_HOTBAR_STRENGTH = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " A multiplier for how effective a waterskin's over-time effect is, when held in the player's hotbar", " \u2304 "}).defineInRange("Waterskin Hotbar Strength", 1.0, 0.0, Double.POSITIVE_INFINITY);
        WATERSKIN_NEUTRALIZE_SPEED = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " A multiplier for how quickly a waterskin will return to its neutral temperature when being used in the hotbar", " \u2304 "}).defineInRange("Waterskin Neutralize Speed", 1.0, 0.0, Double.POSITIVE_INFINITY);
        WATERSKIN_USES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how many times a waterskin can be used before becoming empty", " \u2304 "}).defineInRange("Waterskin Uses", 1, 1, Integer.MAX_VALUE);
        SOULSPRING_LAMP_STRENGTH = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Determines the strength of the Soulspring Lamp's effect before it is overwhelmed", " A value of 1 means it will never be overwhelmed", " \u2304 "}).defineInRange("Soulspring Lamp Strength", 0.6, 0.0, 1.0);
        DRYING_ITEMS = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines items that can be used to dry the player", " \u2514\u2500\u2500 Format: [[\"item_id\", \"turns_into\"], [...], etc]", " \u2022 item_id: The item's ID (i.e. \"minecraft:sponge\").", " \u2022 turns_into: The item to be turned into when the item is used (i.e. \"minecraft:wet_sponge\").", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Drying Items"), () -> Arrays.asList(Arrays.asList("minecraft:sponge", "minecraft:wet_sponge")), it -> it instanceof List && ((List)it).size() == 2 && ((List)it).get(0) instanceof String && ((List)it).get(1) instanceof String);
        BUILDER.pop();
        BUILDER.push("Misc");
        ITEM_TEMPERATURES = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines items that affect the player's temperature when in the inventory", " \u251c\u2500\u2500 Format: [[\"item_id\", temperature, \"slotRange\", \"trait\", *\"{nbt}\", *maxEffect, *tempLimit], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 item_id: The item's ID (i.e. \"minecraft:lava_bucket\").", " \u2022 temperature: The temperature change the item will apply to the entity. For core temperature, this is applied every tick", " \u2022 slot_range: Either \"inventory\", \"hotbar\", or \"hand\". Defines what slots the item must be in to apply to the entity (inventory includes hotbar)", " \u2022 trait: The temperature trait to apply the effect to. Typical values are \"core\" for body temperature or \"world\" for ambient temperature. More on the mod documentation page.", " \u2022 *nbt: The NBT data the item must have to apply to the entity.", " \u2022 *max_effect: The maximum temperature effect the item can apply to the entity.", " \u2022 *tempLimit: The maximum temperature at which this item temp will have any effect.", "   (Based on the given trait. Represents the minimum temp if the item temp is negative)", " \u2304 "}).defineListAllowEmpty(Arrays.asList("Item Temperatures"), () -> Arrays.asList(new List[0]), it -> {
            if (!(it instanceof List)) {
                return false;
            }
            List list = (List)it;
            return !(!(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof String) || !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Number) || list.size() >= 7 && !(list.get(6) instanceof Number));
        });
        BUILDER.pop();
        BUILDER.push("Item Functions");
        FIRE_RESISTANCE_BLOCKS_OVERHEATING = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Allow fire resistance to block overheating damage", " \u2304 "}).define("Fire Resistance Immunity", (Object)defaultDiff.getOrDefault(ConfigSettings.FIRE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        ICE_RESISTANCE_BLOCKS_FREEZING = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Allow ice resistance to block freezing damage", " \u2304 "}).define("Ice Resistance Immunity", (Object)defaultDiff.getOrDefault(ConfigSettings.ICE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        REQUIRE_THERMOMETER = BUILDER.comment(new String[]{"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Whether a thermometer is required to see exact world and body temperature", " \u2304 "}).define("Require Thermometer", (Object)defaultDiff.getOrDefault(ConfigSettings.REQUIRE_THERMOMETER, Boolean.valueOf(true)));
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

