/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class ArmorInsulatedTrigger
extends AbstractCriterionTrigger<Instance> {
    static final ResourceLocation ID = new ResourceLocation("cold_sweat", "armor_insulated");

    protected Instance createInstance(JsonObject json, EntityPredicate.AndPredicate player, ConditionArrayParser context) {
        ItemPredicate armorStack = ItemPredicate.func_192492_a((JsonElement)json.get("armor_item"));
        ItemPredicate[] insulStack = ItemPredicate.func_192494_b((JsonElement)json.get("insulation_item"));
        return new Instance(player, armorStack, insulStack);
    }

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void trigger(ServerPlayerEntity player, ItemStack fuelStack, ItemStack lampStack) {
        this.func_235959_a_(player, triggerInstance -> triggerInstance.matches(fuelStack, lampStack));
    }

    public static class Instance
    extends CriterionInstance {
        private final ItemPredicate armorStack;
        private final ItemPredicate[] insulStack;

        public Instance(EntityPredicate.AndPredicate player, ItemPredicate armorStack, ItemPredicate[] insulStack) {
            super(ID, player);
            this.armorStack = armorStack;
            this.insulStack = insulStack;
        }

        public boolean matches(ItemStack fuelStack, ItemStack lampStack) {
            return this.armorStack.func_192493_a(fuelStack) && (this.insulStack.length == 0 || Arrays.stream(this.insulStack).anyMatch(predicate -> predicate.func_192493_a(lampStack)));
        }

        public JsonObject func_230240_a_(ConditionArraySerializer context) {
            JsonObject obj = super.func_230240_a_(context);
            obj.add("armor_item", this.armorStack.func_200319_a());
            JsonArray jsonarray = new JsonArray();
            for (ItemPredicate itemPredicate : this.insulStack) {
                jsonarray.add(itemPredicate.func_200319_a());
            }
            obj.add("insulation_item", (JsonElement)jsonarray);
            return obj;
        }
    }
}

