/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class SoulLampFuelledTrigger
extends AbstractCriterionTrigger<Instance> {
    static final ResourceLocation ID = new ResourceLocation("cold_sweat", "soulspring_lamp_fuelled");

    public Instance createInstance(JsonObject json, EntityPredicate.AndPredicate player, ConditionArrayParser context) {
        ItemPredicate[] fuelStack = ItemPredicate.func_192494_b((JsonElement)json.get("fuel_item"));
        ItemPredicate lampStack = ItemPredicate.func_192492_a((JsonElement)json.get("lamp_item"));
        return new Instance(player, fuelStack, lampStack);
    }

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void trigger(ServerPlayerEntity player, ItemStack fuelStack, ItemStack lampStack) {
        this.func_235959_a_(player, triggerInstance -> triggerInstance.matches(fuelStack, lampStack));
    }

    public static class Instance
    extends CriterionInstance {
        private final ItemPredicate[] fuelStack;
        private final ItemPredicate lampStack;

        public Instance(EntityPredicate.AndPredicate player, ItemPredicate[] fuelStack, ItemPredicate lampStack) {
            super(ID, player);
            this.fuelStack = fuelStack;
            this.lampStack = lampStack;
        }

        public boolean matches(ItemStack fuelStack, ItemStack lampStack) {
            if (!this.lampStack.func_192493_a(lampStack)) {
                return false;
            }
            if (fuelStack.func_190926_b()) {
                return true;
            }
            for (ItemPredicate predicate : this.fuelStack) {
                if (!predicate.func_192493_a(fuelStack)) continue;
                return true;
            }
            return false;
        }

        public JsonObject func_230240_a_(ConditionArraySerializer context) {
            JsonObject obj = super.func_230240_a_(context);
            obj.add("lamp_item", this.lampStack.func_200319_a());
            JsonArray jsonarray = new JsonArray();
            for (ItemPredicate itemPredicate : this.fuelStack) {
                jsonarray.add(itemPredicate.func_200319_a());
            }
            obj.add("items", (JsonElement)jsonarray);
            return obj;
        }
    }
}

