/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.core.advancement.trigger.TriggerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class TemperatureChangedTrigger
extends AbstractCriterionTrigger<Instance> {
    static final ResourceLocation ID = new ResourceLocation("cold_sweat", "temperature");

    protected Instance createInstance(JsonObject json, EntityPredicate.AndPredicate player, ConditionArrayParser context) {
        JsonArray tempList = json.get("temperature").getAsJsonArray();
        ArrayList<TriggerHelper.TempCondition> conditions = new ArrayList<TriggerHelper.TempCondition>();
        for (JsonElement element : tempList) {
            JsonObject entry = element.getAsJsonObject();
            Temperature.Trait trait = Temperature.Trait.fromID(entry.get("type").getAsString());
            TriggerHelper.getTempValueOrRange(entry).ifLeft(either -> conditions.add(new TriggerHelper.TempCondition(trait, (double)either, (double)either))).ifRight(pair -> conditions.add(new TriggerHelper.TempCondition(trait, (Double)pair.getFirst(), (Double)pair.getSecond())));
        }
        return new Instance(player, conditions);
    }

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void trigger(ServerPlayerEntity player, Map<Temperature.Trait, Double> temps) {
        this.func_235959_a_(player, triggerInstance -> triggerInstance.matches(temps));
    }

    public static class Instance
    extends CriterionInstance {
        List<TriggerHelper.TempCondition> conditions;

        public Instance(EntityPredicate.AndPredicate player, List<TriggerHelper.TempCondition> conditions) {
            super(ID, player);
            this.conditions = conditions;
        }

        public boolean matches(Map<Temperature.Trait, Double> temps) {
            for (TriggerHelper.TempCondition condition : this.conditions) {
                double value;
                if (condition.matches(value = temps.get(condition.trait()).doubleValue())) continue;
                return false;
            }
            return true;
        }

        public JsonObject func_230240_a_(ConditionArraySerializer context) {
            JsonObject obj = super.func_230240_a_(context);
            obj.add("temperature", (JsonElement)TriggerHelper.serializeConditions(this.conditions));
            return obj;
        }
    }
}

