/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.google.common.collect.ImmutableMap;
import com.momosoftworks.coldsweat.common.entity.GoatEntity;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.util.FunctionalSpawnerData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;

@Mod.EventBusSubscriber
public class AddEntitySpawns {
    private static final Field SPAWNERS = ObfuscationReflectionHelper.findField(MobSpawnInfo.class, (String)"field_242554_e");

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoading(FMLServerAboutToStartEvent event) {
        DynamicRegistries registryAccess = RegistryHelper.getDynamicRegistries();
        if (registryAccess == null) {
            return;
        }
        for (Biome biome : registryAccess.func_243612_b(Registry.field_239720_u_)) {
            HashMap spawnerMap;
            try {
                spawnerMap = new HashMap((Map)SPAWNERS.get(biome.func_242433_b()));
            }
            catch (IllegalAccessException e) {
                return;
            }
            CSMath.doIfNotNull(ConfigSettings.ENTITY_SPAWN_BIOMES.get(registryAccess).get((Object)biome), spawns -> {
                for (SpawnBiomeData spawn : spawns) {
                    RegistryHelper.mapTaggableList(spawn.entities()).forEach(entityType -> {
                        ArrayList<MobSpawnInfo.Spawners> spawners = new ArrayList<MobSpawnInfo.Spawners>(biome.func_242433_b().func_242559_a(spawn.category()));
                        FunctionalSpawnerData spawnerData = new FunctionalSpawnerData((EntityType<?>)entityType, spawn.weight(), spawn.count().min(), spawn.count().max(), (level, structureManager, chunkGenerator, category, data, pos) -> spawn.location().test(rq -> rq.test((World)level, pos)));
                        spawners.removeIf(oldData -> oldData.field_242588_c == entityType);
                        spawners.add(spawnerData);
                        spawnerMap.put(spawn.category(), spawners);
                    });
                }
            });
            try {
                SPAWNERS.set(biome.func_242433_b(), ImmutableMap.copyOf(spawnerMap));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        SPAWNERS.setAccessible(true);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegisterSpawnPlacements {
        @SubscribeEvent
        public static void registerSpawnPlacements(FMLCommonSetupEvent event) {
            EntitySpawnPlacementRegistry.func_209343_a(ModEntities.GOAT, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GoatEntity::canSpawn);
            EntitySpawnPlacementRegistry.func_209343_a(ModEntities.CHAMELEON, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        }
    }
}

