/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncForgeDataMessage {
    CompoundNBT forgeData;
    int entityID;
    String dimension;

    public SyncForgeDataMessage(Entity entity) {
        this.forgeData = entity.getPersistentData();
        this.entityID = entity.func_145782_y();
        this.dimension = entity.field_70170_p.func_234923_W_().func_240901_a_().toString();
    }

    public SyncForgeDataMessage(CompoundNBT forgeData, int entityID, String dimension) {
        this.forgeData = forgeData;
        this.entityID = entityID;
        this.dimension = dimension;
    }

    public static void encode(SyncForgeDataMessage message, PacketBuffer buffer) {
        buffer.func_150786_a(message.forgeData);
        buffer.writeInt(message.entityID);
        buffer.func_180714_a(message.dimension);
    }

    public static SyncForgeDataMessage decode(PacketBuffer buffer) {
        return new SyncForgeDataMessage(buffer.func_150793_b(), buffer.readInt(), buffer.func_218666_n());
    }

    public static void handle(SyncForgeDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            World world;
            if (context.getDirection().getReceptionSide().isClient() && ClientOnlyHelper.getClientWorld().func_234923_W_().func_240901_a_().toString().equals(message.dimension) && (world = ClientOnlyHelper.getClientWorld()) != null && (entity = world.func_73045_a(message.entityID)) != null) {
                entity.getPersistentData().func_197643_a(message.forgeData);
            }
        });
        context.setPacketHandled(true);
    }
}

