/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncPreferencesMessage {
    EnumMap<Preference, Object> preferences = new EnumMap(Preference.class);

    public static SyncPreferencesMessage create() {
        SyncPreferencesMessage message = new SyncPreferencesMessage();
        for (Preference preference : Preference.values()) {
            message.preferences.put(preference, preference.getter().get());
        }
        return message;
    }

    public static void encode(SyncPreferencesMessage message, PacketBuffer buffer) {
        if (EffectiveSide.get().isClient()) {
            SyncPreferencesMessage.savePreferences(ClientOnlyHelper.getClientPlayer(), message.preferences);
        }
        AtomicReference pref = new AtomicReference();
        buffer.writeInt(message.preferences.size());
        message.preferences.forEach((key, value) -> {
            pref.set(key);
            buffer.func_179249_a((Enum)key);
            ((Preference)((Object)((Object)pref.get()))).writer().accept(buffer, value);
        });
    }

    public static SyncPreferencesMessage decode(PacketBuffer buffer) {
        SyncPreferencesMessage message = new SyncPreferencesMessage();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            Preference preference = (Preference)buffer.func_179257_a(Preference.class);
            Object value = preference.reader().apply(buffer);
            message.preferences.put(preference, value);
        }
        return message;
    }

    public static void handle(SyncPreferencesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isServer() && context.getSender() != null) {
                ServerPlayerEntity player = context.getSender();
                SyncPreferencesMessage.savePreferences((PlayerEntity)player, message.preferences);
            }
        });
        context.setPacketHandled(true);
    }

    private static void savePreferences(PlayerEntity player, EnumMap<Preference, Object> preferences) {
        CompoundNBT nbt = player.getPersistentData();
        CompoundNBT preferencesTag = new CompoundNBT();
        for (Preference preference : Preference.values()) {
            preferencesTag.func_218657_a(preference.key(), NBTHelper.serialize(preferences.get((Object)preference)));
        }
        nbt.func_218657_a("ColdSweatPreferences", (INBT)preferencesTag);
    }
}

