/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DryingItemData
extends ConfigData
implements RequirementHolder {
    private final NegatableList<ItemRequirement> item;
    private final ItemStack result;
    private final NegatableList<EntityRequirement> entity;
    private final SoundEvent sound;
    public static final Codec<DryingItemData> CODEC = DryingItemData.createCodec(RecordCodecBuilder.mapCodec(builder -> builder.group((App)NegatableList.codec(ItemRequirement.CODEC).fieldOf("item").forGetter(data -> data.item), (App)ItemStack.field_234691_a_.optionalFieldOf("result", (Object)ItemStack.field_190927_a).forGetter(data -> data.result), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(data -> data.entity), (App)SoundEvent.field_232678_a_.optionalFieldOf("sound", (Object)SoundEvents.field_211418_dr).forGetter(data -> data.sound)).apply((Applicative)builder, DryingItemData::new)));

    public DryingItemData(NegatableList<ItemRequirement> item, ItemStack result, NegatableList<EntityRequirement> entity, SoundEvent sound, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.item = item;
        this.result = result;
        this.entity = entity;
        this.sound = sound;
    }

    public DryingItemData(NegatableList<ItemRequirement> item, ItemStack result, NegatableList<EntityRequirement> entity, SoundEvent sound) {
        this(item, result, entity, sound, new NegatableList<String>(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)result.func_77973_b()).func_110624_b()));
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public ItemStack result() {
        return this.result.func_77946_l();
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public SoundEvent sound() {
        return this.sound;
    }

    public static DryingItemData fromToml(List<?> entry) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing drying item config: not enough arguments");
            return null;
        }
        NegatableList<Either<ITag<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        Item useResult = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)entry.get(1)));
        if (useResult == null) {
            return null;
        }
        ResourceLocation sound = entry.size() > 2 ? new ResourceLocation((String)entry.get(2)) : new ResourceLocation("minecraft:block.wet_grass.step");
        ItemRequirement input = new ItemRequirement(items, new NbtRequirement());
        DryingItemData result = new DryingItemData(new NegatableList<ItemRequirement>(input), new ItemStack((IItemProvider)useResult), new NegatableList<EntityRequirement>(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(sound));
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    @Override
    public boolean test(Entity entity) {
        return this.entity.test((T req) -> req.test(entity));
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T req) -> req.test(stack, true));
    }

    public Codec<? extends ConfigData> getCodec() {
        return CODEC;
    }
}

