/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.FluidRequirement;
import com.momosoftworks.coldsweat.data.codec.util.BlockInWorld;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.data.codec.util.WorldTempBounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class LocationRequirement {
    private final IntegerBounds x;
    private final IntegerBounds y;
    private final IntegerBounds z;
    int xOffset;
    int yOffset;
    int zOffset;
    private final NegatableList<RegistryKey<Biome>> biome;
    private final NegatableList<RegistryKey<Structure<?>>> structure;
    private final NegatableList<RegistryKey<World>> dimension;
    private final IntegerBounds light;
    private final BlockRequirement block;
    private final FluidRequirement fluid;
    private final WorldTempBounds temperature;
    private final Optional<Predicate<BlockInWorld>> predicate;
    public static final Codec<LocationRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntegerBounds.CODEC.optionalFieldOf("x", (Object)IntegerBounds.NONE).forGetter(location -> location.x), (App)IntegerBounds.CODEC.optionalFieldOf("y", (Object)IntegerBounds.NONE).forGetter(location -> location.y), (App)IntegerBounds.CODEC.optionalFieldOf("z", (Object)IntegerBounds.NONE).forGetter(location -> location.z), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(location -> location.xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(location -> location.yOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(location -> location.zOffset), (App)NegatableList.codec(ExtraCodecs.registry(Registry.field_239720_u_)).optionalFieldOf("biome", new NegatableList()).forGetter(location -> location.biome), (App)NegatableList.codec(ExtraCodecs.registry(Registry.field_239671_I_)).optionalFieldOf("structure", new NegatableList()).forGetter(location -> location.structure), (App)NegatableList.codec(ExtraCodecs.registry(Registry.field_239699_ae_)).optionalFieldOf("dimension", new NegatableList()).forGetter(location -> location.dimension), (App)IntegerBounds.CODEC.optionalFieldOf("light", (Object)IntegerBounds.NONE).forGetter(location -> location.light), (App)BlockRequirement.CODEC.optionalFieldOf("block", (Object)BlockRequirement.NONE).forGetter(location -> location.block), (App)FluidRequirement.CODEC.optionalFieldOf("fluid", (Object)FluidRequirement.NONE).forGetter(location -> location.fluid), (App)WorldTempBounds.CODEC.optionalFieldOf("temperature", (Object)WorldTempBounds.NONE).forGetter(location -> location.temperature)).apply((Applicative)instance, LocationRequirement::new));
    public static final LocationRequirement NONE = new LocationRequirement(IntegerBounds.NONE, IntegerBounds.NONE, IntegerBounds.NONE, 0, 0, 0, new NegatableList<RegistryKey<Biome>>(), new NegatableList(), new NegatableList<RegistryKey<World>>(), IntegerBounds.NONE, BlockRequirement.NONE, FluidRequirement.NONE, WorldTempBounds.NONE);

    public LocationRequirement(IntegerBounds x, IntegerBounds y, IntegerBounds z, int xOffset, int yOffset, int zOffset, NegatableList<RegistryKey<Biome>> biome, NegatableList<RegistryKey<Structure<?>>> structure, NegatableList<RegistryKey<World>> dimension, IntegerBounds light, BlockRequirement block, FluidRequirement fluid, WorldTempBounds temperature, Optional<Predicate<BlockInWorld>> predicate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.biome = biome;
        this.structure = structure;
        this.dimension = dimension;
        this.light = light;
        this.block = block;
        this.fluid = fluid;
        this.temperature = temperature;
        this.predicate = predicate;
    }

    public LocationRequirement(IntegerBounds x, IntegerBounds y, IntegerBounds z, int xOffset, int yOffset, int zOffset, NegatableList<RegistryKey<Biome>> biome, NegatableList<RegistryKey<Structure<?>>> structure, NegatableList<RegistryKey<World>> dimension, IntegerBounds light, BlockRequirement block, FluidRequirement fluid, WorldTempBounds temperature) {
        this(x, y, z, xOffset, yOffset, zOffset, biome, structure, dimension, light, block, fluid, temperature, Optional.empty());
    }

    public LocationRequirement(Predicate<BlockInWorld> predicate) {
        this(IntegerBounds.NONE, IntegerBounds.NONE, IntegerBounds.NONE, 0, 0, 0, new NegatableList<RegistryKey<Biome>>(), new NegatableList(), new NegatableList<RegistryKey<World>>(), IntegerBounds.NONE, BlockRequirement.NONE, FluidRequirement.NONE, WorldTempBounds.NONE, Optional.of(predicate));
    }

    public IntegerBounds x() {
        return this.x;
    }

    public IntegerBounds y() {
        return this.y;
    }

    public IntegerBounds z() {
        return this.z;
    }

    public int xOffset() {
        return this.xOffset;
    }

    public int yOffset() {
        return this.yOffset;
    }

    public int zOffset() {
        return this.zOffset;
    }

    public NegatableList<RegistryKey<Biome>> biome() {
        return this.biome;
    }

    public NegatableList<RegistryKey<Structure<?>>> structure() {
        return this.structure;
    }

    public NegatableList<RegistryKey<World>> dimension() {
        return this.dimension;
    }

    public IntegerBounds light() {
        return this.light;
    }

    public BlockRequirement block() {
        return this.block;
    }

    public FluidRequirement fluid() {
        return this.fluid;
    }

    public WorldTempBounds temperature() {
        return this.temperature;
    }

    public boolean test(World level, Vector3d pos) {
        return this.test(level, new BlockPos(pos));
    }

    public boolean test(World level, BlockPos origin) {
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(new BlockInWorld((IWorldReader)level, origin, true));
        }
        BlockPos.Mutable pos = origin.func_239590_i_();
        pos.func_196234_d(this.xOffset, this.yOffset, this.zOffset);
        if (!this.x.test(pos.func_177958_n())) {
            return false;
        }
        if (!this.y.test(pos.func_177956_o())) {
            return false;
        }
        if (!this.z.test(pos.func_177952_p())) {
            return false;
        }
        DynamicRegistries registryAccess = level.func_241828_r();
        if (!this.dimension.test(key -> level.func_234923_W_().equals(key))) {
            return false;
        }
        if (!this.biome.test(key -> registryAccess.func_243612_b(Registry.field_239720_u_).func_177774_c((Object)level.func_225523_d_().func_235201_b_((BlockPos)pos)).equals((Object)key.func_240901_a_()))) {
            return false;
        }
        if (!this.structure.test(structure -> WorldHelper.getServerLevel(level).func_241112_a_().func_235010_a_((BlockPos)pos, false, (Structure)registryAccess.func_243612_b(Registry.field_239671_I_).func_230516_a_(structure)) != StructureStart.field_214630_a)) {
            return false;
        }
        if (!this.light.test(level.func_201696_r((BlockPos)pos))) {
            return false;
        }
        if (!this.block.test(level, (BlockPos)pos)) {
            return false;
        }
        if (!this.fluid.test(level, (BlockPos)pos)) {
            return false;
        }
        return this.temperature == WorldTempBounds.NONE || this.temperature.test(WorldHelper.getRoughTemperatureAt(level, (BlockPos)pos));
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationRequirement that = (LocationRequirement)obj;
        return this.x.equals(that.x) && this.y.equals(that.y) && this.z.equals(that.z) && this.biome.equals(that.biome) && this.structure.equals(that.structure) && this.dimension.equals(that.dimension) && this.light.equals(that.light) && this.block.equals(that.block) && this.fluid.equals(that.fluid);
    }
}

