/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.api.event.vanilla.BlockStateChangedEvent;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class MixinBlockUpdate {

    @Mixin(value={ClientWorld.class})
    public static final class Client {
        @Inject(method={"sendBlockUpdated"}, at={@At(value="HEAD")})
        private void onBlockUpdate(BlockPos pos, BlockState oldState, BlockState newState, int flags, CallbackInfo ci) {
            MinecraftForge.EVENT_BUS.post((Event)new BlockStateChangedEvent(pos, (World)((ClientWorld)this), oldState, newState));
        }
    }

    @Mixin(value={ServerWorld.class})
    public static final class Server {
        ServerWorld level = (ServerWorld)this;

        @Inject(method={"onBlockStateChange"}, at={@At(value="HEAD")})
        private void onBlockUpdate(BlockPos pos, BlockState oldState, BlockState newState, CallbackInfo ci) {
            if (!oldState.equals(newState)) {
                this.level.func_73046_m().execute(() -> MinecraftForge.EVENT_BUS.post((Event)new BlockStateChangedEvent(pos, (World)this.level, oldState, newState)));
            }
        }
    }
}

