/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.IceBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.IFluidBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class}, priority=900)
public abstract class MixinFreezingWater {
    @Inject(method={"shouldFreeze(Lnet/minecraft/world/IWorldReader;Lnet/minecraft/util/math/BlockPos;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldFreezeBlock(IWorldReader levelReader, BlockPos pos, boolean mustBeAtEdge, CallbackInfoReturnable<Boolean> cir) {
        if (!ConfigSettings.USE_CUSTOM_WATER_FREEZE_BEHAVIOR.get().booleanValue()) {
            return;
        }
        if (!(levelReader instanceof ServerWorld)) {
            return;
        }
        ServerWorld level = (ServerWorld)levelReader;
        if (level.func_82736_K().func_223592_c(GameRules.field_223610_m) == 0) {
            cir.setReturnValue((Object)false);
            return;
        }
        BlockState state = level.func_180495_p(pos);
        if (state.func_204520_s().func_206886_c() != Fluids.field_204546_a || !(state.func_177230_c() instanceof IFluidBlock)) {
            return;
        }
        if (ConfigSettings.COLD_SOUL_FIRE.get().booleanValue() && WorldHelper.nextToSoulFire((IWorld)level, pos)) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (WorldHelper.shouldFreeze((IWorld)level, pos, mustBeAtEdge)) {
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Mixin(value={IceBlock.class})
    public static abstract class IceMelt {
        @Shadow
        protected abstract void func_196454_d(BlockState var1, World var2, BlockPos var3);

        @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
        private void randomTick(BlockState state, ServerWorld level, BlockPos pos, Random random, CallbackInfo ci) {
            if (!ConfigSettings.USE_CUSTOM_WATER_FREEZE_BEHAVIOR.get().booleanValue()) {
                return;
            }
            ci.cancel();
            if (!(!WorldHelper.shouldMelt((IWorld)level, pos, true) || ConfigSettings.COLD_SOUL_FIRE.get().booleanValue() && WorldHelper.nextToSoulFire((IWorld)level, pos))) {
                this.func_196454_d(state, (World)level, pos);
            }
        }
    }
}

