/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.math;

import com.google.common.collect.BiMap;
import com.momosoftworks.coldsweat.util.math.FastMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FastBiMap<K, V>
implements BiMap<K, V>,
Serializable {
    private final FastMap<K, V> forward;
    private final FastMap<V, K> backward;
    private transient InverseMap inverse;

    public FastBiMap() {
        this(256);
    }

    public FastBiMap(int capacity) {
        this.forward = new FastMap(capacity);
        this.backward = new FastMap(capacity);
    }

    public int size() {
        return this.forward.size();
    }

    public boolean isEmpty() {
        return this.forward.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.forward.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.backward.containsKey(value);
    }

    public V get(Object key) {
        return this.forward.getEqual(key);
    }

    public K getKey(V value) {
        return this.backward.getEqual(value);
    }

    public V put(K key, V value) {
        K oldKey;
        V oldValue = this.forward.put((Object)key, (Object)value);
        if (oldValue != null) {
            this.backward.remove(oldValue);
        }
        if ((oldKey = this.backward.put((Object)value, (Object)key)) != null && !oldKey.equals(key)) {
            this.forward.remove(oldKey);
        }
        return oldValue;
    }

    @Nullable
    public V forcePut(K key, V value) {
        V oldValue = this.forward.put((Object)key, (Object)value);
        this.backward.put((Object)value, (Object)key);
        return oldValue;
    }

    public V remove(Object key) {
        V value = this.forward.remove(key);
        if (value != null) {
            this.backward.remove(value);
        }
        return value;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.forward.clear();
        this.backward.clear();
    }

    public Set<K> keySet() {
        return this.forward.keySet();
    }

    public Set<V> values() {
        return this.backward.keySet();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new InvertibleEntrySet();
    }

    public FastBiMap<V, K> inverse() {
        InverseMap result = this.inverse;
        return result == null ? (this.inverse = new InverseMap()) : result;
    }

    private class InvertibleEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> delegate;

        InvertibleEntry(Map.Entry<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public K getKey() {
            return this.delegate.getKey();
        }

        @Override
        public V getValue() {
            return this.delegate.getValue();
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.delegate.setValue(value);
            FastBiMap.this.backward.remove(oldValue);
            FastBiMap.this.backward.put(value, this.getKey());
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.getKey().equals(e.getKey()) && this.getValue().equals(e.getValue());
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class InvertibleEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> delegate;

        InvertibleEntryIterator(FastMap<K, V> map) {
            this.delegate = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new InvertibleEntry(this.delegate.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    private class InvertibleEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private InvertibleEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new InvertibleEntryIterator(FastBiMap.this.forward);
        }

        @Override
        public int size() {
            return FastBiMap.this.size();
        }
    }

    private class InverseMap
    extends FastBiMap<V, K> {
        InverseMap() {
            super(FastBiMap.this.size());
        }

        @Override
        public K get(Object key) {
            return FastBiMap.this.getKey(key);
        }

        @Override
        public K put(V key, K value) {
            return FastBiMap.this.getKey(FastBiMap.this.put(value, key));
        }

        @Override
        public Set<Map.Entry<V, K>> entrySet() {
            return new InvertibleEntrySet(){

                @Override
                public Iterator<Map.Entry<V, K>> iterator() {
                    return new InvertibleEntryIterator(FastBiMap.this.backward);
                }
            };
        }

        @Override
        public FastBiMap<K, V> inverse() {
            return FastBiMap.this;
        }
    }
}

