/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.world;

import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class SpreadPath {
    public final Direction direction;
    public final BlockPos pos;
    public final int x;
    public final int y;
    public final int z;
    public boolean frozen = false;
    public BlockPos origin;

    public SpreadPath(BlockPos pos, Direction direction) {
        this.direction = direction;
        this.pos = pos;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public SpreadPath(BlockPos pos) {
        this(pos, Direction.UP);
    }

    public SpreadPath(int x, int y, int z, Direction direction) {
        this.direction = direction;
        this.pos = new BlockPos(x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SpreadPath setOrigin(BlockPos origin) {
        this.origin = origin;
        return this;
    }

    public SpreadPath offset(int x, int y, int z) {
        return new SpreadPath(this.x + x, this.y + y, this.z + z, this.direction);
    }

    public SpreadPath offset(Direction dir) {
        return this.offset(dir, 1);
    }

    public SpreadPath offset(Direction dir, int steps) {
        return this.offset(dir.func_82601_c() * steps, dir.func_96559_d() * steps, dir.func_82599_e() * steps);
    }

    public SpreadPath offset(BlockPos pos) {
        return this.offset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public SpreadPath spreadTo(BlockPos pos) {
        return this.spreadTo(pos, CSMath.getDirectionFrom(this.pos, pos));
    }

    public SpreadPath spreadTo(Direction dir) {
        return this.spreadTo(this.pos.func_177972_a(dir), dir);
    }

    public SpreadPath spreadTo(BlockPos pos, Direction dir) {
        SpreadPath path = new SpreadPath(pos, dir);
        path.setOrigin(this.origin);
        return path;
    }

    public boolean withinDistance(Vector3i vector, double distance) {
        return this.distanceSq(vector.func_177958_n(), vector.func_177956_o(), vector.func_177952_p()) < distance * distance;
    }

    public double distanceSq(double x, double y, double z) {
        double d1 = (double)this.x - x;
        double d2 = (double)this.y - y;
        double d3 = (double)this.z - z;
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public boolean equals(Object o) {
        return o instanceof SpreadPath && this.pos.equals((Object)((SpreadPath)o).pos);
    }
}

