/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryItemsTempModifier
extends TempModifier {
    private final Map<Temperature.Trait, Double> effectsPerTrait = new EnumMap<Temperature.Trait, Double>(Temperature.Trait.class);

    public InventoryItemsTempModifier(double temp) {
        this.getNBT().m_128347_("Effect", temp);
    }

    public InventoryItemsTempModifier() {
        this(0.0);
    }

    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        return temp -> temp + this.effectsPerTrait.getOrDefault((Object)trait, 0.0);
    }

    @Override
    public void tick(LivingEntity entity) {
        this.effectsPerTrait.clear();
        HashMap effectsPerItemTemp = new HashMap();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)item).forEach(itemData -> InventoryItemsTempModifier.checkAndAddItemTemp(entity, stack, -1, slot, itemData, effectsPerItemTemp));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (Slot slot : player.f_36095_.f_38839_) {
                ItemStack stack = slot.m_7993_();
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                ConfigSettings.ITEM_TEMPERATURES.get().get((Object)item).forEach(itemData -> InventoryItemsTempModifier.checkAndAddItemTemp(entity, stack, slot.getSlotIndex(), null, itemData, effectsPerItemTemp));
            }
        }
        for (Map.Entry entry : effectsPerItemTemp.entrySet()) {
            Temperature.Trait dataTrait = ((ItemTempData)entry.getKey()).trait();
            double temp = (Double)entry.getValue();
            this.effectsPerTrait.put(dataTrait, this.effectsPerTrait.getOrDefault((Object)dataTrait, 0.0) + temp);
        }
    }

    private static void checkAndAddItemTemp(LivingEntity entity, ItemStack stack, int slot, EquipmentSlot equipmentSlot, ItemTempData itemData, Map<ItemTempData, Double> effectsPerItemTemp) {
        if (itemData.test((Entity)entity, stack, slot, equipmentSlot)) {
            double temp = itemData.temperature() * (double)stack.m_41613_();
            double currentEffect = effectsPerItemTemp.getOrDefault(itemData, 0.0);
            double newEffect = temp > 0.0 ? Math.min(itemData.maxEffect(), currentEffect + temp) : Math.max(-itemData.maxEffect().doubleValue(), currentEffect + temp);
            effectsPerItemTemp.put(itemData, newEffect);
        }
    }
}

