/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.tooltip.ClientSoulspringTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.InsulationAttributeTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.InsulationTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.SoulspringTooltip;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.enums.InsulationVisibility;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncItemPredicatesMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TooltipHandler {
    public static final Style COLD = Style.f_131099_.m_178520_(3767039);
    public static final Style HOT = Style.f_131099_.m_178520_(16736574);
    public static final Component EXPAND_TOOLTIP = Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)"Shift").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.DARK_GRAY));
    private static int HOVERED_ITEM_UPDATE_COOLDOWN = 0;
    private static ItemStack HOVERED_STACK = ItemStack.f_41583_;
    public static HashMap<UUID, Boolean> HOVERED_STACK_PREDICATES = new HashMap();
    static int FUEL_FADE_TIMER = 0;

    public static <T extends ConfigData> boolean passesRequirement(T element) {
        return HOVERED_STACK_PREDICATES.getOrDefault(element.uuid(), true);
    }

    public static boolean isShiftDown() {
        return Screen.m_96638_() || ConfigSettings.EXPAND_TOOLTIPS.get() != false;
    }

    public static int getTooltipTitleIndex(List<Either<FormattedText, TooltipComponent>> tooltip, ItemStack stack) {
        int tooltipStartIndex;
        block4: {
            if (tooltip.isEmpty()) {
                return 0;
            }
            String hoverName = stack.m_41786_().getString();
            if (CompatManager.isIcebergLoaded()) {
                tooltipStartIndex = CompatManager.LegendaryTooltips.getTooltipStartIndex(tooltip) + 1;
            } else {
                for (tooltipStartIndex = 0; tooltipStartIndex < tooltip.size(); ++tooltipStartIndex) {
                    if (!tooltip.get(tooltipStartIndex).left().map(FormattedText::getString).map(String::strip).orElse("").equals(hoverName)) continue;
                    ++tooltipStartIndex;
                    break block4;
                }
                tooltipStartIndex = 1;
            }
        }
        tooltipStartIndex = CSMath.clamp(tooltipStartIndex, 0, tooltip.size());
        return tooltipStartIndex;
    }

    public static int getTooltipEndIndex(List<Either<FormattedText, TooltipComponent>> tooltip, ItemStack stack) {
        int tooltipEndIndex = tooltip.size();
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            --tooltipEndIndex;
            while (tooltipEndIndex > 0) {
                String itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
                if (tooltip.get(tooltipEndIndex).left().map(text -> text.getString().equals(itemId)).orElse(false).booleanValue()) break;
                --tooltipEndIndex;
            }
        }
        tooltipEndIndex = CSMath.clamp(tooltipEndIndex, 0, tooltip.size());
        return tooltipEndIndex;
    }

    public static void addModifierTooltipLines(List<Component> tooltip, AttributeModifierMap map, boolean showIcon, boolean strikethrough) {
        map.getMap().asMap().forEach((attribute, modifiers) -> {
            for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
                double value = 0.0;
                for (AttributeModifier modifier : modifiers.stream().filter(mod -> mod.m_22217_() == operation).toList()) {
                    value += modifier.m_22218_();
                }
                if (value == 0.0) continue;
                tooltip.add((Component)TooltipHandler.getFormattedAttributeModifier(attribute, value, operation, showIcon, strikethrough));
            }
        });
    }

    public static MutableComponent getFormattedAttributeModifier(Attribute attribute, double amount, AttributeModifier.Operation operation, boolean forTooltip, boolean strikethrough) {
        MutableComponent component;
        String percent;
        String sign;
        ChatFormatting color;
        String operationString;
        if (attribute == null) {
            return Component.m_237119_();
        }
        double value = amount;
        String attributeName = attribute.m_22087_().replace("attribute.", "");
        if (operation == AttributeModifier.Operation.ADDITION && (attribute == ModAttributes.FREEZING_POINT || attribute == ModAttributes.BURNING_POINT || attribute == ModAttributes.WORLD_TEMPERATURE)) {
            value = Temperature.convert(value, Temperature.Units.MC, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, false);
        }
        String string = operationString = operation == AttributeModifier.Operation.ADDITION ? "add" : "multiply";
        if (value >= 0.0) {
            color = ChatFormatting.BLUE;
            sign = "+";
        } else {
            color = ChatFormatting.RED;
            sign = "";
        }
        if (operation != AttributeModifier.Operation.ADDITION || attribute == ModAttributes.HEAT_RESISTANCE || attribute == ModAttributes.COLD_RESISTANCE || attribute == ModAttributes.HEAT_DAMPENING || attribute == ModAttributes.COLD_DAMPENING) {
            percent = "%";
            value *= 100.0;
        } else {
            percent = "";
        }
        ArrayList<CallSite> params = new ArrayList<CallSite>(List.of(sign + CSMath.formatDoubleOrInt(CSMath.round(value, 2)) + percent));
        if (EntityTempManager.isTemperatureAttribute(attribute)) {
            component = Component.m_237110_((String)String.format("attribute.cold_sweat.modifier.%s.%s", operationString, attributeName), (Object[])params.toArray());
        } else {
            component = TooltipHandler.getFormattedVanillaAttributeModifier(attribute, amount, operation);
            TranslatableContents contents = (TranslatableContents)component.m_214077_();
            params.addAll(0, Arrays.asList(contents.m_237523_()));
            component = TooltipHandler.setComponentContents(TooltipHandler.getFormattedVanillaAttributeModifier(attribute, amount, operation), (ComponentContents)new TranslatableContents(contents.m_237508_(), params.toArray()));
        }
        component = component.m_130940_(color);
        component = TooltipHandler.addTooltipFlags(component, forTooltip, strikethrough);
        return component;
    }

    public static MutableComponent getFormattedVanillaAttributeModifier(Attribute attribute, double amount, AttributeModifier.Operation operation) {
        double adjustedAmount = operation == AttributeModifier.Operation.ADDITION ? (attribute.equals(Attributes.f_22278_) ? amount * 10.0 : amount) : amount * 100.0;
        if (amount >= 0.0) {
            return Component.m_237110_((String)("attribute.modifier.plus." + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(adjustedAmount), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE);
        }
        return Component.m_237110_((String)("attribute.modifier.take." + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(adjustedAmount *= -1.0), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.RED);
    }

    public static MutableComponent setComponentContents(MutableComponent component, ComponentContents newContents) {
        MutableComponent newComponent = MutableComponent.m_237204_((ComponentContents)newContents).m_6270_(component.m_7383_());
        component.m_7360_().forEach(arg_0 -> ((MutableComponent)newComponent).m_7220_(arg_0));
        return newComponent;
    }

    public static MutableComponent addTooltipFlags(MutableComponent component, boolean showIcon, boolean strikethrough) {
        ComponentContents componentContents = component.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(translatable.m_237523_()));
            if (showIcon) {
                params.add("show_icon");
            }
            if (strikethrough) {
                params.add("strikethrough");
            }
            MutableComponent newComponent = TooltipHandler.setComponentContents(component, (ComponentContents)new TranslatableContents(translatable.m_237508_(), params.toArray()));
            if (strikethrough) {
                newComponent.m_6270_(Style.f_131099_.m_178520_(7561572));
            }
            return newComponent;
        }
        return component;
    }

    @SubscribeEvent
    public static void updateHoveredItem(RenderTooltipEvent.Pre event) {
        ItemStack stack = event.getItemStack();
        if (!HOVERED_STACK.equals(stack)) {
            AbstractContainerScreen menu;
            Slot hoveredSlot;
            int slotIndex = -1;
            EquipmentSlot equipmentSlot = null;
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof AbstractContainerScreen && (hoveredSlot = (menu = (AbstractContainerScreen)screen).getSlotUnderMouse()) != null) {
                slotIndex = hoveredSlot.getSlotIndex();
                equipmentSlot = EntityHelper.getEquipmentSlot(slotIndex);
            }
            if (stack.m_41619_()) {
                HOVERED_STACK = stack;
            } else if (HOVERED_ITEM_UPDATE_COOLDOWN <= 0) {
                HOVERED_STACK = stack;
                HOVERED_ITEM_UPDATE_COOLDOWN = 5;
                ColdSweatPacketHandler.INSTANCE.sendToServer((Object)SyncItemPredicatesMessage.fromClient(stack.m_41777_(), slotIndex, equipmentSlot));
            }
        }
    }

    @SubscribeEvent
    public static void tickHoverCooldown(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && HOVERED_ITEM_UPDATE_COOLDOWN > 0) {
            --HOVERED_ITEM_UPDATE_COOLDOWN;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addCustomTooltips(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        List elements = event.getTooltipElements();
        InsulationVisibility insulationVisibility = ConfigSettings.INSULATION_VISIBILITY.get();
        if (stack.m_41619_()) {
            return;
        }
        int tooltipStartIndex = TooltipHandler.getTooltipTitleIndex(elements, stack);
        int tooltipEndIndex = TooltipHandler.getTooltipEndIndex(elements, stack);
        if (stack.m_41720_() instanceof SoulspringLampItem) {
            if (!TooltipHandler.isShiftDown() && ConfigSettings.ENABLE_HINTS.get().booleanValue()) {
                elements.add(tooltipStartIndex, Either.left((Object)EXPAND_TOOLTIP));
            }
            elements.add(tooltipStartIndex, Either.right((Object)new SoulspringTooltip(stack.m_41784_().m_128459_("Fuel"))));
        }
        if (stack.m_41780_() == UseAnim.DRINK || stack.m_41780_() == UseAnim.EAT) {
            int dietTooltipSectionIndex = CSMath.getIndexOf(elements, line -> line.left().map(text -> text.getString().equalsIgnoreCase(Component.m_237115_((String)"tooltip.diet.eaten").getString())).orElse(false));
            int index = dietTooltipSectionIndex != -1 ? dietTooltipSectionIndex + 1 : tooltipEndIndex;
            FastMap<Integer, Double> foodTemps = new FastMap<Integer, Double>();
            for (FoodData foodData : ConfigSettings.FOOD_TEMPERATURES.get().get((Object)item)) {
                if (!TooltipHandler.passesRequirement(foodData)) continue;
                foodTemps.merge(foodData.duration(), foodData.temperature(), Double::sum);
            }
            for (Map.Entry entry : foodTemps.entrySet()) {
                MutableComponent consumeEffects;
                double temp = (Double)entry.getValue();
                int duration = (Integer)entry.getKey();
                MutableComponent mutableComponent = temp > 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.formatDoubleOrInt(temp)}).m_130948_(HOT) : (consumeEffects = temp == 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.formatDoubleOrInt(temp)}) : Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{CSMath.formatDoubleOrInt(temp)}).m_130948_(COLD));
                if (duration > 0) {
                    consumeEffects.m_130946_(" (" + StringUtil.m_14404_((int)duration) + ")");
                }
                elements.add(index, Either.left((Object)consumeEffects));
            }
            if (!foodTemps.isEmpty() && dietTooltipSectionIndex == -1) {
                elements.add(tooltipEndIndex, Either.left((Object)Component.m_237115_((String)"tooltip.cold_sweat.consumed").m_130940_(ChatFormatting.GRAY)));
                elements.add(tooltipEndIndex, Either.left((Object)Component.m_237119_()));
            }
        }
        ArrayList<InsulatorData> allUnmetInsulation = new ArrayList<InsulatorData>();
        if (insulationVisibility.canShow() && !stack.m_41619_()) {
            TooltipHandler.addInsulationTooltips(elements, tooltipStartIndex, stack, item, insulationVisibility, allUnmetInsulation);
        }
        int unmetLabelIndex = TooltipHandler.convertAndSortUnmetAttributes(elements);
        if (ConfigSettings.ENABLE_HINTS.get().booleanValue()) {
            TooltipHandler.addUnmetRequirementHints(elements, unmetLabelIndex, allUnmetInsulation);
        }
    }

    private static void addInsulationTooltips(List<Either<FormattedText, TooltipComponent>> elements, int tooltipStartIndex, ItemStack stack, Item item, InsulationVisibility insulationVisibility, List<InsulatorData> allUnmetInsulation) {
        ArrayList<InsulatorData> armorInsulation = new ArrayList<InsulatorData>();
        ArrayList<InsulatorData> unmetArmorInsulation = new ArrayList<InsulatorData>();
        for (InsulatorData insulator : ConfigSettings.INSULATING_ARMORS.get().get((Object)item)) {
            TooltipHandler.validateInsulator(insulator, armorInsulation, unmetArmorInsulation, allUnmetInsulation);
        }
        ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
            if (cap.getInsulation().isEmpty()) {
                cap.deserializeNBT((Tag)stack.m_41784_());
            }
            List<Pair<ItemStack, List<InsulatorData>>> insulatorPairs = cap.getInsulation();
            for (int i = 0; i < insulatorPairs.size(); ++i) {
                Pair<ItemStack, List<InsulatorData>> pair = insulatorPairs.get(i);
                for (InsulatorData insulator : (List)pair.getSecond()) {
                    TooltipHandler.validateInsulator(insulator, armorInsulation, unmetArmorInsulation, allUnmetInsulation);
                }
            }
        });
        if (!armorInsulation.isEmpty() || insulationVisibility.showsIfEmpty()) {
            elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(armorInsulation, Insulation.Slot.ARMOR, stack, false)));
        }
        if (!unmetArmorInsulation.isEmpty()) {
            elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(unmetArmorInsulation, Insulation.Slot.ARMOR, stack, true)));
        }
        ArrayList<InsulatorData> insulation = new ArrayList<InsulatorData>();
        ArrayList<InsulatorData> unmetInsulation = new ArrayList<InsulatorData>();
        Iterator iterator = ConfigSettings.INSULATION_ITEMS.get().get((Object)item).iterator();
        while (iterator.hasNext()) {
            InsulatorData insulator;
            TooltipHandler.validateInsulator(insulator, insulation, (insulator = (InsulatorData)iterator.next()).hideIfUnmet() ? new ArrayList<InsulatorData>() : unmetInsulation, allUnmetInsulation);
        }
        if (!insulation.isEmpty() && !insulation.stream().map(InsulatorData::insulation).toList().equals(armorInsulation.stream().map(InsulatorData::insulation).toList())) {
            elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(insulation, Insulation.Slot.ITEM, stack, false)));
        }
        if (!unmetInsulation.isEmpty() && !unmetInsulation.stream().map(InsulatorData::insulation).toList().equals(unmetArmorInsulation.stream().map(InsulatorData::insulation).toList())) {
            elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(unmetInsulation, Insulation.Slot.ITEM, stack, true)));
        }
        if (CompatManager.isCuriosLoaded()) {
            ArrayList<InsulatorData> curioInsulation = new ArrayList<InsulatorData>();
            ArrayList<InsulatorData> unmetCurioInsulation = new ArrayList<InsulatorData>();
            for (InsulatorData insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)item)) {
                TooltipHandler.validateInsulator(insulator, curioInsulation, unmetCurioInsulation, allUnmetInsulation);
            }
            if (!curioInsulation.isEmpty()) {
                elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(curioInsulation, Insulation.Slot.CURIO, stack, false)));
            }
            if (!unmetCurioInsulation.isEmpty()) {
                elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(unmetCurioInsulation, Insulation.Slot.CURIO, stack, true)));
            }
        }
    }

    private static int convertAndSortUnmetAttributes(List<Either<FormattedText, TooltipComponent>> elements) {
        boolean hasAttributes = false;
        boolean foundUnmetAttribute = false;
        int unmetLabelIndex = elements.size();
        int unmetAttributeIndex = elements.size();
        for (int i = 0; i < elements.size(); ++i) {
            List<Object> args;
            TranslatableContents translatableContents;
            Component component;
            ComponentContents componentContents;
            Object t;
            Either<FormattedText, TooltipComponent> element = elements.get(i);
            if (!element.left().isPresent() || !((t = element.left().get()) instanceof Component) || !((componentContents = (component = (Component)t).m_214077_()) instanceof TranslatableContents) || (translatableContents = (TranslatableContents)componentContents).m_237523_() == null) continue;
            if (translatableContents.m_237508_().contains("item.modifiers")) {
                if (!hasAttributes) {
                    hasAttributes = true;
                    unmetLabelIndex = i;
                }
                foundUnmetAttribute = false;
            }
            if (!(args = Arrays.asList(translatableContents.m_237523_())).contains("show_icon")) continue;
            boolean strikethrough = args.contains("strikethrough");
            if (strikethrough && !foundUnmetAttribute) {
                unmetAttributeIndex = i;
                foundUnmetAttribute = true;
            }
            if (!strikethrough && i > unmetAttributeIndex) {
                elements.remove(i);
                elements.add(unmetAttributeIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationAttributeTooltip(component, Minecraft.m_91087_().f_91062_, strikethrough)));
                --i;
                continue;
            }
            elements.set(i, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationAttributeTooltip(component, Minecraft.m_91087_().f_91062_, strikethrough)));
        }
        return unmetLabelIndex;
    }

    private static void addUnmetRequirementHints(List<Either<FormattedText, TooltipComponent>> elements, int unmetLabelIndex, List<InsulatorData> allUnmetInsulation) {
        int hintIndex;
        boolean addedUnmetLabel = false;
        for (hintIndex = 0; hintIndex < allUnmetInsulation.size(); ++hintIndex) {
            MutableComponent hintText;
            InsulatorData unmetInsulator = allUnmetInsulation.get(hintIndex);
            Optional<InsulatorData.HintText> hint = unmetInsulator.hint();
            if (!hint.isPresent()) continue;
            if (!addedUnmetLabel) {
                MutableComponent unmetAttributesTooltip = Component.m_237115_((String)"tooltip.cold_sweat.unmet_attributes").m_130940_(ChatFormatting.RED);
                elements.add(unmetLabelIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationAttributeTooltip((Component)unmetAttributesTooltip, Minecraft.m_91087_().f_91062_, false)));
                addedUnmetLabel = true;
            }
            if ((hintText = hint.get().getText()).getString().isEmpty()) continue;
            hintText.m_6270_(hintText.m_7383_().m_178520_(7561572));
            elements.add(unmetLabelIndex + hintIndex + 1, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationAttributeTooltip((Component)hintText, Minecraft.m_91087_().f_91062_, true)));
        }
        if (addedUnmetLabel) {
            elements.add(unmetLabelIndex + hintIndex + 1, (Either<FormattedText, TooltipComponent>)Either.left((Object)Component.m_237119_()));
        }
    }

    private static void validateInsulator(InsulatorData insulator, List<InsulatorData> insulation, List<InsulatorData> unmetInsulation, List<InsulatorData> allUnmetInsulation) {
        boolean isEmpty = insulator.insulation().isEmpty();
        if (TooltipHandler.passesRequirement(insulator)) {
            if (!isEmpty) {
                insulation.add(insulator);
            }
        } else if (!insulator.hideIfUnmet()) {
            if (!isEmpty) {
                unmetInsulation.add(insulator);
            }
            allUnmetInsulation.add(insulator);
        }
    }

    @SubscribeEvent
    public static void renderSoulLampInsertTooltip(ScreenEvent.Render.Post event) {
        AbstractContainerScreen screen;
        Screen screen2 = event.getScreen();
        if (screen2 instanceof AbstractContainerScreen && (screen = (AbstractContainerScreen)screen2).getSlotUnderMouse() != null && screen.getSlotUnderMouse().m_7993_().m_41720_() == ModItems.SOULSPRING_LAMP) {
            double fuel = screen.getSlotUnderMouse().m_7993_().m_41784_().m_128459_("Fuel");
            ItemStack carriedStack = screen.m_6262_().m_142621_();
            FuelData itemFuel = ConfigHelper.getFirstOrNull(ConfigSettings.SOULSPRING_LAMP_FUEL, carriedStack.m_41720_(), data -> data.test(carriedStack));
            if (!carriedStack.m_41619_() && itemFuel != null) {
                double fuelValue = (double)screen.m_6262_().m_142621_().m_41613_() * itemFuel.fuel();
                int slotX = screen.getSlotUnderMouse().f_40220_ + screen.getGuiLeft();
                int slotY = screen.getSlotUnderMouse().f_40221_ + screen.getGuiTop();
                PoseStack ps = event.getPoseStack();
                ps.m_85836_();
                if (event.getMouseY() < slotY + 8) {
                    ps.m_85837_(0.0, 32.0, 0.0);
                }
                event.getScreen().m_96597_(event.getPoseStack(), List.of(Component.m_237113_((String)"       ")), slotX - 18, slotY + 1);
                RenderSystem.m_69453_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)ClientSoulspringTooltip.TOOLTIP_LOCATION.get());
                GuiComponent.m_93143_((PoseStack)ps, (int)(slotX - 7), (int)(slotY - 11), (int)401, (float)0.0f, (float)0.0f, (int)30, (int)8, (int)30, (int)34);
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.15f + (float)((Math.sin((float)FUEL_FADE_TIMER / 5.0f) + 1.0) / 2.0) * 0.4f));
                GuiComponent.m_93143_((PoseStack)ps, (int)(slotX - 7), (int)(slotY - 11), (int)401, (float)0.0f, (float)8.0f, (int)Math.min(30, (int)((fuel + fuelValue) / (double)2.1333f)), (int)8, (int)30, (int)34);
                RenderSystem.m_69461_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiComponent.m_93143_((PoseStack)ps, (int)(slotX - 7), (int)(slotY - 11), (int)401, (float)0.0f, (float)16.0f, (int)((int)(fuel / (double)2.1333f)), (int)8, (int)30, (int)34);
                ps.m_85849_();
            }
        }
    }

    @SubscribeEvent
    public static void tickSoulLampInsertTooltip(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++FUEL_FADE_TIMER;
        }
    }
}

