/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public class TemperatureTraitArgument
implements ArgumentType<Temperature.Trait> {
    private final boolean includeBody;

    private TemperatureTraitArgument(boolean includeBody) {
        this.includeBody = includeBody;
    }

    public static TemperatureTraitArgument temperatureGet() {
        return new TemperatureTraitArgument(true);
    }

    public static TemperatureTraitArgument temperatureSet() {
        return new TemperatureTraitArgument(false);
    }

    public static Temperature.Trait getTemperature(CommandContext<CommandSourceStack> context, String argument) {
        return (Temperature.Trait)((Object)context.getArgument(argument, Temperature.Trait.class));
    }

    public Temperature.Trait parse(StringReader reader) {
        String s = reader.readUnquotedString();
        return Temperature.Trait.fromID(s);
    }

    private List<Temperature.Trait> getTraits() {
        int coreIndex;
        ArrayList<Temperature.Trait> traits = new ArrayList<Temperature.Trait>(Arrays.asList(EntityTempManager.VALID_TEMPERATURE_TRAITS));
        if (this.includeBody && (coreIndex = traits.indexOf((Object)Temperature.Trait.CORE)) != -1) {
            traits.add(coreIndex + 1, Temperature.Trait.BODY);
        }
        return traits;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
        return SharedSuggestionProvider.m_82970_((Iterable)this.getTraits().stream().map(Temperature.Trait::m_7912_).collect(Collectors.toList()), (SuggestionsBuilder)pBuilder);
    }

    public Collection<String> getExamples() {
        return this.getTraits().stream().map(Temperature.Trait::m_7912_).limit(2L).collect(Collectors.toList());
    }

    public static class Info
    implements ArgumentTypeInfo<TemperatureTraitArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.writeByte(template.includeBody ? 1 : 0);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            boolean includeBody = buffer.readByte() == 1;
            return new Template(includeBody);
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("include_body", Boolean.valueOf(template.includeBody));
        }

        public Template unpack(TemperatureTraitArgument argument) {
            return new Template(argument.includeBody);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<TemperatureTraitArgument> {
            private final boolean includeBody;

            public Template(boolean includeBody) {
                this.includeBody = includeBody;
            }

            public TemperatureTraitArgument instantiate(CommandBuildContext context) {
                return new TemperatureTraitArgument(this.includeBody);
            }

            public ArgumentTypeInfo<TemperatureTraitArgument, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

