/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.common.command.BaseCommand;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class ColdSweatCommand
extends BaseCommand {
    public ColdSweatCommand(String name, int permissionLevel, boolean enabled) {
        super(name, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> setExecution() {
        return (LiteralArgumentBuilder)this.builder.then(Commands.m_82127_((String)"dumpconfigs").executes(this::executeDumpConfigs));
    }

    private int executeDumpConfigs(CommandContext<CommandSourceStack> context) {
        try {
            Path dumpPath = FMLPaths.CONFIGDIR.get().resolve("coldsweat").resolve("dump");
            if (dumpPath.toFile().exists()) {
                FileUtils.deleteDirectory((File)dumpPath.toFile());
            }
            RegistryAccess registryAccess = ((CommandSourceStack)context.getSource()).m_5894_();
            File settingsFile = dumpPath.resolve("config_settings.txt").toFile();
            ArrayList settingsLines = new ArrayList();
            ConfigSettings.CONFIG_SETTINGS.forEach((location, holder) -> {
                if (holder.getCodec() == null) {
                    return;
                }
                JsonElement json = holder.getCodec().encodeStart((DynamicOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess), holder.get(registryAccess)).result().orElse(null);
                if (json == null) {
                    return;
                }
                if (json instanceof JsonObject || json instanceof JsonArray) {
                    File file = dumpPath.resolve("settings").resolve(location.m_135815_() + ".json").toFile();
                    file.getParentFile().mkdirs();
                    try {
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        JsonElement je = JsonParser.parseString((String)json.toString());
                        String prettyJsonString = gson.toJson(je);
                        FileWriter writer = new FileWriter(file);
                        writer.write(prettyJsonString);
                        writer.close();
                    }
                    catch (Exception e) {
                        ColdSweat.LOGGER.error("Error dumping config {}", location, (Object)e);
                    }
                } else {
                    String line = location.toString() + " = " + json.getAsString();
                    settingsLines.add(line);
                }
            });
            if (!settingsLines.isEmpty()) {
                settingsFile.getParentFile().mkdirs();
                try (FileWriter writer = new FileWriter(settingsFile);){
                    for (String line : settingsLines) {
                        writer.write(line + System.lineSeparator());
                    }
                }
                catch (Exception e) {
                    ColdSweat.LOGGER.error("Error writing config settings file", (Throwable)e);
                }
            }
            Style fileLinkStyle = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, dumpPath.toAbsolutePath().toString())).m_131140_(ChatFormatting.GRAY).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"mco.notification.visitUrl.buttonText.default")));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.dump.success", (Object[])new Object[]{Component.m_237113_((String)dumpPath.toString()).m_6270_(fileLinkStyle)}), true);
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.cold_sweat.dump.failure", (Object[])new Object[]{e.getMessage()}));
            ColdSweat.LOGGER.error("Error dumping Cold Sweat configs", (Throwable)e);
        }
        return 1;
    }
}

