/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.core.init.PotionInit;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PotionRecipes {
    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        ItemStack awkward = PotionRecipes.createPotion(Potions.f_43602_);
        ItemStack icePotion = PotionRecipes.createPotion((Potion)PotionInit.ICE_RESISTANCE.get());
        ItemStack longIcePotion = PotionRecipes.createPotion((Potion)PotionInit.LONG_ICE_RESISTANCE.get());
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WorkingBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{awkward}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.SOUL_SPROUT}), icePotion));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WorkingBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{icePotion}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), longIcePotion));
    }

    private static ItemStack createPotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)potion);
    }

    public static class WorkingBrewingRecipe
    extends BrewingRecipe {
        Ingredient potionIn;
        Ingredient reagent;
        ItemStack output;

        public WorkingBrewingRecipe(Ingredient potionIn, Ingredient reagent, ItemStack output) {
            super(potionIn, reagent, output);
            this.potionIn = potionIn;
            this.reagent = reagent;
            this.output = output.m_41777_();
        }

        public boolean isInput(@Nonnull ItemStack potionIn) {
            if (potionIn == null) {
                return false;
            }
            ItemStack[] matchingStacks = this.potionIn.m_43908_();
            if (matchingStacks.length == 0) {
                return potionIn.m_41619_();
            }
            return Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)potionIn));
        }

        public boolean isIngredient(ItemStack ingredient) {
            if (ingredient == null) {
                return false;
            }
            ItemStack[] matchingStacks = this.reagent.m_43908_();
            if (matchingStacks.length == 0) {
                return ingredient.m_41619_();
            }
            return Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)ingredient));
        }
    }
}

