/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement.sub_type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.EntitySubRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record LightningBoltRequirement(IntegerBounds blocksSetOnFire, EntityRequirement entityStruck) implements EntitySubRequirement
{
    public static final MapCodec<LightningBoltRequirement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntegerBounds.CODEC.optionalFieldOf("blocks_set_on_fire", (Object)IntegerBounds.NONE).forGetter(LightningBoltRequirement::blocksSetOnFire), (App)EntityRequirement.getCodec().optionalFieldOf("entity_struck", (Object)EntityRequirement.NONE).forGetter(LightningBoltRequirement::entityStruck)).apply((Applicative)instance, LightningBoltRequirement::new));

    @Override
    public MapCodec<? extends EntitySubRequirement> getCodec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(Entity entity, Level level, @Nullable Vec3 position) {
        if (!(entity instanceof LightningBolt)) return false;
        LightningBolt lightningbolt = (LightningBolt)entity;
        if (!this.blocksSetOnFire.test(lightningbolt.m_147159_())) return false;
        if (!lightningbolt.m_147160_().anyMatch(this.entityStruck::test)) return false;
        return true;
    }
}

