/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.block_temp.compat;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CreateFluidTankTemp
extends BlockTemp {
    public CreateFluidTankTemp() {
        super(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 7.0, true, (Block)AllBlocks.FLUID_TANK.get(), (Block)AllBlocks.CREATIVE_FLUID_TANK.get());
    }

    @Override
    public double getTemperature(Level level, @Nullable LivingEntity entity, BlockState state, BlockPos pos, double distance) {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)level.getBlockEntity(pos);
        if (tank != null) {
            FluidStack fluid;
            if (tank.isController()) {
                if (tank.boiler != null) {
                    int heat;
                    int n = heat = tank.boiler.passiveHeat ? 1 : tank.boiler.getTheoreticalHeatLevel();
                    if (heat > 0) {
                        return Math.min(3.0, (double)heat / 4.0);
                    }
                }
                fluid = tank.getFluid(0);
            } else {
                double fluidHeight;
                FluidTankBlockEntity controller = tank.getControllerBE();
                if (controller == null) {
                    return 0.0;
                }
                fluid = controller.getFluid(0);
                double distToController = CSMath.getDistance((Vec3i)pos, (Vec3i)controller.getBlockPos());
                if (distToController > (fluidHeight = (double)fluid.getAmount() / (double)tank.getTankSize(0))) {
                    return 0.0;
                }
            }
            if (!fluid.isEmpty()) {
                BlockState fluidState = fluid.getFluid().defaultFluidState().createLegacyBlock();
                return BlockTempRegistry.getFirstBlockTempFor(fluidState, level, pos).map(blockTemp -> blockTemp.getTemperature(level, entity, fluidState, pos, distance)).orElse(0.0);
            }
        }
        return 0.0;
    }
}

