/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.event.vanilla.EntityMoveEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;

public class FreezeMoveSpeedEffect
extends TempEffect {
    public FreezeMoveSpeedEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onPlayerTick(EntityMoveEvent event) {
        if (!this.test(event.getEntity())) {
            return;
        }
        float effect = (float)this.getEffectFactor();
        double movementReduction = ConfigSettings.COLD_MOVEMENT_SLOWDOWN.get();
        if (movementReduction == 0.0) {
            return;
        }
        float movePenalty = (float)CSMath.blend(0.0, movementReduction, (double)effect, 0.0, 1.0);
        if (movePenalty != 0.0f) {
            if (this.entity().isSprinting() && !this.entity().onGround()) {
                movePenalty *= 1.5f;
            }
            event.setSpeed(event.getSpeed() * (1.0f - Math.min(1.0f, movePenalty)));
            event.setCanceled(true);
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.SERVER;
    }
}

