/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.joml.Vector2i;

@EventBusSubscriber(value={Dist.CLIENT})
public class Overlays {
    public static final ResourceLocation BODY_TEMP_GAUGE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/body_temp_gauge.png");
    public static final ResourceLocation BODY_TEMP_GAUGE_HC = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/body_temp_gauge_hc.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/world_temp_gauge.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE_HC = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/world_temp_gauge_hc.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/vague_temp_gauge.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_HC = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/vague_temp_gauge_hc.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_STANDALONE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/vague_temp_gauge_standalone.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_STANDALONE_HC = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/vague_temp_gauge_standalone_hc.png");
    public static final ResourceLocation FOOD_EFFECT = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/food_effect_background.png");
    public static final Supplier<ResourceLocation> BODY_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? BODY_TEMP_GAUGE_HC : BODY_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> WORLD_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? WORLD_TEMP_GAUGE_HC : WORLD_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> VAGUE_TEMP_GAUGE_LOCATION = () -> ConfigSettings.BODY_ICON_ENABLED.get().booleanValue() ? (ConfigSettings.HIGH_CONTRAST.get().booleanValue() ? VAGUE_TEMP_GAUGE_HC : VAGUE_TEMP_GAUGE) : (ConfigSettings.HIGH_CONTRAST.get() != false ? VAGUE_TEMP_GAUGE_STANDALONE_HC : VAGUE_TEMP_GAUGE_STANDALONE);
    static boolean ADVANCED_WORLD_TEMP = false;
    public static double WORLD_TEMP = 0.0;
    static double PREV_WORLD_TEMP = 0.0;
    static double PLAYER_MAX_TEMP = 0.0;
    static double PLAYER_MIN_TEMP = 0.0;
    static double BODY_TEMP = 0.0;
    static double PREV_BODY_TEMP = 0.0;
    public static double BLEND_BODY_TEMP = 0.0;
    static int ICON_BOB = 0;
    static int BODY_ICON = 0;
    static int PREV_BODY_ICON = 0;
    static double BODY_TEMP_SEVERITY = 0.0;
    public static LayeredDraw.Layer WORLD_TEMP_OVERLAY = (graphics, deltaTracker) -> {
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        Font font = Minecraft.getInstance().font;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && ADVANCED_WORLD_TEMP && Minecraft.getInstance().gameMode.getPlayerMode() != GameType.SPECTATOR && !Minecraft.getInstance().options.hideGui && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue()) {
            double temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getGaugeSeverity(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            int color = Overlays.getWorldTempColor(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            graphics.blit(WORLD_TEMP_GAUGE_LOCATION.get(), width / 2 + 93 + ConfigSettings.WORLD_GAUGE_POS.get().x(), height - 19 + ConfigSettings.WORLD_GAUGE_POS.get().y(), 0.0f, (float)(64 - severity * 16), 25, 16, 25, 144);
            RenderSystem.disableBlend();
            int bob = ConfigSettings.ICON_BOBBING.get() != false && !CSMath.betweenInclusive(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP) && player.tickCount % 2 == 0 ? 1 : 0;
            int blendedTemp = (int)CSMath.blend(PREV_WORLD_TEMP, WORLD_TEMP, (double)deltaTracker.getGameTimeDeltaPartialTick(true), 0.0, 1.0);
            graphics.drawString(font, "" + (blendedTemp + ConfigSettings.TEMP_OFFSET.get()), width / 2 + 106 + Integer.toString(blendedTemp + ConfigSettings.TEMP_OFFSET.get()).length() * -3 + ConfigSettings.WORLD_GAUGE_POS.get().x(), height - 15 - bob + ConfigSettings.WORLD_GAUGE_POS.get().y(), color, false);
        }
    };
    public static LayeredDraw.Layer BODY_TEMP_OVERLAY = (graphics, deltaTracker) -> {
        Minecraft mc = Minecraft.getInstance();
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        BLEND_BODY_TEMP = CSMath.blend(PREV_BODY_TEMP, BODY_TEMP, (double)deltaTracker.getGameTimeDeltaPartialTick(true), 0.0, 1.0);
        double bodyTempInt = CSMath.roundNearest(BLEND_BODY_TEMP, 1.0);
        if (Overlays.shouldDrawSurvivalElements() && !Minecraft.getInstance().options.hideGui) {
            int color;
            int n = bodyTempInt > 0.0 ? 16744509 : (color = bodyTempInt < 0.0 ? 4233468 : 0xAFAFAF);
            int colorBG = bodyTempInt < 0.0 ? 1122643 : (bodyTempInt > 0.0 ? 5376516 : 0);
            int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
            int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.getInstance().cameraEntity.tickCount % 2 : 0));
            RenderSystem.defaultBlendFunc();
            if (ConfigSettings.BODY_ICON_ENABLED.get().booleanValue()) {
                int icon = Math.abs(bodyTempInt) < 100.0 ? CSMath.floor(BODY_TEMP_SEVERITY) : 4 * CSMath.sign(BODY_TEMP_SEVERITY);
                int iconX = width / 2 - 5 + ConfigSettings.BODY_ICON_POS.get().x();
                int iconYOffset = ADVANCED_WORLD_TEMP && ConfigSettings.MOVE_BODY_ICON_WHEN_ADVANCED.get() != false ? 54 : 47;
                int iconY = height - iconYOffset - threatOffset + ConfigSettings.BODY_ICON_POS.get().y();
                graphics.blit(BODY_TEMP_GAUGE_LOCATION.get(), iconX, iconY, 0.0f, (float)(40 - icon * 10), 10, 10, 10, 90);
                if (CSMath.betweenExclusive(Math.abs(bodyTempInt), 0.0, 100.0)) {
                    double blend = CSMath.blend(1.0, 9.0, Math.abs(BODY_TEMP_SEVERITY), (double)Math.abs(CSMath.floor(BODY_TEMP_SEVERITY)), (double)Math.abs(CSMath.ceil(BODY_TEMP_SEVERITY)));
                    graphics.blit(BODY_TEMP_GAUGE_LOCATION.get(), iconX, iconY + 10 - CSMath.ceil(blend), 0.0f, (float)(40 - CSMath.grow(icon, bodyTempInt > 0.0 ? 0 : 2) * 10 - CSMath.ceil(blend)), 10, CSMath.ceil(blend), 10, 90);
                }
            }
            if (ConfigSettings.BODY_READOUT_ENABLED.get().booleanValue() && ADVANCED_WORLD_TEMP) {
                Font font = mc.font;
                int scaledWidth = mc.getWindow().getGuiScaledWidth();
                int scaledHeight = mc.getWindow().getGuiScaledHeight();
                String s = "" + (int)Math.min(Math.abs(bodyTempInt), 100.0);
                int x = (scaledWidth - font.width(s)) / 2 + ConfigSettings.BODY_READOUT_POS.get().x();
                int y = scaledHeight - 31 - 10 + ConfigSettings.BODY_READOUT_POS.get().y();
                graphics.drawString(font, s, x + 1, y, colorBG, false);
                graphics.drawString(font, s, x - 1, y, colorBG, false);
                graphics.drawString(font, s, x, y + 1, colorBG, false);
                graphics.drawString(font, s, x, y - 1, colorBG, false);
                graphics.drawString(font, s, x, y, color, false);
                if (Math.abs(bodyTempInt) > 100.0) {
                    int textHeight = font.wordWrapHeight(s, 100);
                    int overlayHeight = (int)CSMath.roundUpNearest(CSMath.blend(2.0, (double)textHeight, Math.abs(bodyTempInt), 100.0, 150.0), 1.0);
                    int overlayColor = overlayHeight > 3 ? (bodyTempInt > 0.0 ? 0xFFFFAC : 0xB0FFFF) : (bodyTempInt > 0.0 ? 16771975 : 0x84F4FF);
                    int overlayColor2 = bodyTempInt > 0.0 ? 16759634 : 7528447;
                    ClientOnlyHelper.renderVerticalCropText(s, x, y, Math.min(textHeight, overlayHeight + 1), overlayColor2, graphics);
                    ClientOnlyHelper.renderVerticalCropText(s, x, y, overlayHeight, overlayColor, graphics);
                }
            }
        }
    };
    public static LayeredDraw.Layer VAGUE_TEMP_OVERLAY = (graphics, deltaTracker) -> {
        PoseStack poseStack = graphics.pose();
        Minecraft mc = Minecraft.getInstance();
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        LocalPlayer player = mc.player;
        if (player != null && !ADVANCED_WORLD_TEMP && mc.gameMode.getPlayerMode() != GameType.SPECTATOR && !mc.options.hideGui && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue() && Overlays.shouldDrawSurvivalElements()) {
            double temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getGaugeSeverity(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            int renderOffset = CSMath.clamp(severity, -1, 1) * 2;
            poseStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
            int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.getInstance().cameraEntity.tickCount % 2 : 0));
            graphics.blit(VAGUE_TEMP_GAUGE_LOCATION.get(), width / 2 - 8 + ConfigSettings.BODY_ICON_POS.get().x(), height - 50 + ConfigSettings.BODY_ICON_POS.get().y() - renderOffset - threatOffset, 0.0f, (float)(64 - severity * 16), 16, 16, 16, 144);
            RenderSystem.disableBlend();
            poseStack.popPose();
        }
    };
    public static LayeredDraw.Layer FOOD_EFFECTS_OVERLAY = (graphics, deltaTracker) -> {
        if (!ConfigSettings.FOOD_EFFECTS_ENABLED.get().booleanValue()) {
            return;
        }
        RenderSystem.enableBlend();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        graphics.pose().pushPose();
        Vector2i pos = ConfigSettings.FOOD_EFFECTS_POS.get();
        graphics.pose().translate((float)pos.x, (float)pos.y, 0.0f);
        int offset = 0;
        for (Map.Entry<Temperature.Trait, List<TempModifier>> entry : Temperature.getModifiers((LivingEntity)player).entrySet()) {
            Temperature.Trait trait = entry.getKey();
            ArrayList modifierList = new ArrayList(entry.getValue());
            List<FoodTempModifier> sortedModifiers = modifierList.stream().filter(mod -> mod instanceof FoodTempModifier).map(mod -> (FoodTempModifier)mod).sorted((m1, m2) -> {
                int sign2;
                int sign1 = CSMath.sign(m1.getNBT().getDouble("temperature"));
                if (sign1 != (sign2 = CSMath.sign(m2.getNBT().getDouble("temperature")))) {
                    return Integer.compare(sign1, sign2);
                }
                return Double.compare(Math.abs(m1.getNBT().getDouble("temperature")), Math.abs(m2.getNBT().getDouble("temperature")));
            }).toList();
            for (TempModifier tempModifier : sortedModifiers) {
                if (!(tempModifier instanceof FoodTempModifier)) continue;
                FoodTempModifier food = (FoodTempModifier)tempModifier;
                int x = width - 10;
                int y = height - 10 - offset;
                if (food.getNBT().getDouble("duration") == 0.0) continue;
                int timeLeft = food.getExpireTime() - food.getTicksExisted();
                double temp = food.getNBT().getDouble("temperature");
                boolean overridden = food.isOverridden(trait);
                graphics.blit(FOOD_EFFECT, x - 76, y - 24, 0.0f, 0.0f, 76, 24, 76, 24);
                String sign = temp > 0.0 ? "\u2191" : "\u2193";
                Object tempString = CSMath.formatDoubleOrInt(CSMath.round(temp, 2));
                if (temp < 0.0) {
                    tempString = ((String)tempString).substring(1);
                }
                tempString = sign + (String)tempString;
                String timerString = StringUtil.formatTickDuration((int)timeLeft, (float)player.level().tickRateManager().tickrate());
                int contentWidth = mc.font.width((String)tempString) + mc.font.width(timerString) + 20;
                int contentHeight = 16;
                x -= 76;
                graphics.pose().pushPose();
                graphics.pose().translate((float)(38 - contentWidth / 2), (float)(12 - contentHeight / 2), 0.0f);
                float brightness = overridden ? 0.35f : 1.0f;
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                if (timeLeft < 200) {
                    float alpha = (float)CSMath.blend(1.0, Math.sin((double)((float)food.getTicksExisted() + partialTick) / 1.5) / 2.0 + 0.5, (double)timeLeft, 200.0, 0.0);
                    RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                }
                Font font = mc.font;
                Objects.requireNonNull(mc.font);
                graphics.drawString(font, timerString, x, y - 9 - 11, ChatFormatting.WHITE.getColor().intValue(), true);
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)food.getNBT().getString("item")));
                graphics.renderItem(item.getDefaultInstance(), x += mc.font.width(timerString) + 2, y - 24);
                x += 18;
                Style style = temp > 0.0 ? TooltipHandler.HOT : (temp < 0.0 ? TooltipHandler.COLD : Style.EMPTY);
                MutableComponent tempText = Component.literal((String)tempString).withStyle(style);
                Font font2 = mc.font;
                Objects.requireNonNull(mc.font);
                graphics.drawString(font2, (Component)tempText, x, y - 9 - 11, tempText.getStyle().getColor().getValue(), true);
                offset += 25;
                graphics.pose().popPose();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        graphics.pose().popPose();
    };

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"vague_temp"), VAGUE_TEMP_OVERLAY);
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"body_temp"), BODY_TEMP_OVERLAY);
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"world_temp"), WORLD_TEMP_OVERLAY);
        event.registerBelow(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"food_effects"), FOOD_EFFECTS_OVERLAY);
    }

    private static boolean shouldDrawSurvivalElements() {
        return Minecraft.getInstance().gameMode.canHurtPlayer() && Minecraft.getInstance().getCameraEntity() instanceof Player;
    }

    public static double getWorldSeverity(double temp, double playerMin, double playerMax) {
        double normalMax;
        if (temp < playerMin) {
            return -1.0;
        }
        if (temp > playerMax) {
            return 1.0;
        }
        double normalMin = ConfigSettings.Difficulty.NORMAL.getSetting(ConfigSettings.MIN_TEMP);
        double mid = Overlays.calculateMidpoint(playerMin, playerMax, normalMin, normalMax = ConfigSettings.Difficulty.NORMAL.getSetting(ConfigSettings.MAX_TEMP).doubleValue());
        return temp < mid ? CSMath.blend(-1.0, 0.0, temp, playerMin, mid) : CSMath.blend(0.0, 1.0, temp, mid, playerMax);
    }

    private static double calculateMidpoint(double playerMin, double playerMax, double normalMin, double normalMax) {
        boolean bothBelowNormal = playerMin < normalMin && playerMax < normalMax;
        boolean bothAboveNormal = playerMin > normalMin && playerMax > normalMax;
        return bothBelowNormal || bothAboveNormal ? (playerMin + playerMax) / 2.0 : (normalMin + normalMax) / 2.0;
    }

    public static int getGaugeSeverity(double temp, double playerMin, double playerMax) {
        return (int)(Overlays.getWorldSeverity(temp, playerMin, playerMax) * 4.0);
    }

    static double getBodySeverity(int temp) {
        int sign = CSMath.sign(temp);
        int absTemp = Math.abs(temp);
        return absTemp < 100 ? CSMath.blend(0.0, 3.0, (double)absTemp, 0.0, 100.0) * (double)sign : CSMath.blend(3.0, 7.0, (double)absTemp, 100.0, 150.0) * (double)sign;
    }

    public static void setBodyTempInstant(double temp) {
        BODY_TEMP = temp;
        PREV_BODY_TEMP = temp;
        BLEND_BODY_TEMP = (int)temp;
    }

    public static void setWorldTempInstant(double temp) {
        WORLD_TEMP = temp;
        PREV_WORLD_TEMP = temp;
    }

    public static int getWorldTempColor(double temp, double playerMin, double playerMax) {
        int severity = Overlays.getGaugeSeverity(temp, playerMin, playerMax);
        return switch (severity) {
            case 2, 3 -> 16297781;
            case 4 -> 16728089;
            case -3, -2 -> 8443135;
            case -4 -> 4236031;
            default -> 14737376;
        };
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static final class TickOverlays {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Pre event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && player.isAlive()) {
                EntityTempManager.getTemperatureCap((Entity)player).ifPresent(arg_0 -> TickOverlays.lambda$onClientTick$0((Player)player, arg_0));
            }
        }

        private static /* synthetic */ void lambda$onClientTick$0(Player player, ITemperatureCap icap) {
            if (!(icap instanceof PlayerTempCap)) {
                return;
            }
            PlayerTempCap cap = (PlayerTempCap)icap;
            cap.calculateHudVisibility(player);
            ADVANCED_WORLD_TEMP = cap.showAdvancedWorldTemp();
            boolean celsius = ConfigSettings.CELSIUS.get();
            double worldTemp = cap.getTrait(Temperature.Trait.WORLD);
            double realTemp = Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true);
            double diff = realTemp - WORLD_TEMP;
            PREV_WORLD_TEMP = WORLD_TEMP;
            WORLD_TEMP += Math.abs(diff) <= 1.0 ? diff : CSMath.maxAbs(diff / ConfigSettings.TEMP_SMOOTHING.get(), 0.25 * (double)CSMath.sign(diff));
            PLAYER_MAX_TEMP = cap.getTrait(Temperature.Trait.BURNING_POINT);
            PLAYER_MIN_TEMP = cap.getTrait(Temperature.Trait.FREEZING_POINT);
            PREV_BODY_TEMP = BODY_TEMP;
            BODY_TEMP += (cap.getTrait(Temperature.Trait.BODY) - BODY_TEMP) / 2.0;
            ICON_BOB = player.tickCount % 3 == 0 && Math.random() < 0.3 ? 1 : 0;
            BODY_TEMP_SEVERITY = Overlays.getBodySeverity((int)BLEND_BODY_TEMP);
            int neededIcon = (int)CSMath.clamp(BODY_TEMP_SEVERITY, -4.0, 4.0);
            if (BODY_ICON != neededIcon) {
                BODY_ICON = neededIcon;
            }
        }
    }
}

