/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config;

import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;

public class ConfigLabel
extends AbstractWidget
implements GuiEventListener,
NarratableEntry {
    public final String id;

    public ConfigLabel(String id, Component text, int x, int y) {
        int n = Minecraft.getInstance().font.width((FormattedText)text);
        Objects.requireNonNull(Minecraft.getInstance().font);
        super(x, y, n, 9, text);
        this.id = id;
        this.setX(x);
        this.setY(y);
    }

    protected void renderWidget(GuiGraphics graphics, int pmousex, int mouseY, float partialTick) {
        int color = CSMath.getIfNotNull(this.getMessage().getStyle().getColor(), TextColor::getValue, 0xFFFFFF);
        graphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX(), this.getY(), color, true);
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void updateWidgetNarration(NarrationElementOutput narration) {
        narration.add(NarratedElementType.HINT, this.getMessage());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMouseOver(double mouseX, double mouseY) {
        if (!(mouseX >= (double)(this.getX() - 5))) return false;
        if (!(mouseY >= (double)(this.getY() - 5))) return false;
        if (!(mouseX < (double)(this.getX() + Minecraft.getInstance().font.width((FormattedText)this.getMessage()) + 5))) return false;
        int n = this.getY();
        Objects.requireNonNull(Minecraft.getInstance().font);
        if (!(mouseY < (double)(n + 9 + 5))) return false;
        return true;
    }
}

