/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.TempEffectsData;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.ArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class HandleTempEffects {
    @SubscribeEvent
    public static void addTempEffects(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.tickCount % 20 == 0) {
                EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                    TempEffectsData effectsData = ConfigHelper.getFirstOrNull(ConfigSettings.ENTITY_TEMP_EFFECTS, living.getType(), data -> data.test((Entity)living));
                    if (effectsData == null) {
                        return;
                    }
                    ArrayList addedEffects = new ArrayList();
                    effectsData.effects().forEach(holder -> {
                        TempEffectType effectType = holder.effect();
                        cap.addTempEffect((TempEffect)effectType.create(effectType, living, holder.range()), living.level().isClientSide);
                        addedEffects.add(effectType);
                    });
                    cap.getTempEffects().keySet().stream().filter(type -> !addedEffects.contains(type)).forEach(cap::removeTempEffect);
                });
            }
        }
    }

    @SubscribeEvent
    public static void clearTempEffects(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EntityTempManager.getTemperatureCap((Entity)living).ifPresent(ITemperatureCap::clearTempEffects);
        }
    }
}

