/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.world.feature;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.common.block.SoulStalkBlock;
import com.momosoftworks.coldsweat.common.world.feature.SoulStalkFeatureConfig;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;

public class SoulStalkFeature
extends Feature<SoulStalkFeatureConfig> {
    public SoulStalkFeature(Codec<SoulStalkFeatureConfig> config) {
        super(config);
    }

    public boolean isAirOrLeaves(WorldGenLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir() || level.getBlockState(pos).is(BlockTags.LEAVES);
    }

    public boolean place(FeaturePlaceContext<SoulStalkFeatureConfig> context) {
        SoulStalkFeatureConfig config = (SoulStalkFeatureConfig)context.config();
        WorldGenLevel level = context.level();
        BlockPos.MutableBlockPos pos = context.origin().mutable();
        int successes = 0;
        for (int t = 0; t < config.tries(); ++t) {
            pos.set((Vec3i)context.origin()).move(context.random().nextInt(config.spreadXZ()) - config.spreadXZ() / 2, context.random().nextInt(config.spreadY()) - config.spreadY() / 2, context.random().nextInt(config.spreadXZ()) - config.spreadXZ() / 2);
            int startY = pos.getY();
            int minHeight = level.getMinBuildHeight();
            int maxHeight = level.getMaxBuildHeight();
            for (int i = -10; i < 10; ++i) {
                pos.setY(startY + i);
                if (pos.getY() >= minHeight && (pos.getY() > maxHeight || level.getBlockState((BlockPos)pos).isAir() && level.getBlockState(pos.below()).isCollisionShapeFullBlock((BlockGetter)level, pos.below()))) break;
            }
            if (!level.getBlockState(pos.below()).is(ModBlockTags.SOUL_STALK_PLACEABLE_ON)) {
                SoulStalkFeature.placeDisk(level, (BlockPos)pos, config);
            }
            if (!level.getBlockState(pos.below()).is(ModBlockTags.SOUL_STALK_PLACEABLE_ON) || !level.getBlockState(pos.above()).isAir()) continue;
            level.setBlock((BlockPos)pos, (BlockState)((Block)ModBlocks.SOUL_STALK.value()).defaultBlockState().setValue(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.Section.BASE)), 2);
            int height = new Random().nextInt(5) + 2;
            for (int i = 0; i < height && this.isAirOrLeaves(level, pos.above()); ++i) {
                pos.move(0, 1, 0);
                level.setBlock((BlockPos)pos, (BlockState)((Block)ModBlocks.SOUL_STALK.value()).defaultBlockState().setValue(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())), 2);
            }
            level.setBlock((BlockPos)pos, (BlockState)((Block)ModBlocks.SOUL_STALK.value()).defaultBlockState().setValue(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.Section.TOP)), 2);
            int minCount = config.minCount();
            int maxCount = config.maxCount();
            if (++successes >= maxCount || successes >= minCount && context.random().nextInt(0, maxCount - minCount) == 0) break;
        }
        return successes > 0;
    }

    private static void placeDisk(WorldGenLevel level, BlockPos pos, SoulStalkFeatureConfig config) {
        int diskWidth = config.diskWidth();
        int diskHeight = config.diskHeight();
        double diskDecay = config.diskDecay();
        RuleBasedBlockStateProvider diskProvider = config.diskStateProvider();
        BlockPredicate diskReplacer = config.replaceBlocks();
        if (diskWidth <= 0 || diskHeight <= 0 || diskProvider == null || diskReplacer == null) {
            return;
        }
        for (int x = -diskWidth; x <= diskWidth; ++x) {
            for (int y = -diskHeight; y <= diskHeight; ++y) {
                for (int z = -diskWidth; z <= diskWidth; ++z) {
                    if (!(Math.pow((double)x / (double)diskWidth, 2.0) + Math.pow((double)y / (double)diskHeight, 2.0) + Math.pow((double)z / (double)diskWidth, 2.0) < 1.0)) continue;
                    BlockPos diskPos = pos.offset(x, y, z);
                    double distance = Math.sqrt(diskPos.distSqr((Vec3i)pos));
                    double distFactor = CSMath.blend(level.getRandom().nextDouble(), 0.0, distance, 0.0, (double)diskWidth);
                    if (!(distance <= 1.0) && !(distFactor > diskDecay) || !diskReplacer.test((Object)level, (Object)diskPos)) continue;
                    level.setBlock(diskPos, diskProvider.getState(level, level.getRandom(), diskPos), 2);
                }
            }
        }
    }
}

