/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.spec.CSConfigSpec;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;

public class WorldSettingsConfig {
    private static final CSConfigSpec SPEC;
    private static final CSConfigSpec.Builder BUILDER;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> BIOME_TEMP_OFFSETS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> BIOME_TEMPERATURES;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> DIMENSION_TEMP_OFFSETS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> DIMENSION_TEMPERATURES;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> STRUCTURE_TEMP_OFFSETS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> STRUCTURE_TEMPERATURES;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> BLOCK_TEMPERATURES;
    public static final CSConfigSpec.IntValue MAX_BLOCK_TEMP_RANGE;
    public static final CSConfigSpec.ConfigValue<Boolean> IS_SOUL_FIRE_COLD;
    public static CSConfigSpec.ConfigValue<List<?>> SUMMER_TEMPERATURES;
    public static CSConfigSpec.ConfigValue<List<?>> AUTUMN_TEMPERATURES;
    public static CSConfigSpec.ConfigValue<List<?>> WINTER_TEMPERATURES;
    public static CSConfigSpec.ConfigValue<List<?>> SPRING_TEMPERATURES;
    public static final CSConfigSpec.ConfigValue<Boolean> ENABLE_SMART_HEARTH;
    public static final CSConfigSpec.ConfigValue<Boolean> ENABLE_SMART_BOILER;
    public static final CSConfigSpec.ConfigValue<Boolean> ENABLE_SMART_ICEBOX;
    public static final CSConfigSpec.ConfigValue<Double> SOURCE_EFFECT_STRENGTH;
    public static final CSConfigSpec.ConfigValue<List<? extends String>> SOURCE_SPREAD_WHITELIST;
    public static final CSConfigSpec.ConfigValue<List<? extends String>> SOURCE_SPREAD_BLACKLIST;
    public static final CSConfigSpec.ConfigValue<Integer> HEARTH_RANGE;
    public static final CSConfigSpec.ConfigValue<Integer> HEARTH_MAX_RANGE;
    public static final CSConfigSpec.ConfigValue<Integer> HEARTH_MAX_VOLUME;
    public static final CSConfigSpec.ConfigValue<Integer> HEARTH_WARM_UP_TIME;
    public static final CSConfigSpec.ConfigValue<Integer> HEARTH_MAX_INSULATION;
    public static final CSConfigSpec.ConfigValue<Integer> HEARTH_FUEL_INTERVAL;
    public static final CSConfigSpec.ConfigValue<Integer> BOILER_RANGE;
    public static final CSConfigSpec.ConfigValue<Integer> BOILER_MAX_RANGE;
    public static final CSConfigSpec.ConfigValue<Integer> BOILER_MAX_VOLUME;
    public static final CSConfigSpec.ConfigValue<Integer> BOILER_WARM_UP_TIME;
    public static final CSConfigSpec.ConfigValue<Integer> BOILER_MAX_INSULATION;
    public static final CSConfigSpec.ConfigValue<Integer> BOILER_FUEL_INTERVAL;
    public static final CSConfigSpec.ConfigValue<Integer> ICEBOX_RANGE;
    public static final CSConfigSpec.ConfigValue<Integer> ICEBOX_MAX_RANGE;
    public static final CSConfigSpec.ConfigValue<Integer> ICEBOX_MAX_VOLUME;
    public static final CSConfigSpec.ConfigValue<Integer> ICEBOX_WARM_UP_TIME;
    public static final CSConfigSpec.ConfigValue<Integer> ICEBOX_MAX_INSULATION;
    public static final CSConfigSpec.ConfigValue<Integer> ICEBOX_FUEL_INTERVAL;
    public static final CSConfigSpec.ConfigValue<List<? extends String>> SLEEPING_OVERRIDE_BLOCKS;
    public static final CSConfigSpec.ConfigValue<Boolean> SHOULD_CHECK_SLEEP;
    public static final CSConfigSpec.ConfigValue<Boolean> CUSTOM_WATER_FREEZE_BEHAVIOR;
    public static final CSConfigSpec.ConfigValue<Boolean> CUSTOM_ICE_DROPS;
    public static final CSConfigSpec.ConfigValue<List<?>> SHADE_TEMP_OFFSET;
    public static final CSConfigSpec.DoubleValue DRYOFF_SPEED;
    public static final CSConfigSpec.DoubleValue WATER_SOAK_SPEED;
    public static final CSConfigSpec.DoubleValue RAIN_SOAK_SPEED;
    public static final CSConfigSpec.ConfigValue<List<?>> DEFAULT_WATER_TEMP;
    public static final CSConfigSpec.DoubleValue MAX_RAIN_SOAK;
    public static final CSConfigSpec.ConfigValue<Integer> THERMOREGULATOR_INSULATION;

    public static void setup(ModContainer modContainer) {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/world.toml");
    }

    public static void save() {
        SPEC.save();
    }

    public static List<?> getSummerTemps() {
        return WorldSettingsConfig.getSeasonalTemperature(SUMMER_TEMPERATURES);
    }

    public static List<?> getAutumnTemps() {
        return WorldSettingsConfig.getSeasonalTemperature(AUTUMN_TEMPERATURES);
    }

    public static List<?> getWinterTemps() {
        return WorldSettingsConfig.getSeasonalTemperature(WINTER_TEMPERATURES);
    }

    public static List<?> getSpringTemps() {
        return WorldSettingsConfig.getSeasonalTemperature(SPRING_TEMPERATURES);
    }

    private static List<?> getSeasonalTemperature(CSConfigSpec.ConfigValue<List<?>> setting) {
        return setting.get().stream().map(o -> {
            if (o instanceof Number) {
                return Double.valueOf(((Number)o).doubleValue());
            }
            if (o instanceof String) {
                return Temperature.Units.fromID((String)o);
            }
            throw new IllegalArgumentException(String.format("Invalid argument \"%s\" for seasonal temperature", o));
        }).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setSourceSpreadWhitelist(List<ResourceLocation> whitelist) {
        CSConfigSpec.ConfigValue<List<? extends String>> configValue = SOURCE_SPREAD_WHITELIST;
        synchronized (configValue) {
            SOURCE_SPREAD_WHITELIST.set(whitelist.stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setSourceSpreadBlacklist(List<ResourceLocation> blacklist) {
        CSConfigSpec.ConfigValue<List<? extends String>> configValue = SOURCE_SPREAD_BLACKLIST;
        synchronized (configValue) {
            SOURCE_SPREAD_BLACKLIST.set(blacklist.stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        }
    }

    static {
        BUILDER = new CSConfigSpec.Builder();
        BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Anywhere that uses IDs, such as blocks, biomes, dimensions, and structures, also supports:", " \u2022 Tags (e.g. \"#minecraft:is_underground\")", " \u2022 Comma-separated lists (e.g. \"minecraft:desert,#minecraft:is_badlands\")", "     Applies the setting to all listed IDs. Can use tags, regular IDs, and negation interchangeably", " \u2022 Negation (e.g. \"!minecraft:jungle_leaves\")", "     Useful with lists/tags. Excludes the listed IDs from the setting", "     i.e. \"#minecraft:leaves,!minecraft:jungle_leaves\" (all leaves EXCEPT jungle leaves)", " Settings with \"//v\" will list elements vertically. Removing \"//v\" will list elements in one line", "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        BUILDER.push("Dimensions");
        DIMENSION_TEMP_OFFSETS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Applies an offset to the world's temperature across an entire dimension", " \u251c\u2500\u2500 Format: [[\"dimension_id\", temperature, *units], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 dimension_id: The ID of the dimension (e.g. \"minecraft:the_nether\")", " \u2022 temperature: The temperature offset to apply to the dimension", " \u2022 *units: The units of the temperature (\"f\", \"c\", or \"mc\"). Defaults to Minecraft units (mc))").defineListAllowEmpty(List.of("Dimension Temperature Offsets"), () -> ListBuilder.begin(new List[]{List.of("minecraft:the_nether", Integer.valueOf(32), "f"), List.of("minecraft:the_end", Integer.valueOf(-5), "f")}).addIf(CompatManager.isTwilightForestLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("twilightforest:twilight_forest_type", Integer.valueOf(10), "f"))).addIf(CompatManager.isAetherLoaded(), () -> List.of("aether:the_aether", Integer.valueOf(32), "f")).build(), List::of, it -> {
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        DIMENSION_TEMPERATURES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the temperature of a dimension, overriding biome and elevation temperature", " \u251c\u2500\u2500 Format: [[\"dimension_id\", temperature, *units], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 dimension_id: The ID of the dimension (e.g. \"minecraft:the_nether\")", " \u2022 temperature: The temperature of the dimension", " \u2022 *units: The units of the temperature (\"f\", \"c\", or \"mc\"). Defaults to Minecraft units (mc))").defineListAllowEmpty(List.of("Dimension Temperatures"), () -> List.of(), List::of, it -> {
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        BUILDER.pop();
        BUILDER.push("Biomes");
        BIOME_TEMP_OFFSETS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Applies an offset to the temperature of a biome", " \u251c\u2500\u2500 Format: [[\"biome_id\", lowTemp, highTemp, *units, *waterTemp], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 biome_id: The ID of the biome (e.g. \"minecraft:desert\")", " \u2022 lowTemp: The temperature offset at midnight", " \u2022 highTemp: The temperature offset at noon", " \u2022 *units: The units of the temperature (\"f\", \"c\", or \"mc\"). Defaults to Minecraft units (mc))", " \u2022 *waterTemp: Offsets the temperature of water in the biome").defineListAllowEmpty(List.of("Biome Temperature Offsets"), () -> List.of(), it -> {
            List list;
            return !(!(it instanceof List) || !((list = (List)it).get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String));
        });
        BIOME_TEMPERATURES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the temperature of a biome, overriding the biome's default temperature", " \u251c\u2500\u2500 Format: [[\"biome_id\", lowTemp, highTemp, *units, *waterTemp], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 biome_id: The ID of the biome (e.g. \"minecraft:desert\")", " \u2022 lowTemp: The temperature of the biome at midnight", " \u2022 highTemp: The temperature of the biome at noon", " \u2022 *units: The units of the temperature (\"f\", \"c\", or \"mc\"). Defaults to Minecraft units (mc))", " \u2022 *waterTemp: The temperature of water in the biome").defineListAllowEmpty(List.of("Biome Temperatures"), () -> ListBuilder.begin(new List[]{List.of("minecraft:plains", Integer.valueOf(59), Integer.valueOf(82), "F"), List.of("minecraft:soul_sand_valley", Integer.valueOf(53), Integer.valueOf(53), "F"), List.of("minecraft:old_growth_birch_forest", Integer.valueOf(58), Integer.valueOf(72), "F"), List.of("minecraft:river", Integer.valueOf(59), Integer.valueOf(82), "F"), List.of("minecraft:swamp", Integer.valueOf(72), Integer.valueOf(84), "F", Integer.valueOf(-5)), List.of("minecraft:savanna", Integer.valueOf(70), Integer.valueOf(95), "F"), List.of("minecraft:savanna_plateau", Integer.valueOf(76), Integer.valueOf(98), "F"), List.of("minecraft:windswept_savanna", Integer.valueOf(67), Integer.valueOf(90), "F"), List.of("minecraft:taiga", Integer.valueOf(44), Integer.valueOf(62), "F"), List.of("minecraft:snowy_taiga", Integer.valueOf(8), Integer.valueOf(38), "F", Integer.valueOf(-15)), List.of("minecraft:old_growth_pine_taiga", Integer.valueOf(48), Integer.valueOf(62), "F"), List.of("minecraft:old_growth_spruce_taiga", Integer.valueOf(48), Integer.valueOf(62), "F"), List.of("minecraft:desert", Integer.valueOf(48), Integer.valueOf(115), "F"), List.of("minecraft:stony_shore", Integer.valueOf(50), Integer.valueOf(64), "F"), List.of("minecraft:snowy_beach", Integer.valueOf(8), Integer.valueOf(38), "F", Integer.valueOf(-15)), List.of("minecraft:snowy_slopes", Integer.valueOf(24), Integer.valueOf(32), "F", Integer.valueOf(-15)), List.of("minecraft:windswept_forest", Integer.valueOf(48), Integer.valueOf(66), "F"), List.of("minecraft:frozen_peaks", Integer.valueOf(15), Integer.valueOf(31), "F", Integer.valueOf(-18)), List.of("minecraft:warm_ocean", Integer.valueOf(67), Integer.valueOf(76), "F", Integer.valueOf(5)), List.of("minecraft:frozen_ocean", Integer.valueOf(20), Integer.valueOf(31), "F", Integer.valueOf(-20)), List.of("minecraft:deep_frozen_ocean", Integer.valueOf(20), Integer.valueOf(31), "F", Integer.valueOf(-20)), List.of("minecraft:jungle", Integer.valueOf(76), Integer.valueOf(87), "F"), List.of("minecraft:bamboo_jungle", Integer.valueOf(76), Integer.valueOf(87), "F"), List.of("minecraft:badlands", Integer.valueOf(84), Integer.valueOf(120), "F", Integer.valueOf(-5)), List.of("minecraft:wooded_badlands", Integer.valueOf(80), Integer.valueOf(108), "F", Integer.valueOf(-5)), List.of("minecraft:eroded_badlands", Integer.valueOf(88), Integer.valueOf(120), "F", Integer.valueOf(-5)), List.of("minecraft:deep_dark", Integer.valueOf(63), Integer.valueOf(63), "F"), List.of("minecraft:dripstone_caves", "disable")}).addIf(CompatManager.isBiomesOPlentyLoaded(), () -> List.of("biomesoplenty:bayou", Integer.valueOf(67), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:bog", Integer.valueOf(62), Integer.valueOf(73), "F"), () -> List.of("biomesoplenty:fir_clearing", Integer.valueOf(56), Integer.valueOf(68), "F"), () -> List.of("biomesoplenty:marsh", Integer.valueOf(76), Integer.valueOf(87), "F", Integer.valueOf(-5)), () -> List.of("biomesoplenty:wetland", Integer.valueOf(63), Integer.valueOf(74), "F", Integer.valueOf(-8)), () -> List.of("biomesoplenty:field", Integer.valueOf(64), Integer.valueOf(85), "F"), () -> List.of("biomesoplenty:ominous_woods", Integer.valueOf(65), Integer.valueOf(72), "F"), () -> List.of("biomesoplenty:coniferous_forest", Integer.valueOf(44), Integer.valueOf(58), "F"), () -> List.of("biomesoplenty:seasonal_forest", Integer.valueOf(52), Integer.valueOf(64), "F"), () -> List.of("biomesoplenty:pumpkin_patch", Integer.valueOf(57), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:woodland", Integer.valueOf(67), Integer.valueOf(80), "F"), () -> List.of("biomesoplenty:mediterranean_forest", Integer.valueOf(64), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:dune_beach", Integer.valueOf(67), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:rocky_rainforest", Integer.valueOf(73), Integer.valueOf(86), "F"), () -> List.of("biomesoplenty:old_growth_woodland", Integer.valueOf(65), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:forested_field", Integer.valueOf(64), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:fungal_jungle", Integer.valueOf(73), Integer.valueOf(86), "F"), () -> List.of("biomesoplenty:highland", Integer.valueOf(57), Integer.valueOf(70), "F"), () -> List.of("biomesoplenty:highland_moor", Integer.valueOf(54), Integer.valueOf(68), "F"), () -> List.of("biomesoplenty:grassland", Integer.valueOf(58), Integer.valueOf(82), "F"), () -> List.of("biomesoplenty:clover_patch", Integer.valueOf(56), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:jade_cliffs", Integer.valueOf(57), Integer.valueOf(70), "F"), () -> List.of("biomesoplenty:lush_desert", Integer.valueOf(72), Integer.valueOf(94), "F"), () -> List.of("biomesoplenty:dryland", Integer.valueOf(67), Integer.valueOf(97), "F"), () -> List.of("biomesoplenty:maple_woods", Integer.valueOf(58), Integer.valueOf(68), "F"), () -> List.of("biomesoplenty:mystic_grove", Integer.valueOf(65), Integer.valueOf(72), "F"), () -> List.of("biomesoplenty:orchard", Integer.valueOf(58), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:prairie", Integer.valueOf(66), Integer.valueOf(82), "F"), () -> List.of("biomesoplenty:origin_valley", Integer.valueOf(65), Integer.valueOf(80), "F"), () -> List.of("biomesoplenty:snowy_coniferous_forest", Integer.valueOf(28), Integer.valueOf(48), "F"), () -> List.of("biomesoplenty:snowy_fir_clearing", Integer.valueOf(32), Integer.valueOf(51), "F"), () -> List.of("biomesoplenty:snowy_maple_woods", Integer.valueOf(32), Integer.valueOf(48), "F"), () -> List.of("biomesoplenty:spider_nest", Integer.valueOf(75), Integer.valueOf(75), "F"), () -> List.of("biomesoplenty:volcanic_plains", Integer.valueOf(82), Integer.valueOf(95), "F"), () -> List.of("biomesoplenty:volcano", Integer.valueOf(94), Integer.valueOf(120), "F"), () -> List.of("biomesoplenty:hot_springs", Integer.valueOf(40), Integer.valueOf(62), "F", Integer.valueOf(20)), () -> List.of("biomesoplenty:wooded_wasteland", Integer.valueOf(78), Integer.valueOf(95), "F")).addIf(CompatManager.isBiomesYoullGoLoaded(), () -> List.of("byg:coniferous_forest", Integer.valueOf(52), Integer.valueOf(70), "F"), () -> List.of("byg:autumnal_valley", Integer.valueOf(58), Integer.valueOf(67), "F"), () -> List.of("byg:autumnal_forest", Integer.valueOf(60), Integer.valueOf(75), "F"), () -> List.of("byg:autumnal_taiga", Integer.valueOf(56), Integer.valueOf(68), "F"), () -> List.of("byg:baobab_savanna", Integer.valueOf(70), Integer.valueOf(95), "F"), () -> List.of("byg:dacite_ridges", Integer.valueOf(40), Integer.valueOf(65), "F"), () -> List.of("byg:firecracker_shrubland", Integer.valueOf(72), Integer.valueOf(105), "F"), () -> List.of("byg:frosted_taiga", Integer.valueOf(22), Integer.valueOf(48), "F", Integer.valueOf(-18)), () -> List.of("byg:cypress_swamplands", Integer.valueOf(68), Integer.valueOf(82), "F"), () -> List.of("byg:dead_sea", Integer.valueOf(72), Integer.valueOf(82), "F"), () -> List.of("byg:lush_stacks", Integer.valueOf(66), Integer.valueOf(75), "F"), () -> List.of("byg:fragment_forest", Integer.valueOf(43), Integer.valueOf(64), "F"), () -> List.of("byg:frosted_coniferous_forest", Integer.valueOf(8), Integer.valueOf(31), "F", Integer.valueOf(-15)), () -> List.of("byg:maple_taiga", Integer.valueOf(53), Integer.valueOf(71), "F"), () -> List.of("byg:skyris_vale", Integer.valueOf(42), Integer.valueOf(68), "F"), () -> List.of("byg:twilight_meadow", Integer.valueOf(49), Integer.valueOf(66), "F"), () -> List.of("byg:weeping_witch_forest", Integer.valueOf(56), Integer.valueOf(73), "F"), () -> List.of("byg:subzero_hypogeal", Integer.valueOf(-10), Integer.valueOf(-10), "F"), () -> List.of("byg:zelkova_forest", Integer.valueOf(44), Integer.valueOf(61), "F")).addIf(CompatManager.isBiomesWeveGoneLoaded(), () -> List.of("biomeswevegone:allium_shrubland", Integer.valueOf(58), Integer.valueOf(74), "F"), () -> List.of("biomeswevegone:jacaranda_jungle", Integer.valueOf(76), Integer.valueOf(87), "F"), () -> List.of("biomeswevegone:araucaria_savanna", Integer.valueOf(70), Integer.valueOf(92), "F"), () -> List.of("biomeswevegone:aspen_boreal", Integer.valueOf(48), Integer.valueOf(68), "F"), () -> List.of("biomeswevegone:windswept_desert", Integer.valueOf(60), Integer.valueOf(108), "F"), () -> List.of("biomeswevegone:atacama_outback", Integer.valueOf(60), Integer.valueOf(108), "F"), () -> List.of("biomeswevegone:baobab_savanna", Integer.valueOf(70), Integer.valueOf(95), "F"), () -> List.of("biomeswevegone:ironwood_gour", Integer.valueOf(69), Integer.valueOf(90), "F"), () -> List.of("biomeswevegone:bayou", Integer.valueOf(67), Integer.valueOf(86), "F", Integer.valueOf(-5)), () -> List.of("biomeswevegone:black_forest", Integer.valueOf(46), Integer.valueOf(70), "F"), () -> List.of("biomeswevegone:cika_woods", Integer.valueOf(40), Integer.valueOf(67), "F"), () -> List.of("biomeswevegone:canadian_shield", Integer.valueOf(38), Integer.valueOf(62), "F"), () -> List.of("biomeswevegone:forgotten_forest", Integer.valueOf(62), Integer.valueOf(78), "F"), () -> List.of("biomeswevegone:ebony_woods", Integer.valueOf(64), Integer.valueOf(75), "F"), () -> List.of("biomeswevegone:tropical_rainforest", Integer.valueOf(76), Integer.valueOf(87), "F"), () -> List.of("biomeswevegone:weeping_witch_forest", Integer.valueOf(56), Integer.valueOf(73), "F"), () -> List.of("biomeswevegone:zelkova_forest", Integer.valueOf(44), Integer.valueOf(61), "F"), () -> List.of("biomeswevegone:maple_taiga", Integer.valueOf(15), Integer.valueOf(18), "C", Integer.valueOf(-12)), () -> List.of("biomeswevegone:pumpkin_valley", Integer.valueOf(57), Integer.valueOf(78), "F"), () -> List.of("biomeswevegone:coniferous_forest", Integer.valueOf(44), Integer.valueOf(58), "F"), () -> List.of("biomeswevegone:frosted_coniferous_forest", Integer.valueOf(8), Integer.valueOf(31), "F", Integer.valueOf(-15)), () -> List.of("biomeswevegone:crimson_tundra", Integer.valueOf(8), Integer.valueOf(31), "F", Integer.valueOf(-14)), () -> List.of("biomeswevegone:dacite_ridges", Integer.valueOf(40), Integer.valueOf(65), "F"), () -> List.of("biomeswevegone:shore", Integer.valueOf(40), Integer.valueOf(65), "F"), () -> List.of("biomeswevegone:cypress_swamplands", Integer.valueOf(68), Integer.valueOf(82), "F"), () -> List.of("biomeswevegone:skyrise_vale", Integer.valueOf(42), Integer.valueOf(68), "F"), () -> List.of("biomeswevegone:orchard", Integer.valueOf(58), Integer.valueOf(78), "F"), () -> List.of("biomeswevegone:prairie", Integer.valueOf(66), Integer.valueOf(82), "F"), () -> List.of("biomeswevegone:enchanted_tangle", Integer.valueOf(66), Integer.valueOf(82), "F"), () -> List.of("biomeswevegone:firecracker_chaparral", Integer.valueOf(72), Integer.valueOf(105), "F"), () -> List.of("biomeswevegone:fragment_jungle", Integer.valueOf(76), Integer.valueOf(87), "F"), () -> List.of("biomeswevegone:frosted_taiga", Integer.valueOf(19), Integer.valueOf(48), "F", Integer.valueOf(-18)), () -> List.of("biomeswevegone:howling_peaks", Integer.valueOf(15), Integer.valueOf(33), "F"), () -> List.of("biomeswevegone:mojave_desert", Integer.valueOf(60), Integer.valueOf(105), "F"), () -> List.of("biomeswevegone:overgrowth_woodlands", Integer.valueOf(62), Integer.valueOf(78), "F"), () -> List.of("biomeswevegone:red_rock_valley", Integer.valueOf(84), Integer.valueOf(120), "F", Integer.valueOf(-5)), () -> List.of("biomeswevegone:redwood_thicket", Integer.valueOf(52), Integer.valueOf(81), "F"), () -> List.of("biomeswevegone:rugged_badlands", Integer.valueOf(72), Integer.valueOf(100), "F", Integer.valueOf(-5)), () -> List.of("biomeswevegone:white_mangrove_marshes", Integer.valueOf(70), Integer.valueOf(86), "F", Integer.valueOf(-5))).addIf(CompatManager.isAtmosphericLoaded(), () -> List.of("atmospheric:dunes", Integer.valueOf(78), Integer.valueOf(115), "F"), () -> List.of("atmospheric:flourishing_dunes", Integer.valueOf(68), Integer.valueOf(105), "F"), () -> List.of("atmospheric:petrified_dunes", Integer.valueOf(58), Integer.valueOf(120), "F"), () -> List.of("atmospheric:rocky_dunes", Integer.valueOf(55), Integer.valueOf(125), "F", Integer.valueOf(-5)), () -> List.of("atmospheric:rainforest", Integer.valueOf(68), Integer.valueOf(90), "F"), () -> List.of("atmospheric:rainforest_basin", Integer.valueOf(68), Integer.valueOf(90), "F"), () -> List.of("atmospheric:sparse_rainforest", Integer.valueOf(62), Integer.valueOf(83), "F"), () -> List.of("atmospheric:sparse_rainforest_basin", Integer.valueOf(62), Integer.valueOf(83), "F")).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:marsh", Integer.valueOf(60), Integer.valueOf(80), "F", Integer.valueOf(-5)))).addIf(CompatManager.isTerralithLoaded(), () -> List.of("terralith:moonlight_valley", Integer.valueOf(57), Integer.valueOf(76), "F"), () -> List.of("terralith:rocky_mountains", Integer.valueOf(45), Integer.valueOf(73), "F"), () -> List.of("terralith:blooming_plateau", Integer.valueOf(49), Integer.valueOf(78), "F"), () -> List.of("terralith:alpine_grove", Integer.valueOf(16), Integer.valueOf(53), "F"), () -> List.of("terralith:yellowstone", Integer.valueOf(47), Integer.valueOf(68), "F"), () -> List.of("terralith:forested_highlands", Integer.valueOf(43), Integer.valueOf(70), "F"), () -> List.of("terralith:temperate_highlands", Integer.valueOf(54), Integer.valueOf(80), "F"), () -> List.of("terralith:amethyst_rainforest", Integer.valueOf(69), Integer.valueOf(84), "F"), () -> List.of("terralith:sandstone_valley", Integer.valueOf(78), Integer.valueOf(114), "F"), () -> List.of("terralith:ancient_sands", Integer.valueOf(83), Integer.valueOf(130), "F"), () -> List.of("terralith:arid_highlands", Integer.valueOf(74), Integer.valueOf(102), "F"), () -> List.of("terralith:volcanic_crater", Integer.valueOf(96), Integer.valueOf(162), "F"), () -> List.of("terralith:volcanic_peaks", Integer.valueOf(76), Integer.valueOf(122), "F"), () -> List.of("terralith:basalt_cliffs", Integer.valueOf(76), Integer.valueOf(122), "F"), () -> List.of("terralith:birch_taiga", Integer.valueOf(40), Integer.valueOf(62), "F"), () -> List.of("terralith:brushland", Integer.valueOf(64), Integer.valueOf(89), "F"), () -> List.of("terralith:bryce_canyon", Integer.valueOf(72), Integer.valueOf(110), "F"), () -> List.of("terralith:caldera", Integer.valueOf(58), Integer.valueOf(71), "F"), () -> List.of("terralith:cloud_forest", Integer.valueOf(38), Integer.valueOf(58), "F"), () -> List.of("terralith:desert_canyon", Integer.valueOf(73), Integer.valueOf(121), "F"), () -> List.of("terralith:desert_spires", Integer.valueOf(60), Integer.valueOf(121), "F"), () -> List.of("terralith:orchid_swamp", Integer.valueOf(62), Integer.valueOf(81), "F"), () -> List.of("terralith:fractured_savanna", Integer.valueOf(65), Integer.valueOf(92), "F"), () -> List.of("terralith:savanna_badlands", Integer.valueOf(68), Integer.valueOf(99), "F"), () -> List.of("terralith:granite_cliffs", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("terralith:haze_mountain", Integer.valueOf(62), Integer.valueOf(74), "F"), () -> List.of("terralith:highlands", Integer.valueOf(62), Integer.valueOf(74), "F"), () -> List.of("terralith:lavender_valley", Integer.valueOf(59), Integer.valueOf(76), "F"), () -> List.of("terralith:lavender_forest", Integer.valueOf(56), Integer.valueOf(75), "F"), () -> List.of("terralith:red_oasis", Integer.valueOf(58), Integer.valueOf(94), "F"), () -> List.of("terralith:shield", Integer.valueOf(48), Integer.valueOf(68), "F"), () -> List.of("terralith:shield_clearing", Integer.valueOf(28), Integer.valueOf(80), "F"), () -> List.of("terralith:steppe", Integer.valueOf(44), Integer.valueOf(78), "F"), () -> List.of("terralith:warped_mesa", Integer.valueOf(66), Integer.valueOf(84), "F", Integer.valueOf(-5))).addIf(CompatManager.isWythersLoaded(), () -> List.of("wythers:ancient_copper_beech_forest", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:ancient_emerald_beech_forest", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ancient_golden_beech_forest", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ancient_moss_forest", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ancient_mossy_swamp", Integer.valueOf(10), Integer.valueOf(12), "C"), () -> List.of("wythers:ancient_oak_swamp", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ancient_taiga", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:andesite_crags", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:aspen_crags", Integer.valueOf(18), Integer.valueOf(20), "C"), () -> List.of("wythers:autumnal_birch_forest", Integer.valueOf(15), Integer.valueOf(16), "C"), () -> List.of("wythers:autumnal_crags", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:autumnal_flower_forest", Integer.valueOf(18), Integer.valueOf(20), "C"), () -> List.of("wythers:autumnal_forest", Integer.valueOf(15), Integer.valueOf(16), "C"), () -> List.of("wythers:autumnal_forest_edge", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:autumnal_plains", Integer.valueOf(18), Integer.valueOf(20), "C"), () -> List.of("wythers:autumnal_swamp", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ayers_rock", Integer.valueOf(32), Integer.valueOf(35), "C"), () -> List.of("wythers:badlands_canyon", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:badlands_desert", Integer.valueOf(35), Integer.valueOf(40), "C"), () -> List.of("wythers:badlands_river", Integer.valueOf(30), Integer.valueOf(34), "C"), () -> List.of("wythers:bamboo_jungle_canyon", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:bamboo_jungle_highlands", Integer.valueOf(13), Integer.valueOf(15), "C"), () -> List.of("wythers:bamboo_jungle_swamp", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:bamboo_swamp", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:bayou", Integer.valueOf(14), Integer.valueOf(18), "C", Integer.valueOf(-2)), () -> List.of("wythers:berry_bog", Integer.valueOf(12), Integer.valueOf(16), "C", Integer.valueOf(-2)), () -> List.of("wythers:billabong", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:birch_swamp", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:birch_taiga", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:black_beach", Integer.valueOf(18), Integer.valueOf(22), "C"), () -> List.of("wythers:black_river", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:boreal_forest_red", Integer.valueOf(20), Integer.valueOf(23), "C"), () -> List.of("wythers:boreal_forest_yellow", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:cactus_desert", Integer.valueOf(30), Integer.valueOf(45), "C"), () -> List.of("wythers:calcite_caverns", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:calcite_coast", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:chaparral", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:coastal_mangroves", Integer.valueOf(15), Integer.valueOf(19), "C"), () -> List.of("wythers:cold_island", Integer.valueOf(-1), Integer.valueOf(3), "C"), () -> List.of("wythers:cold_plains", Integer.valueOf(-5), Integer.valueOf(2), "C"), () -> List.of("wythers:cold_stony_shore", Integer.valueOf(-10), Integer.valueOf(2), "C"), () -> List.of("wythers:cool_forest", Integer.valueOf(5), Integer.valueOf(10), "C"), () -> List.of("wythers:cool_forest_edge", Integer.valueOf(5), Integer.valueOf(10), "C"), () -> List.of("wythers:cool_plains", Integer.valueOf(5), Integer.valueOf(10), "C"), () -> List.of("wythers:cool_stony_canyons", Integer.valueOf(0), Integer.valueOf(1), "C"), () -> List.of("wythers:cool_stony_peaks", Integer.valueOf(-10), Integer.valueOf(0), "C"), () -> List.of("wythers:crimson_tundra", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:danakil_desert", Integer.valueOf(30), Integer.valueOf(40), "C"), () -> List.of("wythers:deep_dark_forest", Integer.valueOf(5), Integer.valueOf(6), "C"), () -> List.of("wythers:deep_desert", Integer.valueOf(30), Integer.valueOf(40), "C"), () -> List.of("wythers:deep_desert_river", Integer.valueOf(25), Integer.valueOf(30), "C"), () -> List.of("wythers:deep_icy_ocean", Integer.valueOf(-20), Integer.valueOf(0), "C"), () -> List.of("wythers:deep_snowy_taiga", Integer.valueOf(-10), Integer.valueOf(0), "C"), () -> List.of("wythers:deep_underground", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:deepslate_shore", Integer.valueOf(10), Integer.valueOf(12), "C"), () -> List.of("wythers:desert_beach", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:desert_island", Integer.valueOf(40), Integer.valueOf(45), "C"), () -> List.of("wythers:desert_lakes", Integer.valueOf(30), Integer.valueOf(31), "C"), () -> List.of("wythers:desert_pinnacles", Integer.valueOf(28), Integer.valueOf(30), "C"), () -> List.of("wythers:desert_river", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:dripleaf_swamp", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:dry_savanna", Integer.valueOf(29), Integer.valueOf(35), "C"), () -> List.of("wythers:dry_tropical_forest", Integer.valueOf(20), Integer.valueOf(26), "C"), () -> List.of("wythers:dry_tropical_grassland", Integer.valueOf(28), Integer.valueOf(30), "C"), () -> List.of("wythers:eucalyptus_deanei_forest", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:eucalyptus_jungle", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:eucalyptus_jungle_canyon", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:eucalyptus_salubris_woodland", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:eucalyptus_woodland", Integer.valueOf(22), Integer.valueOf(25), "C"), () -> List.of("wythers:fen", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:flooded_jungle", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:flooded_rainforest", Integer.valueOf(16), Integer.valueOf(20), "C"), () -> List.of("wythers:flooded_savanna", Integer.valueOf(16), Integer.valueOf(20), "C"), () -> List.of("wythers:flooded_temperate_rainforest", Integer.valueOf(20), Integer.valueOf(22), "C"), () -> List.of("wythers:flowering_pantanal", Integer.valueOf(25), Integer.valueOf(28), "C"), () -> List.of("wythers:forbidden_forest", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:forest_edge", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:forested_highlands", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:frigid_island", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:frozen_island", Integer.valueOf(-15), Integer.valueOf(0), "C"), () -> List.of("wythers:fungous_dripstone_caves", Integer.valueOf(5), Integer.valueOf(10), "C"), () -> List.of("wythers:giant_sequoia_forest", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:glacial_cliffs", Integer.valueOf(1), Integer.valueOf(10), "C"), () -> List.of("wythers:granite_canyon", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:gravelly_beach", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:gravelly_river", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:guelta", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:harvest_fields", Integer.valueOf(20), Integer.valueOf(26), "C"), () -> List.of("wythers:highland_plains", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:highland_tropical_rainforest", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:highlands", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:huangshan_highlands", Integer.valueOf(15), Integer.valueOf(25), "C"), () -> List.of("wythers:humid_tropical_grassland", Integer.valueOf(20), Integer.valueOf(26), "C"), () -> List.of("wythers:ice_cap", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:icy_crags", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:icy_ocean", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:icy_river", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:icy_shore", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:icy_volcano", Integer.valueOf(1), Integer.valueOf(2), "C"), () -> List.of("wythers:jacaranda_savanna", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:jade_highlands", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:jungle_canyon", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:jungle_island", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:jungle_river", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:kwongan_heath", Integer.valueOf(30), Integer.valueOf(50), "C"), () -> List.of("wythers:lantern_river", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:lapacho_plains", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:larch_taiga", Integer.valueOf(20), Integer.valueOf(22), "C"), () -> List.of("wythers:lichenous_caves", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:lichenous_dripstone_caves", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:lush_dripstone_caves", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:lush_fungous_dripstone_caves", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:lush_shroom_caves", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:maple_mountains", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:marsh", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:mediterranean_island", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:mediterranean_island_thermal_springs", Integer.valueOf(25), Integer.valueOf(30), "C"), () -> List.of("wythers:mossy_caves", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:mossy_dripstone_caves", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:mud_pools", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:mushroom_caves", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:mushroom_island", Integer.valueOf(25), Integer.valueOf(28), "C"), () -> List.of("wythers:old_growth_taiga_crags", Integer.valueOf(18), Integer.valueOf(28), "C"), () -> List.of("wythers:old_growth_taiga_swamp", Integer.valueOf(18), Integer.valueOf(22), "C"), () -> List.of("wythers:outback", Integer.valueOf(30), Integer.valueOf(38), "C"), () -> List.of("wythers:outback_desert", Integer.valueOf(40), Integer.valueOf(45), "C"), () -> List.of("wythers:pantanal", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:phantasmal_forest", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:phantasmal_swamp", Integer.valueOf(15), Integer.valueOf(16), "C"), () -> List.of("wythers:pine_barrens", Integer.valueOf(20), Integer.valueOf(26), "C"), () -> List.of("wythers:red_desert", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:red_rock_canyon", Integer.valueOf(30), Integer.valueOf(32), "C"), () -> List.of("wythers:sakura_forest", Integer.valueOf(26), Integer.valueOf(32), "C"), () -> List.of("wythers:salt_lakes_pink", Integer.valueOf(16), Integer.valueOf(28), "C"), () -> List.of("wythers:salt_lakes_turquoise", Integer.valueOf(16), Integer.valueOf(20), "C"), () -> List.of("wythers:salt_lakes_white", Integer.valueOf(16), Integer.valueOf(29), "C"), () -> List.of("wythers:sand_dunes", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:sandy_jungle", Integer.valueOf(30), Integer.valueOf(38), "C"), () -> List.of("wythers:savanna_badlands", Integer.valueOf(35), Integer.valueOf(39), "C"), () -> List.of("wythers:savanna_basaltic_incursions", Integer.valueOf(35), Integer.valueOf(40), "C"), () -> List.of("wythers:savanna_river", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:scrub_forest", Integer.valueOf(20), Integer.valueOf(28), "C"), () -> List.of("wythers:scrubland", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:snowy_bog", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:snowy_canyon", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:snowy_fen", Integer.valueOf(-10), Integer.valueOf(0), "C"), () -> List.of("wythers:snowy_peaks", Integer.valueOf(-20), Integer.valueOf(0), "C"), () -> List.of("wythers:snowy_thermal_taiga", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:snowy_tundra", Integer.valueOf(0), Integer.valueOf(2), "C"), () -> List.of("wythers:sparse_bamboo_jungle", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:sparse_eucalyptus_jungle", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:sparse_eucalyptus_woodland", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:spring_flower_fields", Integer.valueOf(20), Integer.valueOf(28), "C"), () -> List.of("wythers:spring_flower_forest", Integer.valueOf(20), Integer.valueOf(28), "C"), () -> List.of("wythers:stony_canyon", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:subtropical_forest", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:subtropical_forest_edge", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:subtropical_grassland", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:taiga_crags", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:tangled_forest", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:temperate_island", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:temperate_rainforest", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:temperate_rainforest_crags", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:tepui", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:thermal_taiga", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:thermal_taiga_crags", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:tibesti_mountains", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:tropical_beach", Integer.valueOf(35), Integer.valueOf(38), "C"), () -> List.of("wythers:tropical_forest", Integer.valueOf(22), Integer.valueOf(30), "C"), () -> List.of("wythers:tropical_forest_canyon", Integer.valueOf(25), Integer.valueOf(30), "C"), () -> List.of("wythers:tropical_forest_river", Integer.valueOf(22), Integer.valueOf(30), "C"), () -> List.of("wythers:tropical_grassland", Integer.valueOf(20), Integer.valueOf(30), "C"), () -> List.of("wythers:tropical_island", Integer.valueOf(24), Integer.valueOf(34), "C"), () -> List.of("wythers:tropical_rainforest", Integer.valueOf(25), Integer.valueOf(32), "C"), () -> List.of("wythers:tropical_volcano", Integer.valueOf(40), Integer.valueOf(50), "C"), () -> List.of("wythers:tsingy_forest", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:tundra", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:underground", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:volcanic_chamber", Integer.valueOf(35), Integer.valueOf(45), "C"), () -> List.of("wythers:volcanic_crater", Integer.valueOf(35), Integer.valueOf(45), "C"), () -> List.of("wythers:volcano", Integer.valueOf(40), Integer.valueOf(50), "C"), () -> List.of("wythers:warm_birch_forest", Integer.valueOf(30), Integer.valueOf(37), "C"), () -> List.of("wythers:warm_stony_shore", Integer.valueOf(30), Integer.valueOf(37), "C"), () -> List.of("wythers:waterlily_swamp", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:windswept_jungle", Integer.valueOf(18), Integer.valueOf(22), "C"), () -> List.of("wythers:wistman_woods", Integer.valueOf(18), Integer.valueOf(20), "C"), () -> List.of("wythers:wooded_desert", Integer.valueOf(22), Integer.valueOf(25), "C"), () -> List.of("wythers:wooded_savanna", Integer.valueOf(22), Integer.valueOf(26), "C")).addIf(CompatManager.isRegionsUnexploredLoaded(), () -> List.of("regions_unexplored:alpha_grove", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:arid_mountains", Integer.valueOf(85), Integer.valueOf(120), "F"), () -> List.of("regions_unexplored:ashen_woodland", Integer.valueOf(70), Integer.valueOf(90), "F"), () -> List.of("regions_unexplored:autumnal_maple_forest", Integer.valueOf(60), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:bamboo_forest", Integer.valueOf(76), Integer.valueOf(87), "F"), () -> List.of("regions_unexplored:baobab_savanna", Integer.valueOf(70), Integer.valueOf(95), "F"), () -> List.of("regions_unexplored:barley_fields", Integer.valueOf(66), Integer.valueOf(82), "F"), () -> List.of("regions_unexplored:bayou", Integer.valueOf(67), Integer.valueOf(78), "F"), () -> List.of("regions_unexplored:bioshroom_caves", Integer.valueOf(80), Integer.valueOf(80), "F"), () -> List.of("regions_unexplored:blackstone_basin", Integer.valueOf(85), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:blackwood_taiga", Integer.valueOf(48), Integer.valueOf(68), "F"), () -> List.of("regions_unexplored:blackwood_taiga", Integer.valueOf(48), Integer.valueOf(68), "F"), () -> List.of("regions_unexplored:boreal_taiga", Integer.valueOf(48), Integer.valueOf(68), "F"), () -> List.of("regions_unexplored:chalk_cliffs", Integer.valueOf(60), Integer.valueOf(88), "F"), () -> List.of("regions_unexplored:clover_plains", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:cold_boreal_taiga", Integer.valueOf(40), Integer.valueOf(59), "F"), () -> List.of("regions_unexplored:cold_deciduous_forest", Integer.valueOf(43), Integer.valueOf(62), "F"), () -> List.of("regions_unexplored:cold_river", Integer.valueOf(45), Integer.valueOf(60), "F"), () -> List.of("regions_unexplored:deciduous_forest", Integer.valueOf(58), Integer.valueOf(82), "F"), () -> List.of("regions_unexplored:dry_bushland", Integer.valueOf(72), Integer.valueOf(89), "F"), () -> List.of("regions_unexplored:eucalyptus_forest", Integer.valueOf(69), Integer.valueOf(86), "F"), () -> List.of("regions_unexplored:fen", Integer.valueOf(58), Integer.valueOf(79), "F"), () -> List.of("regions_unexplored:flower_fields", Integer.valueOf(58), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:frozen_pine_taiga", Integer.valueOf(34), Integer.valueOf(62), "F"), () -> List.of("regions_unexplored:frozen_tundra", Integer.valueOf(30), Integer.valueOf(59), "F"), () -> List.of("regions_unexplored:fungal_fen", Integer.valueOf(60), Integer.valueOf(82), "F"), () -> List.of("regions_unexplored:golden_boreal_taiga", Integer.valueOf(48), Integer.valueOf(68), "F"), () -> List.of("regions_unexplored:grassland", Integer.valueOf(66), Integer.valueOf(86), "F"), () -> List.of("regions_unexplored:grassy_beach", Integer.valueOf(67), Integer.valueOf(80), "F"), () -> List.of("regions_unexplored:gravel_beach", Integer.valueOf(62), Integer.valueOf(80), "F"), () -> List.of("regions_unexplored:highland_fields", Integer.valueOf(60), Integer.valueOf(78), "F"), () -> List.of("regions_unexplored:hyacinth_deeps", Integer.valueOf(60), Integer.valueOf(78), "F"), () -> List.of("regions_unexplored:icy_heights", Integer.valueOf(30), Integer.valueOf(52), "F"), () -> List.of("regions_unexplored:joshua_desert", Integer.valueOf(72), Integer.valueOf(92), "F"), () -> List.of("regions_unexplored:magnolia_woodland", Integer.valueOf(66), Integer.valueOf(86), "F"), () -> List.of("regions_unexplored:maple_forest", Integer.valueOf(62), Integer.valueOf(82), "F"), () -> List.of("regions_unexplored:marsh", Integer.valueOf(72), Integer.valueOf(88), "F"), () -> List.of("regions_unexplored:mauve_hills", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:mountains", Integer.valueOf(60), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:muddy_river", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:old_growth_bayou", Integer.valueOf(74), Integer.valueOf(86), "F"), () -> List.of("regions_unexplored:orchard", Integer.valueOf(62), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:outback", Integer.valueOf(62), Integer.valueOf(97), "F"), () -> List.of("regions_unexplored:pine_slopes", Integer.valueOf(53), Integer.valueOf(74), "F"), () -> List.of("regions_unexplored:pine_taiga", Integer.valueOf(47), Integer.valueOf(73), "F"), () -> List.of("regions_unexplored:poppy_fields", Integer.valueOf(64), Integer.valueOf(84), "F"), () -> List.of("regions_unexplored:prairie", Integer.valueOf(66), Integer.valueOf(82), "F"), () -> List.of("regions_unexplored:prismachasm", Integer.valueOf(75), Integer.valueOf(75), "F"), () -> List.of("regions_unexplored:pumpkin_fields", Integer.valueOf(60), Integer.valueOf(80), "F"), () -> List.of("regions_unexplored:rainforest", Integer.valueOf(73), Integer.valueOf(89), "F"), () -> List.of("regions_unexplored:redstone_caves", Integer.valueOf(80), Integer.valueOf(80), "F"), () -> List.of("regions_unexplored:redwoods", Integer.valueOf(60), Integer.valueOf(80), "F"), () -> List.of("regions_unexplored:rocky_meadow", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:rocky_reef", Integer.valueOf(68), Integer.valueOf(86), "F"), () -> List.of("regions_unexplored:saguaro_desert", Integer.valueOf(53), Integer.valueOf(120), "F"), () -> List.of("regions_unexplored:scorching_caves", Integer.valueOf(90), Integer.valueOf(90), "F"), () -> List.of("regions_unexplored:shrubland", Integer.valueOf(64), Integer.valueOf(86), "F"), () -> List.of("regions_unexplored:silver_birch_forest", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:sparse_rainforest", Integer.valueOf(73), Integer.valueOf(89), "F"), () -> List.of("regions_unexplored:spires", Integer.valueOf(20), Integer.valueOf(50), "F"), () -> List.of("regions_unexplored:steppe", Integer.valueOf(72), Integer.valueOf(89), "F"), () -> List.of("regions_unexplored:temperate_grove", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:towering_cliffs", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:tropical_river", Integer.valueOf(74), Integer.valueOf(85), "F"), () -> List.of("regions_unexplored:tropics", Integer.valueOf(74), Integer.valueOf(87), "F"), () -> List.of("regions_unexplored:willow_forest", Integer.valueOf(63), Integer.valueOf(82), "F")).build(), it -> {
            String string;
            Object patt0$temp;
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && ((patt0$temp = list.get(1)) instanceof String && (string = (String)patt0$temp).equals("disable") || list.get(1) instanceof Number && list.get(2) instanceof Number && (list.size() < 4 || list.get(3) instanceof String) && (list.size() < 5 || list.get(4) instanceof Number));
        });
        BUILDER.pop();
        BUILDER.push("Blocks");
        BLOCK_TEMPERATURES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Applies temperature-emitting properties to blocks", " \u251c\u2500\u2500 Format: [[\"block_id\", temperature, range, *units, *maxEffect, *\"predicates\", *\"{nbt}\", *tempLimit], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 block_id: The ID of the block (i.e. \"minecraft:lava\")", " \u2022 temperature: The temperature of the block, in Minecraft units", " \u2022 range: The radius of the block's temperature effect, in blocks", " \u2022 *units: The units of the temperature (\"f\", \"c\", or \"mc\"). Defaults to Minecraft units (mc))", " \u2022 *maxEffect: The maximum cumulative temperature change this block can cause to a player (even with multiple blocks)", " \u2022 *predicates: The state that the block must have for the temperature to be applied (i.e. \"lit=true\").", "   (Define multiple predicates by separating them with commas [i.e. \"lit=true,waterlogged=false\"])", " \u2022 *nbt: The NBT data that the block must have for the temperature to be applied.", " \u2022 *tempLimit: The maximum world temperature at which this block temp will have any effect.", "   (Represents the minimum temp if the block temp is negative)").defineListAllowEmpty(List.of("Block Temperatures"), () -> ListBuilder.begin(new List[]{List.of("cold_sweat:boiler", Integer.valueOf(12), Integer.valueOf(7), "f", Integer.valueOf(36), "lit=true", "", Integer.valueOf(212)), List.of("cold_sweat:icebox", Integer.valueOf(-12), Integer.valueOf(7), "f", Integer.valueOf(36), "frosted=true", "", Integer.valueOf(32)), List.of("minecraft:lava", Integer.valueOf(20), Integer.valueOf(7), "f", Integer.valueOf(200), "", "", Integer.valueOf(1000), Boolean.valueOf(true)), List.of("#minecraft:fire", Integer.valueOf(15), Integer.valueOf(7), "f", Integer.valueOf(45), "", "", Integer.valueOf(400)), List.of("#minecraft:campfires", Integer.valueOf(15), Integer.valueOf(7), "f", Integer.valueOf(45), "lit=true", " ", Integer.valueOf(400)), List.of("minecraft:magma_block", Integer.valueOf(12), Integer.valueOf(3), "f", Integer.valueOf(48)), List.of("minecraft:lava_cauldron", Integer.valueOf(20), Integer.valueOf(7), "f", Integer.valueOf(200), "", "", Integer.valueOf(1000), Boolean.valueOf(true)), List.of("minecraft:ice", Integer.valueOf(-6), Integer.valueOf(4), "f", Integer.valueOf(24), "", "", Integer.valueOf(33)), List.of("minecraft:packed_ice", Integer.valueOf(-12), Integer.valueOf(4), "f", Integer.valueOf(48), "", "", Integer.valueOf(16)), List.of("minecraft:blue_ice", Integer.valueOf(-16), Integer.valueOf(4), "f", Integer.valueOf(64), "", "", Integer.valueOf(0)), List.of("#minecraft:ice", Integer.valueOf(-6), Integer.valueOf(4), "f", Integer.valueOf(27), "", "", Integer.valueOf(33))}).addIf(CompatManager.isCreateLoaded(), () -> List.of("create:blaze_burner", Integer.valueOf(5), Integer.valueOf(3), "f", Integer.valueOf(30), "blaze=smouldering", "", Integer.valueOf(400)), () -> List.of("create:blaze_burner", Integer.valueOf(10), Integer.valueOf(4), "f", Integer.valueOf(30), "blaze=fading", "", Integer.valueOf(400)), () -> List.of("create:blaze_burner", Integer.valueOf(15), Integer.valueOf(5), "f", Integer.valueOf(45), "blaze=kindled", "", Integer.valueOf(400)), () -> List.of("create:blaze_burner", Integer.valueOf(20), Integer.valueOf(6), "f", Integer.valueOf(60), "blaze=seething", "", Integer.valueOf(400))).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof Number) || list.size() >= 6 && !(list.get(5) instanceof String) || list.size() >= 7 && !(list.get(6) instanceof String) || list.size() >= 8 && !(list.get(7) instanceof Number));
        });
        MAX_BLOCK_TEMP_RANGE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum range of blocks' area of effect", " - Note: This will not change anything unless blocks are configured to utilize the expanded range", " - This value is limited to 16 for performance reasons").defineInRange("Block Range", 7, 1, 16);
        CUSTOM_WATER_FREEZE_BEHAVIOR = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " When set to true, uses Cold Sweat's temperature system to determine water freezing behavior").define("Custom Freezing Behavior", true);
        CUSTOM_ICE_DROPS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " When set to true, modifies ice blocks to be harvestable with a pickaxe").define("Custom Ice Drops", true);
        DRYOFF_SPEED = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The speed at which wet players dry off").defineInRange("Dryoff Speed", 0.0015, 0.0, Double.POSITIVE_INFINITY);
        WATER_SOAK_SPEED = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The speed at which players become soaked when in water").defineInRange("Water Soak Speed", 0.1, 0.0, Double.POSITIVE_INFINITY);
        RAIN_SOAK_SPEED = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The speed at which players become soaked when in rain").defineInRange("Rain Soak Speed", 0.0125, 0.0, Double.POSITIVE_INFINITY);
        DEFAULT_WATER_TEMP = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The default temperature of water", " \u2514\u2500\u2500 Format: [temperature, *units]").defineList("Default Water Temperature", List.of(Integer.valueOf(-10), "f"), it -> it instanceof Number || it instanceof String);
        MAX_RAIN_SOAK = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum soak level a player can reach from rain alone (0.0 - 1.0)").defineInRange("Max Rain Soak", 0.2, 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        BUILDER.push("Structures");
        STRUCTURE_TEMPERATURES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Overrides the world temperature when the player is within this structure", " \u251c\u2500\u2500 Format: [[\"structure_id\", temperature, *units], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 structure_id: The ID of the structure (i.e. \"minecraft:stronghold\")", " \u2022 temperature: The temperature of the structure, in Minecraft units", " \u2022 *units: The units of the temperature (\"f\" for Fahrenheit, \"c\" for Celsius, \"mc\" for Minecraft units)").defineListAllowEmpty(List.of("Structure Temperatures"), () -> List.of(), it -> {
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        STRUCTURE_TEMP_OFFSETS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Offsets the world temperature when the player is within this structure", " \u251c\u2500\u2500 Format: [[\"structure_id\", offset, *units], [...], etc]", " \u2514\u2500\u2500 [* = optional]", " \u2022 structure_id: The ID of the structure (i.e. \"minecraft:igloo\")", " \u2022 offset: The temperature offset of the structure, in Minecraft units", " \u2022 *units: The units of the temperature (\"f\" for Fahrenheit, \"c\" for Celsius, \"mc\" for Minecraft units)").defineListAllowEmpty(List.of("Structure Temperature Offsets"), () -> List.of(), it -> {
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        BUILDER.pop();
        BUILDER.push("Misc");
        SHADE_TEMP_OFFSET = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " A temperature offset applied when in complete shade or when the sky is overcast", " \u2514\u2500\u2500 Format: [offset, *units]").defineList("Shade Temperature Offset", List.of(Integer.valueOf(-9), "f"), it -> it instanceof Number || it instanceof String);
        SLEEPING_OVERRIDE_BLOCKS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " List of blocks that will allow the player to sleep on them, regardless of the \"Prevent Sleep When in Danger\" setting", " Use this list if the player is not getting the temperature effect from sleeping on particular blocks").defineListAllowEmpty(List.of("Sleep Check Override Blocks"), () -> ListBuilder.begin(new String[0]).addIf(CompatManager.modLoaded("comforts"), (Supplier<String[]>)((Supplier<String>)() -> "#comforts:sleeping_bags")).build(), it -> it instanceof String);
        SHOULD_CHECK_SLEEP = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " When set to true, players cannot sleep if they are cold or hot enough to die").define("Check Sleeping Conditions", true);
        IS_SOUL_FIRE_COLD = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Converts damage dealt by Soul Fire to cold damage (default: true)", " Does not affect the block's temperature").define("Cold Soul Fire", true);
        BUILDER.pop();
        BUILDER.comment("\"Thermal sources\" are blocks that have a smokestack and give frigidness/warmth. like the hearth, boiler, and iceobx").push("Thermal Sources");
        SOURCE_EFFECT_STRENGTH = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " How effective thermal sources are at normalizing temperature").defineInRange("Thermal Source Strength", 0.75, 0.0, 1.0);
        SOURCE_SPREAD_WHITELIST = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " List of additional blocks that thermal sources can spread through", " Use this list if thermal sources aren't spreading through particular blocks that they should").defineListAllowEmpty(List.of("Thermal Source Spread Whitelist"), ListBuilder.begin(new String[]{"minecraft:iron_bars", "#minecraft:leaves"}).addIf(CompatManager.isCreateLoaded(), (Supplier<String[]>)((Supplier<String>)() -> "create:encased_fluid_pipe")).build(), o -> o instanceof String);
        SOURCE_SPREAD_BLACKLIST = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " List of additional blocks that thermal sources spread through", " Use this list if thermal sources are spreading through particular blocks that they shouldn't").defineListAllowEmpty(List.of("Thermal Source Spread Blacklist"), () -> List.of("minecraft:water"), o -> o instanceof String);
        BUILDER.push("Hearth");
        ENABLE_SMART_HEARTH = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Allows the hearth to automatically turn on/off based on nearby players' temperature", " If false, it turns on/off by redstone signal instead").define("Automatic Hearth", false);
        HEARTH_RANGE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The distance the hearth's air will travel from a source, like the hearth itself or the end of a pipe").defineInRange("Hearth Range", 20, 0, Integer.MAX_VALUE);
        HEARTH_MAX_RANGE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum distance that air can be piped away from the hearth").defineInRange("Max Hearth Range", 96, 0, Integer.MAX_VALUE);
        HEARTH_MAX_VOLUME = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum volume of the hearth's area of effect").defineInRange("Hearth Volume", 12000, 1, Integer.MAX_VALUE);
        HEARTH_WARM_UP_TIME = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The time it takes for the hearth to be fully functional after being placed").defineInRange("Hearth Warm-Up Time", 1200, 0, Integer.MAX_VALUE);
        HEARTH_MAX_INSULATION = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum amount of insulation that the hearth can provide").defineInRange("Hearth Effect Strength", 10, 0, 10);
        HEARTH_FUEL_INTERVAL = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " How often the hearth consumes fuel (in ticks)", " Lower numbers cause fuel to be consumed faster. Setting to 0 disables fuel consumption").defineInRange("Hearth Fuel Consumption Interval", 40, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Boiler");
        ENABLE_SMART_BOILER = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Allows the boiler to automatically turn on/off based on nearby players' temperature", " If false, it turns on/off by redstone signal instead").define("Automatic Boiler", false);
        BOILER_RANGE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The distance the boiler's air will travel from a source, like the boiler itself or the end of a pipe").defineInRange("Boiler Range", 16, 0, Integer.MAX_VALUE);
        BOILER_MAX_RANGE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum distance that air can be piped away from the boiler").defineInRange("Max Boiler Range", 96, 0, Integer.MAX_VALUE);
        BOILER_MAX_VOLUME = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum volume of the boiler's area of effect").defineInRange("Boiler Volume", 2000, 1, Integer.MAX_VALUE);
        BOILER_WARM_UP_TIME = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The time it takes for the boiler to be fully functional after being placed").defineInRange("Boiler Warm-Up Time", 1200, 0, Integer.MAX_VALUE);
        BOILER_MAX_INSULATION = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum amount of insulation that the boiler can provide").defineInRange("Boiler Warmth Strength", 5, 0, 10);
        BOILER_FUEL_INTERVAL = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " How often the boiler consumes fuel (in ticks)", " Lower numbers cause fuel to be consumed faster. Setting to 0 disables fuel consumption").defineInRange("Boiler Fuel Consumption Interval", 40, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Icebox");
        ENABLE_SMART_ICEBOX = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Allows the icebox to automatically turn on/off based on nearby players' temperature", " If false, it turns on/off by redstone signal instead").define("Automatic Icebox", false);
        ICEBOX_RANGE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The distance the icebox's air will travel from a source, like the icebox itself or the end of a pipe").defineInRange("Icebox Range", 16, 0, Integer.MAX_VALUE);
        ICEBOX_MAX_RANGE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum distance that air can be piped away from the icebox").defineInRange("Max Icebox Range", 96, 0, Integer.MAX_VALUE);
        ICEBOX_MAX_VOLUME = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum volume of the icebox's area of effect").defineInRange("Icebox Volume", 2000, 1, Integer.MAX_VALUE);
        ICEBOX_WARM_UP_TIME = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The time it takes for the icebox to be fully functional after being placed").defineInRange("Icebox Warm-Up Time", 1200, 0, Integer.MAX_VALUE);
        ICEBOX_MAX_INSULATION = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The maximum amount of insulation that the icebox can provide").defineInRange("Icebox Chill Strength", 5, 0, 10);
        ICEBOX_FUEL_INTERVAL = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " How often the icebox consumes fuel (in ticks)", " Lower numbers cause fuel to be consumed faster. Setting to 0 disables fuel consumption").defineInRange("Icebox Fuel Consumption Interval", 40, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        if (CompatManager.isToughAsNailsLoaded()) {
            BUILDER.push("Thermoregulator");
            THERMOREGULATOR_INSULATION = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " The amount of insulation that Tough as Nails's thermoregulator provides", " \u2304 ").defineInRange("Thermoregulator Effect Strength", 10, 0, 10);
            BUILDER.pop();
        } else {
            THERMOREGULATOR_INSULATION = null;
        }
        BUILDER.pop();
        BUILDER.push("Compatibility");
        if (!CompatManager.getSeasonsMods().isEmpty()) {
            BUILDER.push("Seasons");
            BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines the temperature changes caused by each season", " \u251c\u2500\u2500 Format: [seasonStart, seasonMid, seasonEnd, *units]", " \u2514\u2500\u2500 [* = optional]", " \u2022 seasonStart/Mid/End: The temperature offset at the start, middle, and end of the season", " \u2022 *units: The unit of temperature (C, F, or MC)", " \u2304 ");
            SUMMER_TEMPERATURES = BUILDER.defineList("Summer", Arrays.asList(0.4, 0.6, 0.4), it -> it instanceof Number || it instanceof String);
            AUTUMN_TEMPERATURES = BUILDER.defineList("Autumn", Arrays.asList(0.2, 0, -0.2), it -> it instanceof Number || it instanceof String);
            WINTER_TEMPERATURES = BUILDER.defineList("Winter", Arrays.asList(-0.4, -0.6, -0.4), it -> it instanceof Number || it instanceof String);
            SPRING_TEMPERATURES = BUILDER.defineList("Spring", Arrays.asList(-0.2, 0, 0.2), it -> it instanceof Number || it instanceof String);
            BUILDER.pop();
        }
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

