/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ParticleBatchMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ParticleBatchMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"particle_batch"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ParticleBatchMessage> CODEC = CustomPacketPayload.codec(ParticleBatchMessage::encode, ParticleBatchMessage::decode);
    private static final BinaryOperator<Vec3> MIN_POS_COMPARATOR = (a, b) -> new Vec3(Math.min(a.x, b.x), Math.min(a.y, b.y), Math.min(a.z, b.z));
    private static final BinaryOperator<Vec3> MAX_POS_COMPARATOR = (a, b) -> new Vec3(Math.max(a.x, b.x), Math.max(a.y, b.y), Math.max(a.z, b.z));
    Set<Pair<ParticleOptions, ParticlePlacement>> particles = new HashSet<Pair<ParticleOptions, ParticlePlacement>>();
    int minSetting;

    public ParticleBatchMessage(int minSetting) {
        this.minSetting = minSetting;
    }

    public ParticleBatchMessage() {
        this(-1);
    }

    public ParticleBatchMessage addParticle(ParticleOptions particle, ParticlePlacement placement) {
        this.particles.add((Pair<ParticleOptions, ParticlePlacement>)Pair.of((Object)particle, (Object)placement));
        return this;
    }

    public ParticleBatchMessage addParticle(ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.addParticle(particle, new ParticlePlacement(x, y, z, xSpeed, ySpeed, zSpeed));
        return this;
    }

    public void sendEntity(Entity entity) {
        if (this.particles.isEmpty() || entity.level().isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendWorld(Level level) {
        if (this.particles.isEmpty() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 minPos = this.particles.stream().map(Pair::getSecond).map(p -> new Vec3(p.x, p.y, p.z)).reduce(MIN_POS_COMPARATOR).get();
        Vec3 maxPos = this.particles.stream().map(Pair::getSecond).map(p -> new Vec3(p.x, p.y, p.z)).reduce(MAX_POS_COMPARATOR).get();
        Vec3 midPos = minPos.add(maxPos).scale(0.5);
        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)midPos.x, (double)midPos.y, (double)midPos.z, (double)(minPos.distanceTo(maxPos) + 32.0), (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void encode(ParticleBatchMessage message, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(message.minSetting);
        buffer.writeInt(message.particles.size());
        for (Pair<ParticleOptions, ParticlePlacement> entry : message.particles) {
            ParticleTypes.STREAM_CODEC.encode((Object)buffer, (Object)((ParticleOptions)entry.getFirst()));
            buffer.writeNbt((Tag)((ParticlePlacement)entry.getSecond()).toNBT());
        }
    }

    public static ParticleBatchMessage decode(RegistryFriendlyByteBuf buffer) {
        ParticleBatchMessage message = new ParticleBatchMessage(buffer.readInt());
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ParticleOptions particle = (ParticleOptions)ParticleTypes.STREAM_CODEC.decode((Object)buffer);
            ParticlePlacement placement = ParticlePlacement.fromNBT(buffer.readNbt());
            message.addParticle(particle, placement);
        }
        return message;
    }

    public static void handle(ParticleBatchMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            for (Pair<ParticleOptions, ParticlePlacement> entry : message.particles) {
                ParticleOptions particle = (ParticleOptions)entry.getFirst();
                ParticlePlacement placement = (ParticlePlacement)entry.getSecond();
                if (message.minSetting != -1 && ((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId() > message.minSetting) continue;
                Minecraft.getInstance().level.addParticle(particle, placement.x, placement.y, placement.z, placement.vx, placement.vy, placement.vz);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class ParticlePlacement {
        double x;
        double y;
        double z;
        double vx;
        double vy;
        double vz;

        public ParticlePlacement(double x, double y, double z, double vx, double vy, double vz) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.putDouble("x", this.x);
            tag.putDouble("y", this.y);
            tag.putDouble("z", this.z);
            tag.putDouble("vx", this.vx);
            tag.putDouble("vy", this.vy);
            tag.putDouble("vz", this.vz);
            return tag;
        }

        public static ParticlePlacement fromNBT(CompoundTag tag) {
            return new ParticlePlacement(tag.getDouble("x"), tag.getDouble("y"), tag.getDouble("z"), tag.getDouble("vx"), tag.getDouble("vy"), tag.getDouble("vz"));
        }
    }
}

