/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;

public record EntityFlagsRequirement(Optional<Boolean> onFire, Optional<Boolean> sneaking, Optional<Boolean> sprinting, Optional<Boolean> swimming, Optional<Boolean> invisible, Optional<Boolean> glowing, Optional<Boolean> baby, Optional<Boolean> inWater, Optional<Boolean> inLava) {
    public static final Codec<EntityFlagsRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_on_fire").forGetter(predicate -> predicate.onFire), (App)Codec.BOOL.optionalFieldOf("is_sneaking").forGetter(predicate -> predicate.sneaking), (App)Codec.BOOL.optionalFieldOf("is_sprinting").forGetter(predicate -> predicate.sprinting), (App)Codec.BOOL.optionalFieldOf("is_swimming").forGetter(predicate -> predicate.swimming), (App)Codec.BOOL.optionalFieldOf("is_invisible").forGetter(predicate -> predicate.invisible), (App)Codec.BOOL.optionalFieldOf("is_glowing").forGetter(predicate -> predicate.glowing), (App)Codec.BOOL.optionalFieldOf("is_baby").forGetter(predicate -> predicate.baby), (App)Codec.BOOL.optionalFieldOf("is_in_water").forGetter(predicate -> predicate.inWater), (App)Codec.BOOL.optionalFieldOf("is_in_lava").forGetter(predicate -> predicate.inLava)).apply((Applicative)instance, EntityFlagsRequirement::new));

    public boolean test(Entity entity) {
        AgeableMob mob;
        return !(!this.onFire.isEmpty() && entity.isOnFire() != this.onFire.get().booleanValue() || !this.sneaking.isEmpty() && entity.isCrouching() != this.sneaking.get().booleanValue() || !this.sprinting.isEmpty() && entity.isSprinting() != this.sprinting.get().booleanValue() || !this.swimming.isEmpty() && entity.isInWater() != this.swimming.get().booleanValue() || !this.invisible.isEmpty() && entity.isInvisible() != this.invisible.get().booleanValue() || !this.glowing.isEmpty() && entity.isCurrentlyGlowing() != this.glowing.get().booleanValue() || !this.baby.isEmpty() && (entity instanceof AgeableMob && (mob = (AgeableMob)entity).isBaby()) != this.baby.get() || !this.inWater.isEmpty() && entity.isInWater() != this.inWater.get().booleanValue() || !this.inLava.isEmpty() && entity.isInLava() != this.inLava.get().booleanValue());
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityFlagsRequirement that = (EntityFlagsRequirement)obj;
        return this.onFire.equals(that.onFire) && this.sneaking.equals(that.sneaking) && this.sprinting.equals(that.sprinting) && this.swimming.equals(that.swimming) && this.invisible.equals(that.invisible) && this.glowing.equals(that.glowing) && this.baby.equals(that.baby);
    }
}

