/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.StringRepresentable;

public abstract class Insulation {
    public static Codec<Insulation> getCodec() {
        return Codec.either(StaticInsulation.CODEC, AdaptiveInsulation.CODEC).xmap(either -> (Insulation)either.map(stat -> stat, adapt -> adapt), insul -> {
            if (insul instanceof StaticInsulation) {
                return Either.left((Object)((StaticInsulation)insul));
            }
            return Either.right((Object)((AdaptiveInsulation)insul));
        });
    }

    public abstract boolean isEmpty();

    public abstract List<Insulation> split();

    public abstract double getCold();

    public abstract double getHeat();

    public abstract double getValue();

    public abstract <T extends Insulation> T copy();

    public static List<Insulation> deepCopy(List<Insulation> list) {
        ArrayList<Insulation> newList = new ArrayList<Insulation>();
        for (Insulation insul : list) {
            newList.add((Insulation)insul.copy());
        }
        return newList;
    }

    public static List<Insulation> splitList(List<Insulation> pairs) {
        ArrayList<Insulation> newPairs = new ArrayList<Insulation>();
        for (Insulation pair : pairs) {
            newPairs.addAll(pair.split());
        }
        return newPairs;
    }

    public static List<Insulation> combine(List<Insulation> list1, List<Insulation> list2) {
        ArrayList<Insulation> combined = new ArrayList<Insulation>();
        ArrayList<Insulation> remaining = new ArrayList<Insulation>(list2);
        for (Insulation ins1 : list1) {
            if (ins1 instanceof StaticInsulation) {
                StaticInsulation staticIns1 = (StaticInsulation)ins1;
                boolean matched = false;
                for (int i = 0; i < remaining.size(); ++i) {
                    StaticInsulation staticIns2;
                    Insulation ins2 = (Insulation)remaining.get(i);
                    if (!(ins2 instanceof StaticInsulation) || !Insulation.combineStaticInsulations(staticIns1, staticIns2 = (StaticInsulation)ins2, combined)) continue;
                    remaining.remove(i);
                    matched = true;
                    break;
                }
                if (matched) continue;
                combined.add(staticIns1);
                continue;
            }
            combined.add(ins1);
        }
        combined.addAll(remaining);
        combined.removeIf(Insulation::isEmpty);
        return combined;
    }

    private static boolean combineStaticInsulations(StaticInsulation ins1, StaticInsulation ins2, List<Insulation> result) {
        double cold1 = ins1.getCold();
        double heat1 = ins1.getHeat();
        double cold2 = ins2.getCold();
        double heat2 = ins2.getHeat();
        if (cold1 > 0.0 && heat2 > 0.0) {
            Insulation.combineValues(cold1, heat2, result);
            return true;
        }
        if (heat1 > 0.0 && cold2 > 0.0) {
            Insulation.combineValues(cold2, heat1, result);
            return true;
        }
        return false;
    }

    private static void combineValues(double coldValue, double heatValue, List<Insulation> result) {
        if (coldValue == heatValue) {
            result.add(new StaticInsulation(coldValue, heatValue));
        } else {
            double minValue = Math.min(coldValue, heatValue);
            result.add(new StaticInsulation(minValue, minValue));
            if (coldValue > minValue) {
                result.add(new StaticInsulation(coldValue - minValue, 0.0));
            }
            if (heatValue > minValue) {
                result.add(new StaticInsulation(0.0, heatValue - minValue));
            }
        }
    }

    public static List<Insulation> sort(List<Insulation> pairs) {
        ArrayList<Insulation> newPairs = new ArrayList<Insulation>(pairs);
        newPairs.sort(Comparator.comparingInt(Insulation::getCompareValue));
        return newPairs;
    }

    public int getCompareValue() {
        List<Insulation> subset = this.split();
        if (subset.size() > 1) {
            return Insulation.sort(subset).get(0).getCompareValue() - 10;
        }
        Insulation insulation = this;
        if (insulation instanceof AdaptiveInsulation) {
            AdaptiveInsulation insul = (AdaptiveInsulation)insulation;
            return Math.abs(insul.getInsulation()) >= 2.0 ? 7 : 8;
        }
        insulation = this;
        if (insulation instanceof StaticInsulation) {
            double hot;
            StaticInsulation insul = (StaticInsulation)insulation;
            double cold = Math.abs(insul.getCold());
            if (cold > (hot = Math.abs(insul.getHeat()))) {
                return cold >= 2.0 ? 1 : 2;
            }
            if (cold == hot) {
                return cold >= 1.0 ? 3 : 4;
            }
            return hot >= 2.0 ? 5 : 6;
        }
        return 0;
    }

    public static enum Type implements StringRepresentable
    {
        COLD("cold"),
        HEAT("heat"),
        NEUTRAL("neutral"),
        ADAPTIVE("adaptive");

        final String name;
        public static final Codec<Type> CODEC;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Type byName(String name) {
            return (Type)EnumHelper.byName((Enum[])Type.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Type.values());
        }
    }

    public static enum Slot implements StringRepresentable
    {
        ITEM("item"),
        CURIO("curio"),
        ARMOR("armor");

        final String name;
        public static final Codec<Slot> CODEC;

        private Slot(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Slot byName(String name) {
            return (Slot)EnumHelper.byName((Enum[])Slot.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Slot.values());
        }
    }
}

