/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FreezeKnockbackEffect
extends TempEffect {
    public FreezeKnockbackEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onPlayerKnockback(LivingKnockBackEvent event) {
        if (!this.test((Entity)event.getEntity().m_21188_())) {
            return;
        }
        float knockbackReduction = ConfigSettings.COLD_KNOCKBACK_REDUCTION.get().floatValue();
        if (knockbackReduction == 0.0f) {
            return;
        }
        float effect = (float)this.getEffectFactor();
        event.setStrength(event.getStrength() * CSMath.blend(1.0f, 1.0f - knockbackReduction, effect, 0.0f, 1.0f));
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.SERVER;
    }
}

