/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;

public class FoodTempModifier
extends TempModifier {
    public FoodTempModifier() {
        this(0.0);
    }

    public FoodTempModifier(double temperature) {
        this.getNBT().m_128347_("temperature", temperature);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (this.isOverridden(trait)) {
            return temp -> temp;
        }
        return temp -> temp + this.getNBT().m_128459_("temperature");
    }

    public boolean isOverridden(Temperature.Trait trait) {
        return this.getNBT().m_128469_("Overridden").m_128451_(trait.m_7912_()) > 0;
    }

    private void incrementOverridden(Temperature.Trait trait, boolean add) {
        if (!this.getNBT().m_128441_("Overridden")) {
            this.getNBT().m_128365_("Overridden", (Tag)new CompoundTag());
        }
        NBTHelper.incrementTag(this.getNBT().m_128469_("Overridden"), trait.m_7912_(), add ? 1 : -1, o -> true);
    }

    private void updateOverridden(LivingEntity entity, Temperature.Trait trait, TempModifier sibling, boolean add) {
        double temperature = this.getNBT().m_128459_("temperature");
        if (sibling instanceof FoodTempModifier) {
            double siblingTemp = sibling.getNBT().m_128459_("temperature");
            if (CSMath.sign(temperature) == CSMath.sign(siblingTemp) && Math.abs(siblingTemp) > Math.abs(temperature)) {
                this.incrementOverridden(trait, add);
                this.markDirty();
            }
            this.update(this.getLastInput(trait), entity, trait);
        }
    }

    @Override
    public void onSiblingAdded(LivingEntity entity, Temperature.Trait trait, TempModifier sibling) {
        this.updateOverridden(entity, trait, sibling, true);
    }

    @Override
    public void onAdded(LivingEntity entity, Temperature.Trait trait) {
        Temperature.getModifiers(entity, trait).forEach(mod -> this.updateOverridden(entity, trait, (TempModifier)mod, true));
    }

    @Override
    public void onSiblingRemoved(LivingEntity entity, Temperature.Trait trait, TempModifier sibling) {
        this.updateOverridden(entity, trait, sibling, false);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TempModifier) {
            TempModifier mod = (TempModifier)obj;
            if (this.getClass().equals(mod.getClass())) {
                CompoundTag thisNBT = this.getNBT().m_6426_();
                thisNBT.m_128473_("Overridden");
                CompoundTag otherNBT = mod.getNBT().m_6426_();
                otherNBT.m_128473_("Overridden");
                return otherNBT.equals((Object)thisNBT);
            }
        }
        return false;
    }
}

