/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterItemOverrides {
    public static final ItemPropertyFunction SOULSPRING_LAMP_PROPERTIES = (stack, level, entity, id) -> {
        if (SoulspringLampItem.isLit(stack)) {
            double fuel = SoulspringLampItem.getFuel(stack);
            return fuel > 43.0 ? 3.0f : (fuel > 22.0 ? 2.0f : 1.0f);
        }
        return 0.0f;
    };
    private static final Field ITEM_PROPERTIES = ObfuscationReflectionHelper.findField(ItemProperties.class, (String)"f_117825_");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (!ConfigSettings.ANIMATED_SOULSPRING_LAMP_MODEL.get().booleanValue()) {
                ItemProperties.register((Item)((Item)ItemInit.SOULSPRING_LAMP.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "soulspring_state"), (ItemPropertyFunction)SOULSPRING_LAMP_PROPERTIES);
            }
            ItemProperties.register((Item)((Item)ItemInit.FILLED_WATERSKIN.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "water_temperature"), (stack, level, entity, id) -> stack.m_41784_().m_128457_("Temperature"));
            ItemProperties.register((Item)((Item)ItemInit.THERMOMETER.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "temperature"), (stack, level, livingEntity, id) -> {
                if (livingEntity instanceof Player) {
                    double worldTemp;
                    Player player = (Player)livingEntity;
                    double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
                    double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
                    if (!player.getPersistentData().m_128441_("WorldTempTimestamp") || player.f_19797_ % 2 == 0 && player.getPersistentData().m_128451_("WorldTempTimestamp") != player.f_19797_) {
                        worldTemp = Temperature.convert(Overlays.WORLD_TEMP, Preference.getOrDefault(player, Preference.UNITS, Temperature.Units.F), Temperature.Units.MC, true);
                        player.getPersistentData().m_128347_("WorldTemp", worldTemp);
                        player.getPersistentData().m_128405_("WorldTempTimestamp", player.f_19797_);
                    } else {
                        worldTemp = player.getPersistentData().m_128459_("WorldTemp");
                    }
                    double worldTempAdjusted = Overlays.getWorldSeverity(worldTemp, minTemp, maxTemp) * 1.01;
                    return (float)worldTempAdjusted;
                }
                return 0.0f;
            });
        });
    }

    public static void unregister(Item item) {
        try {
            Map properties = (Map)ITEM_PROPERTIES.get(null);
            properties.remove(item);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ITEM_PROPERTIES.setAccessible(true);
    }
}

