/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.core.init.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ContainerChangedEvent;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.AcclimationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.CaveBiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntitiesTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntityClimateTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FreezingTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FrigidnessTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ShadeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ThermalSourceTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WarmthTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.temperature.AbstractTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.ModUpdater;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.tag.ModEntityTags;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityTempManager {
    public static final Temperature.Trait[] VALID_TEMPERATURE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForTemperature).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_MODIFIER_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForModifiers).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_ATTRIBUTE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForAttributes).toArray(Temperature.Trait[]::new);
    public static final Set<EntityType<? extends LivingEntity>> TEMPERATURE_ENABLED_ENTITIES = new HashSet<EntityType>(List.of(EntityType.f_20532_));
    public static SidedCapabilityCache<ITemperatureCap, Entity> CAP_CACHE = new SidedCapabilityCache<ITemperatureCap, Entity>(ModCapabilities.ENTITY_TEMPERATURE, Entity::m_213877_);
    public static Map<Entity, Map<ResourceLocation, Double>> TEMP_MODIFIER_IMMUNITIES = new WeakHashMap<Entity, Map<ResourceLocation, Double>>();
    private static final Field MENU_OWNER = ObfuscationReflectionHelper.findField(InventoryMenu.class, (String)"f_39703_");

    public static LazyOptional<ITemperatureCap> getTemperatureCap(Entity entity) {
        return EntityTempManager.isTemperatureEnabled(entity) ? CAP_CACHE.get(entity) : LazyOptional.empty();
    }

    public static Map<Temperature.Trait, List<TempModifier>> gatherTempModifiers(LivingEntity entity) {
        DefaultTempModifiersEvent modifiersEvent = new DefaultTempModifiersEvent(entity);
        MinecraftForge.EVENT_BUS.post((Event)modifiersEvent);
        Map<Temperature.Trait, List<TempModifier>> modifiers = modifiersEvent.getModifiers();
        for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
            GatherDefaultTempModifiersEvent gatherEvent = new GatherDefaultTempModifiersEvent(entity, modifiers.get((Object)trait), trait);
            MinecraftForge.EVENT_BUS.post((Event)gatherEvent);
            modifiers.put(trait, gatherEvent.getModifiers());
        }
        return modifiers;
    }

    private static void updateInventoryTempAttributes(ItemStack oldStack, ItemStack newStack, LivingEntity entity) {
        for (ItemTempData itemTempData : ConfigSettings.ITEM_TEMPERATURES.get().get((Object)oldStack.m_41720_())) {
            entity.m_21204_().m_22161_(itemTempData.attributeModifiers().getMap());
        }
        for (ItemTempData itemTempData : ConfigSettings.ITEM_TEMPERATURES.get().get((Object)newStack.m_41720_())) {
            if (!itemTempData.test((Entity)entity, newStack)) continue;
            entity.m_21204_().m_22178_(itemTempData.attributeModifiers().getMap());
        }
    }

    private static Player getOwner(InventoryMenu menu) {
        try {
            return (Player)MENU_OWNER.get(menu);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void updateInsulationAttributeModifiers(LivingEntity entity, ItemStack from, ItemStack to, Insulation.Slot slot) {
        for (InsulatorData insulatorData : ItemInsulationManager.getInsulatorsForStack(from, slot)) {
            entity.m_21204_().m_22161_(insulatorData.attributes().getMap());
        }
        for (InsulatorData insulatorData : RequirementHolder.filterValid(ItemInsulationManager.getInsulatorsForStack(to, slot), (Entity)entity)) {
            entity.m_21204_().m_22178_(insulatorData.attributes().getMap());
        }
    }

    public static Set<EntityType<? extends LivingEntity>> getEntitiesWithTemperature() {
        return ImmutableSet.copyOf(TEMPERATURE_ENABLED_ENTITIES);
    }

    public static boolean isTemperatureEnabled(EntityType<?> type) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(type);
    }

    public static boolean isTemperatureEnabled(Entity entity) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(entity.m_6095_());
    }

    public static boolean hasClimateData(EntityType<?> entity) {
        return ConfigSettings.ENTITY_CLIMATES.get().containsKey(entity);
    }

    public static boolean hasClimateData(Entity entity) {
        return ConfigSettings.ENTITY_CLIMATES.get().containsKey((Object)entity.m_6095_());
    }

    public static boolean isPeacefulMode(LivingEntity entity) {
        return entity.m_9236_().m_46791_() == Difficulty.PEACEFUL && ConfigSettings.USE_PEACEFUL_MODE.get() != false;
    }

    public static boolean isImmuneToTemperature(LivingEntity player) {
        return player == null || !player.m_6084_() || EntityTempManager.isPeacefulMode(player) || player.m_21023_(ModEffects.GRACE);
    }

    public static double getColdResistance(LivingEntity entity) {
        return entity.m_21023_(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get(entity, Temperature.Trait.COLD_RESISTANCE);
    }

    public static double getHeatResistance(LivingEntity player) {
        return player.m_21023_(MobEffects.f_19607_) && ConfigSettings.FIRE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get(player, Temperature.Trait.HEAT_RESISTANCE);
    }

    public static double getResistance(double temperature, LivingEntity player) {
        return temperature < 0.0 ? EntityTempManager.getColdResistance(player) : EntityTempManager.getHeatResistance(player);
    }

    public static Map<ItemStack, InsulatorData> getInsulatorsOnEntity(LivingEntity entity) {
        HashMap<ItemStack, InsulatorData> insulators = new HashMap<ItemStack, InsulatorData>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (!slot.m_254934_() || (stack = entity.m_6844_(slot)).m_41619_()) continue;
            ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.m_41720_()).forEach(insul -> insulators.put(stack, (InsulatorData)insul));
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> ConfigSettings.INSULATION_ITEMS.get().get((Object)item.m_41720_()).forEach(insul -> insulators.put((ItemStack)item, (InsulatorData)insul))));
        }
        for (ItemStack curio : CompatManager.Curios.getCurios(entity)) {
            ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.m_41720_()).forEach(insul -> insulators.put(curio, (InsulatorData)insul));
        }
        return insulators;
    }

    public static Map<ItemStack, ItemTempData> getItemTemperaturesOnEntity(LivingEntity entity) {
        HashMap<ItemStack, ItemTempData> tempItems = new HashMap<ItemStack, ItemTempData>();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (stack.m_41619_()) continue;
                int slotIndex = i;
                ConfigSettings.ITEM_TEMPERATURES.get().get((Object)stack.m_41720_()).forEach(temp -> {
                    if (temp.test((Entity)player, stack, slotIndex, null)) {
                        tempItems.put(stack, (ItemTempData)temp);
                    }
                });
            }
        }
        for (Player slot : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_((EquipmentSlot)slot);
            if (stack.m_41619_()) continue;
            ItemTempData.SlotType slotType = ItemTempData.SlotType.fromEquipment((EquipmentSlot)slot);
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)stack.m_41720_()).forEach(temp -> {
                if (temp.test((Entity)entity, stack, slotType)) {
                    tempItems.put(stack, (ItemTempData)temp);
                }
            });
        }
        for (ItemStack curio : CompatManager.Curios.getCurios(entity)) {
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)curio.m_41720_()).forEach(temp -> {
                if (temp.test((Entity)entity, curio, ItemTempData.SlotType.CURIO)) {
                    tempItems.put(curio, (ItemTempData)temp);
                }
            });
        }
        ItemStack offhand = entity.m_21206_();
        if (!offhand.m_41619_()) {
            ConfigSettings.ITEM_TEMPERATURES.get().get((Object)offhand.m_41720_()).forEach(temp -> {
                if (temp.test((Entity)entity, offhand, ItemTempData.SlotType.HAND)) {
                    tempItems.put(offhand, (ItemTempData)temp);
                }
            });
        }
        return tempItems;
    }

    @Nullable
    public static AttributeInstance getAttribute(Temperature.Trait trait, LivingEntity entity) {
        return switch (trait) {
            case Temperature.Trait.WORLD -> entity.m_21051_(ModAttributes.WORLD_TEMPERATURE);
            case Temperature.Trait.BASE -> entity.m_21051_(ModAttributes.BASE_BODY_TEMPERATURE);
            case Temperature.Trait.RATE -> entity.m_21051_(ModAttributes.TEMP_RATE);
            case Temperature.Trait.FREEZING_POINT -> entity.m_21051_(ModAttributes.FREEZING_POINT);
            case Temperature.Trait.BURNING_POINT -> entity.m_21051_(ModAttributes.BURNING_POINT);
            case Temperature.Trait.HEAT_RESISTANCE -> entity.m_21051_(ModAttributes.HEAT_RESISTANCE);
            case Temperature.Trait.COLD_RESISTANCE -> entity.m_21051_(ModAttributes.COLD_RESISTANCE);
            case Temperature.Trait.HEAT_DAMPENING -> entity.m_21051_(ModAttributes.HEAT_DAMPENING);
            case Temperature.Trait.COLD_DAMPENING -> entity.m_21051_(ModAttributes.COLD_DAMPENING);
            default -> throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
        };
    }

    public static Collection<AttributeModifier> getAllAttributeModifiers(LivingEntity entity, AttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation == null ? attribute.m_22122_() : attribute.m_22104_(operation));
        modifiers.addAll(EntityTempManager.getAllEquipmentAttributeModifiers(entity, attribute, operation));
        return modifiers;
    }

    public static Collection<AttributeModifier> getAllEquipmentAttributeModifiers(LivingEntity entity, AttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (!slot.m_254934_() || (stack = entity.m_6844_(slot)).m_41619_()) continue;
            modifiers.addAll(ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute.m_22099_(), slot, operation, (Entity)entity));
        }
        return modifiers;
    }

    public static AttributeModifier makeAttributeModifier(Temperature.Trait trait, double value, AttributeModifier.Operation operation) {
        if (!trait.isForAttributes()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
        }
        return new AttributeModifier(String.format("%s temperature modifier", trait.m_7912_()), value, operation);
    }

    public static boolean isTemperatureAttribute(Attribute attribute) {
        return ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).m_135827_().equals("cold_sweat");
    }

    public static List<AttributeInstance> getAllTemperatureAttributes(LivingEntity entity) {
        return Arrays.stream(VALID_ATTRIBUTE_TRAITS).map(trait -> EntityTempManager.getAttribute(trait, entity)).filter(Objects::nonNull).toList();
    }

    public static List<TempModifier> getAllModifiers(LivingEntity entity) {
        ArrayList<TempModifier> allModifiers = new ArrayList<TempModifier>();
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                allModifiers.addAll(cap.getModifiers(trait));
            }
        });
        return allModifiers;
    }

    static {
        MENU_OWNER.setAccessible(true);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
            LivingEntity entity;
            Object object = event.getObject();
            if (object instanceof LivingEntity && TEMPERATURE_ENABLED_ENTITIES.contains((entity = (LivingEntity)object).m_6095_())) {
                final AbstractTempCap tempCap = entity instanceof Player ? new PlayerTempCap() : new EntityTempCap();
                final LazyOptional capOptional = LazyOptional.of(() -> tempCap);
                ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                    @Nonnull
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                        if (cap == ModCapabilities.ENTITY_TEMPERATURE) {
                            return capOptional.cast();
                        }
                        return LazyOptional.empty();
                    }

                    public CompoundTag serializeNBT() {
                        return tempCap.serializeNBT();
                    }

                    public void deserializeNBT(CompoundTag nbt) {
                        tempCap.deserializeNBT(nbt);
                    }
                };
                event.addCapability(new ResourceLocation("cold_sweat", "temperature"), (ICapabilityProvider)provider);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void handleModUpdates(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                ModUpdater.updateEntity((LivingEntity)entity);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void defineDefaultModifiers(DefaultTempModifiersEvent event) {
            LivingEntity entity = event.getEntity();
            boolean isPlayer = entity instanceof Player;
            boolean isTempSensitive = entity.m_6095_().m_204039_(ModEntityTags.TEMPERATURE_SENSITIVE);
            if (EntityTempManager.hasClimateData((Entity)entity)) {
                boolean wasAdvanced;
                boolean isAdvanced = ConfigSettings.ADVANCED_ENTITY_TEMPERATURE.get();
                if (isAdvanced != (wasAdvanced = entity.getPersistentData().m_128471_("AdvancedTemperature"))) {
                    Temperature.getModifiers(entity).clear();
                    entity.getPersistentData().m_128379_("AdvancedTemperature", isAdvanced);
                }
                if (!isAdvanced) {
                    event.addModifier(List.of(Temperature.Trait.WORLD, Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT), (TempModifier)new EntityClimateTempModifier().tickRate(200), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
                    return;
                }
            }
            double tickMultiplier = isPlayer ? 1.0 : (isTempSensitive ? 4.0 : 40.0);
            int slowTickRate = (int)Math.min(60.0 * tickMultiplier, 400.0);
            int mediumTickRate = (int)(10.0 * tickMultiplier * 2.0);
            int mediumTickRate2 = (int)(10.0 * tickMultiplier);
            int fastTickRate = (int)(5.0 * tickMultiplier);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new BiomeTempModifier(isPlayer ? 49 : (isTempSensitive ? 16 : 9)).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new ElevationTempModifier(isPlayer ? 49 : (isTempSensitive ? 16 : 1)).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof BiomeTempModifier));
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new ShadeTempModifier().tickRate(10), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod -> mod instanceof ElevationTempModifier));
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new CaveBiomeTempModifier(isPlayer ? 6 : (isTempSensitive ? 5 : 3)).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof ElevationTempModifier));
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new BlockTempModifier(isPlayer ? -1 : 4).tickRate(fastTickRate), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifier(Temperature.Trait.WORLD, (TempModifier)new EntitiesTempModifier().tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifierById(Temperature.Trait.WORLD, new ResourceLocation("sereneseasons:season"), mod -> mod.tickRate(slowTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BiomeTempModifier));
            event.addModifierById(Temperature.Trait.WORLD, new ResourceLocation("weather2:storm"), mod -> mod.tickRate(slowTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BiomeTempModifier));
            event.addModifierById(Temperature.Trait.WORLD, new ResourceLocation("valkyrienskies:ship_blocks"), mod -> mod.tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BlockTempModifier));
            event.addModifierById(Temperature.Trait.WORLD, new ResourceLocation("ad_astra:oxygen"), mod -> mod.tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            if (isPlayer && !(entity instanceof DummyPlayer)) {
                event.addModifier(List.of(Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT), (TempModifier)new AcclimationTempModifier().tickRate(20), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
                event.addModifier(Arrays.asList(VALID_MODIFIER_TRAITS), (TempModifier)new InventoryItemsTempModifier().tickRate(5), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            }
        }

        @SubscribeEvent
        public static void initModifiersOnEntity(EntityJoinLevelEvent event) {
            LivingEntity living;
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).m_9236_().m_5776_() && EntityTempManager.isTemperatureEnabled((Entity)living)) {
                EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                    Map<Temperature.Trait, List<TempModifier>> modifiers = EntityTempManager.gatherTempModifiers(living);
                    cap.clearModifiers();
                    cap.setModifiers(modifiers);
                    TaskScheduler.scheduleServer(() -> {
                        cap.tick(living);
                        Temperature.updateTemperature(living, cap, true);
                        Temperature.updateModifiers(living, cap);
                    }, 1);
                });
            }
        }

        @SubscribeEvent
        public static synchronized void cleanRemovedEntities(EntityLeaveLevelEvent event) {
            if (EntityTempManager.isTemperatureEnabled(event.getEntity())) {
                TEMP_MODIFIER_IMMUNITIES.keySet().removeIf(Entity::m_213877_);
            }
        }

        @SubscribeEvent
        public static void tickTemperature(LivingEvent.LivingTickEvent event) {
            LivingEntity entity = event.getEntity();
            if (!TEMPERATURE_ENABLED_ENTITIES.contains(entity.m_6095_())) {
                return;
            }
            EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
                if (!entity.m_9236_().f_46443_) {
                    if (entity instanceof Player || entity.f_19797_ % 5 == 0) {
                        cap.tick(entity);
                    }
                } else {
                    cap.tickDummy(entity);
                }
                AtomicBoolean sync = new AtomicBoolean(false);
                for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                    List<TempModifier> modifiers = cap.getModifiers(trait);
                    for (int i = 0; i < modifiers.size(); ++i) {
                        boolean expired;
                        TempModifier modifier = modifiers.get(i);
                        if (modifier.getTicksExisted() % modifier.getTickRate() == 0) {
                            modifier.tick(entity);
                        }
                        if (modifier.isDirty()) {
                            sync.set(true);
                            modifier.markClean();
                        }
                        int expireTime = modifier.getExpireTime();
                        boolean bl = expired = modifier.setTicksExisted(modifier.getTicksExisted() + 1) > expireTime && expireTime != -1;
                        if (!expired) continue;
                        cap.removeModifier(modifier, trait);
                        modifier.onRemoved(entity, trait);
                        Temperature.updateSiblingsRemove(modifiers, entity, trait, modifier);
                        --i;
                    }
                }
                if (sync.get()) {
                    Temperature.updateModifiers(entity, cap);
                }
                if (!entity.m_9236_().m_5776_() && EntityTempManager.hasClimateData((Entity)entity) && entity.f_19797_ % 5 == 0 && entity.m_217043_().m_188500_() < 0.1) {
                    double worldTemp = cap.getTrait(Temperature.Trait.WORLD);
                    double entityX = entity.m_20185_();
                    double entityY = entity.m_20186_() + (double)entity.m_20206_();
                    double entityZ = entity.m_20189_();
                    if (worldTemp < cap.getTrait(Temperature.Trait.FREEZING_POINT)) {
                        WorldHelper.spawnParticleBatch(entity.m_9236_(), (ParticleOptions)ParticleTypesInit.MOB_COLD.get(), entityX, entityY, entityZ, 0.5, 0.5, 0.5, entity.m_217043_().m_216339_(2, 4), 0.0);
                    } else if (worldTemp > cap.getTrait(Temperature.Trait.BURNING_POINT)) {
                        WorldHelper.spawnParticleBatch(entity.m_9236_(), (ParticleOptions)ParticleTypesInit.MOB_HOT.get(), entityX, entityY, entityZ, 0.5, 0.5, 0.5, entity.m_217043_().m_216339_(2, 4), 0.0);
                    }
                }
            });
        }

        @SubscribeEvent
        public static void carryOverPersistentAttributes(PlayerEvent.Clone event) {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            if (!newPlayer.m_9236_().f_46443_) {
                oldPlayer.reviveCaps();
                ((Collection)EntityTempManager.getTemperatureCap((Entity)oldPlayer).map(ITemperatureCap::getPersistentAttributes).orElse(new HashSet())).forEach(attr -> {
                    AttributeInstance newAttr = newPlayer.m_21051_(attr);
                    AttributeInstance oldAttr = oldPlayer.m_21051_(attr);
                    if (newAttr != null && oldAttr != null) {
                        newAttr.m_22100_(oldAttr.m_22115_());
                        EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> cap.markPersistentAttribute((Attribute)attr));
                    }
                });
                oldPlayer.invalidateCaps();
            }
        }

        @SubscribeEvent
        public static void handlePlayerReset(PlayerEvent.Clone event) {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> {
                if (!event.isWasDeath()) {
                    oldPlayer.reviveCaps();
                    EntityTempManager.getTemperatureCap((Entity)oldPlayer).ifPresent(cap::copy);
                    oldPlayer.invalidateCaps();
                }
            });
            CAP_CACHE.remove((Entity)oldPlayer);
        }

        @SubscribeEvent
        public static void addInventoryListeners(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                final Player player = (Player)entity;
                player.f_36096_.m_38893_(new ContainerListener(){

                    public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
                        Slot slot = menu.m_38853_(slotIndex);
                        if (!(slot instanceof ResultSlot) && slot.f_40218_ == player.m_150109_() && ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.m_41720_())) {
                            player.m_7902_(new ResourceLocation[]{new ResourceLocation("cold_sweat", "sewing_table")});
                        }
                    }

                    public void m_142153_(AbstractContainerMenu menu, int slot, int value) {
                    }
                });
            }
        }

        @SubscribeEvent
        public static void cancelDisabledModifiers(TempModifierEvent.Calculate.Pre event) {
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            if (modifierKey != null && ConfigSettings.DISABLED_MODIFIERS.get().contains(modifierKey)) {
                modifier.expires(0);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void calculateModifierImmunity(LivingEvent.LivingTickEvent event) {
            LivingEntity entity = event.getEntity();
            if (!entity.m_9236_().m_5776_() && entity.f_19797_ % 20 == 0 && EntityTempManager.isTemperatureEnabled((Entity)entity)) {
                HashMap<ResourceLocation, Double> immunities = new HashMap<ResourceLocation, Double>();
                for (Map.Entry<ItemStack, InsulatorData> entry : EntityTempManager.getInsulatorsOnEntity(entity).entrySet()) {
                    ItemStack stack;
                    InsulatorData insulator = entry.getValue();
                    if (!insulator.test((Entity)entity, stack = entry.getKey())) continue;
                    immunities.putAll(insulator.immuneTempModifiers());
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    for (Map.Entry<ItemStack, ItemTempData> entry : EntityTempManager.getItemTemperaturesOnEntity((LivingEntity)player).entrySet()) {
                        immunities.putAll(entry.getValue().immuneTempModifiers());
                    }
                    if (player.m_20202_() != null) {
                        for (MountData mountData : ConfigSettings.INSULATED_MOUNTS.get().get((Object)player.m_20202_().m_6095_())) {
                            immunities.putAll(mountData.modifierImmunities());
                        }
                    }
                }
                TEMP_MODIFIER_IMMUNITIES.put((Entity)entity, immunities);
            }
        }

        @SubscribeEvent
        public static void checkModifierImmunity(TempModifierEvent.Calculate.Post event) {
            if (event.getEntity() instanceof DummyPlayer) {
                return;
            }
            if (!event.getTrait().isForAttributes()) {
                return;
            }
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            LivingEntity entity = event.getEntity();
            double immunity = TEMP_MODIFIER_IMMUNITIES.getOrDefault(entity, Collections.emptyMap()).getOrDefault(modifierKey, 0.0);
            if (immunity > 0.0) {
                Function<Double, Double> oldFunction = event.getFunction();
                event.setFunction(temp -> {
                    double lastInput = modifier instanceof BiomeTempModifier ? Temperature.getNeutralWorldTemp(entity) : temp;
                    return CSMath.blend((Double)oldFunction.apply((Double)temp), lastInput, immunity, 0.0, 1.0);
                });
            }
        }

        @SubscribeEvent
        public static void preventFullyImmuneModifiers(TempModifierEvent.Add event) {
            if (event.getEntity() instanceof DummyPlayer) {
                return;
            }
            if (!event.getTrait().isForAttributes()) {
                return;
            }
            TempModifier modifier = event.getModifier();
            ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
            LivingEntity entity = event.getEntity();
            double immunity = TEMP_MODIFIER_IMMUNITIES.getOrDefault(entity, Collections.emptyMap()).getOrDefault(modifierKey, 0.0);
            if (immunity == 1.0) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void handleWaterFreezingFire(TickEvent.PlayerTickEvent event) {
            Player player = event.player;
            if (!player.m_9236_().f_46443_ && event.phase == TickEvent.Phase.START) {
                if (player.f_19797_ % 5 == 0) {
                    if (!player.m_5833_() && (WorldHelper.isInWater((Entity)player) || player.f_19797_ % 40 == 0 && WorldHelper.isRainingAt(player.m_9236_(), player.m_20183_()))) {
                        Temperature.addModifier((LivingEntity)player, new WaterTempModifier().tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                    }
                    if (player.m_203117_()) {
                        Temperature.addOrReplaceModifier((LivingEntity)player, new FreezingTempModifier(), Temperature.Trait.BASE, Placement.Duplicates.BY_CLASS);
                    }
                    if (player.m_6060_() && Temperature.hasModifier((LivingEntity)player, Temperature.Trait.WORLD, WaterTempModifier.class)) {
                        player.m_252836_();
                        Temperature.removeModifiers((LivingEntity)player, Temperature.Trait.WORLD, WaterTempModifier.class);
                    }
                }
                if (player.m_203117_() && player.m_146888_() > 0) {
                    boolean hasIcePotion;
                    AtomicReference<Double> insulation = new AtomicReference<Double>(0.0);
                    boolean bl = hasIcePotion = player.m_21023_(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false;
                    if (!hasIcePotion) {
                        Temperature.getModifier((LivingEntity)player, Temperature.Trait.RATE, ArmorInsulationTempModifier.class).ifPresent(insulModifier -> insulation.updateAndGet(v -> v + insulModifier.getNBT().m_128459_("Hot") + insulModifier.getNBT().m_128459_("Cold")));
                    }
                    if (!hasIcePotion && !(insulation.get() > 0.0) && (double)player.f_19797_ % Math.max(1.0, 37.0 - insulation.get()) == 0.0) {
                        player.m_146917_(player.m_146888_() - 1);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onTridentUse(LivingEntityUseItemEvent.Stop event) {
            LivingEntity entity = event.getEntity();
            ItemStack stack = event.getItem();
            if (!entity.m_9236_().m_5776_()) {
                TaskScheduler.scheduleServer(() -> {
                    if (stack.m_41720_() instanceof TridentItem && EnchantmentHelper.m_44932_((ItemStack)stack) > 0 && !entity.m_20072_()) {
                        Temperature.removeModifiers(entity, Temperature.Trait.WORLD, WaterTempModifier.class);
                    }
                }, 5);
            }
        }

        @SubscribeEvent
        public static void tickInventoryAttributeChanges(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START && event.player.f_19797_ % 20 == 0) {
                for (ItemStack item : event.player.m_150109_().f_35974_) {
                    EntityTempManager.updateInventoryTempAttributes(item, item, (LivingEntity)event.player);
                }
            }
        }

        @SubscribeEvent
        public static void updateInventoryAttributesOnSlotChange(ContainerChangedEvent event) {
            AbstractContainerMenu abstractContainerMenu = event.getContainer();
            if (abstractContainerMenu instanceof InventoryMenu) {
                InventoryMenu inventory = (InventoryMenu)abstractContainerMenu;
                EntityTempManager.updateInventoryTempAttributes(event.getOldStack(), event.getNewStack(), (LivingEntity)EntityTempManager.getOwner(inventory));
            }
        }

        @SubscribeEvent
        public static void tickInsulationAttributeChanges(LivingEvent.LivingTickEvent event) {
            LivingEntity entity = event.getEntity();
            if (entity.f_19797_ % 20 == 0) {
                for (ItemStack armor : entity.m_6168_()) {
                    if (armor.m_41619_()) continue;
                    EntityTempManager.updateInsulationAttributeModifiers(entity, armor, armor, Insulation.Slot.ARMOR);
                }
            }
        }

        @SubscribeEvent
        public static void updateInsulationAttributesOnEquipmentChange(LivingEquipmentChangeEvent event) {
            EntityTempManager.updateInsulationAttributeModifiers(event.getEntity(), event.getFrom(), event.getTo(), Insulation.Slot.ARMOR);
            for (ItemStack armor : event.getEntity().m_6168_()) {
                if (armor.m_41619_()) continue;
                EntityTempManager.updateInsulationAttributeModifiers(event.getEntity(), armor, armor, Insulation.Slot.ARMOR);
            }
        }

        @SubscribeEvent
        public static void cancelFreezingDamage(LivingAttackEvent event) {
            if (event.getSource().equals(event.getEntity().m_9236_().m_269111_().m_269109_()) && event.getEntity().m_21023_(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get().booleanValue()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onInsulationAdded(MobEffectEvent.Added event) {
            LivingEntity entity = event.getEntity();
            MobEffectInstance effect = event.getEffectInstance();
            if (!entity.m_9236_().f_46443_ && EntityTempManager.isTemperatureEnabled((Entity)entity) && (effect.m_19544_() == ModEffects.FRIGIDNESS || effect.m_19544_() == ModEffects.WARMTH)) {
                boolean isWarmth = effect.m_19544_() == ModEffects.WARMTH;
                int strength = effect.m_19564_() + 1;
                ThermalSourceTempModifier newMod = (ThermalSourceTempModifier)(isWarmth ? new WarmthTempModifier(strength) : new FrigidnessTempModifier(strength)).expires(effect.m_19557_());
                ThermalSourceTempModifier oldMod = Temperature.getModifier(entity, Temperature.Trait.WORLD, ThermalSourceTempModifier.class).orElse(null);
                if (oldMod == null || oldMod.getStrength() <= strength) {
                    Temperature.removeModifiers(entity, Temperature.Trait.WORLD, newMod.getClass());
                    Temperature.addModifier(entity, newMod, Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                }
            }
        }

        @SubscribeEvent
        public static void onInsulationRemoved(MobEffectEvent.Remove event) {
            Optional<ThermalSourceTempModifier> modifier;
            LivingEntity entity = event.getEntity();
            MobEffectInstance effect = event.getEffectInstance();
            if (effect != null && !entity.m_9236_().f_46443_ && EntityTempManager.isTemperatureEnabled((Entity)entity) && (effect.m_19544_() == ModEffects.FRIGIDNESS || effect.m_19544_() == ModEffects.WARMTH) && (modifier = Temperature.getModifier(entity, Temperature.Trait.WORLD, ThermalSourceTempModifier.class)).isPresent()) {
                boolean isWarmth = effect.m_19544_() == ModEffects.WARMTH;
                CompoundTag nbt = modifier.get().getNBT();
                if (isWarmth) {
                    nbt.m_128405_("Warming", 0);
                } else {
                    nbt.m_128405_("Cooling", 0);
                }
                if (isWarmth ? !entity.m_21023_(ModEffects.FRIGIDNESS) : !entity.m_21023_(ModEffects.WARMTH)) {
                    Temperature.removeModifiers(entity, Temperature.Trait.WORLD, mod -> mod instanceof ThermalSourceTempModifier);
                }
            }
        }

        @SubscribeEvent
        public static void onSleep(SleepFinishedTimeEvent event) {
            if (!event.getLevel().m_5776_()) {
                event.getLevel().m_6907_().forEach(player -> {
                    if (player.m_5803_()) {
                        double temp = Temperature.get((LivingEntity)player, Temperature.Trait.CORE);
                        Temperature.set((LivingEntity)player, Temperature.Trait.CORE, temp / 4.0);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void playerRiding(TickEvent.PlayerTickEvent event) {
            Player player;
            if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().m_5776_() && event.player.f_19797_ % 5 == 0 && (player = event.player).m_20202_() != null) {
                Minecart minecart;
                Entity mount = player.m_20202_();
                if (mount instanceof Minecart && (minecart = (Minecart)mount).m_38178_().m_60734_() == ModBlocks.MINECART_INSULATION) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new MountTempModifier(1.0, 1.0).tickRate(5)).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                } else {
                    MountData entityInsul = ConfigSettings.INSULATED_MOUNTS.get().get((Object)mount.m_6095_()).stream().filter(mnt -> mnt.test(mount)).findFirst().orElse(null);
                    if (entityInsul != null) {
                        Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new MountTempModifier(entityInsul.coldInsulation(), entityInsul.heatInsulation()).tickRate(5)).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onEatFood(LivingEntityUseItemEvent.Finish event) {
            ItemStack item = event.getItem();
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!(item.m_41780_() != UseAnim.DRINK && item.m_41780_() != UseAnim.EAT || event.getEntity().m_9236_().f_46443_)) {
                    for (FoodData foodData : ConfigSettings.FOOD_TEMPERATURES.get().get((Object)item.m_41720_())) {
                        if (foodData == null || !foodData.test(item)) continue;
                        double temperature = foodData.temperature();
                        int duration = foodData.duration();
                        Temperature.Trait trait = foodData.duration() > 0 ? Temperature.Trait.BASE : Temperature.Trait.CORE;
                        FoodTempModifier foodModifier = item.m_41720_() == ModItems.SOUL_SPROUT ? new SoulSproutTempModifier(temperature) : new FoodTempModifier(temperature);
                        foodModifier.getNBT().m_128359_("item", ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).toString());
                        foodModifier.getNBT().m_128405_("duration", duration);
                        ((TempModifier)foodModifier.expires(duration)).tickRate(duration);
                        if (foodData.stackLimit() > 1 && Temperature.addModifier((LivingEntity)player, foodModifier, trait, Placement.Duplicates.EXACT, foodData.stackLimit(), Placement.AFTER_LAST)) continue;
                        Temperature.addOrReplaceModifier((LivingEntity)player, foodModifier, trait, Placement.Duplicates.EXACT);
                    }
                }
            }
        }
    }
}

