/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.jei.category;

import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.compat.jei.JeiPlugin;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.gui.elements.DrawableResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;

public abstract class ColdSweatFuelCategory
implements IRecipeCategory<JeiPlugin.FuelRecipe> {
    private final IDrawable icon;
    private final int width = this.getMaxWidth();
    private final int height;

    public ColdSweatFuelCategory(IGuiHelper guiHelper, ItemStack icon) {
        this.icon = guiHelper.createDrawableItemStack(icon);
        this.height = 34;
    }

    public abstract RecipeType<JeiPlugin.FuelRecipe> getRecipeType();

    public abstract Component getTitle();

    protected abstract HearthBlockEntity getDummyBlockEntity();

    protected abstract ResourceLocation getEmptyGaugeTexture(JeiPlugin.FuelRecipe var1);

    protected abstract ResourceLocation getFilledGaugeTexture(JeiPlugin.FuelRecipe var1);

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected int getMaxWidth() {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        HearthBlockEntity dummyBlockEntity = this.getDummyBlockEntity();
        Component maxSmeltCountText = ColdSweatFuelCategory.createFillAmountText(dummyBlockEntity.getMaxFuel(), dummyBlockEntity);
        int maxStringWidth = fontRenderer.m_92895_(maxSmeltCountText.getString());
        int textPadding = 20;
        return 18 + textPadding + maxStringWidth;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JeiPlugin.FuelRecipe recipe, IFocusGroup focuses) {
        builder.addInputSlot(1, 17).setStandardSlotBackground().addItemStacks(List.of(recipe.input()));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, JeiPlugin.FuelRecipe recipe, IFocusGroup focuses) {
        HearthBlockEntity dummyBlockEntity = this.getDummyBlockEntity();
        double fuel = Math.abs(recipe.fuelData().fuel());
        Component fillAmountText = ColdSweatFuelCategory.createFillAmountText(fuel, dummyBlockEntity);
        ((ITextWidget)builder.addText((FormattedText)fillAmountText, this.getWidth() - 20, this.getHeight()).setPosition(20, 0)).setTextAlignment(HorizontalAlignment.CENTER).setTextAlignment(VerticalAlignment.CENTER).setColor(-8355712);
        int gaugeHeight = fuel <= 0.0 ? 0 : (int)Math.round(CSMath.blend(2.0, 14.0, fuel, 0.0, (double)dummyBlockEntity.getMaxFuel()));
        int maxGaugeHeight = 14;
        DrawableResource fuelGauge = new DrawableResource(this.getFilledGaugeTexture(recipe), 0, 14 - gaugeHeight, 14, gaugeHeight, 0, 0, 0, 0, 14, 14);
        DrawableResource emptyFuelGauge = new DrawableResource(this.getEmptyGaugeTexture(recipe), 0, 0, 14, 14, 0, 0, 0, 0, 14, 14);
        builder.addDrawable((IDrawable)emptyFuelGauge, 2, 0);
        builder.addDrawable((IDrawable)fuelGauge, 2, 0 + (maxGaugeHeight - gaugeHeight));
    }

    private static Component createFillAmountText(double fuelAmount, HearthBlockEntity dummyBlockEntity) {
        int fuelInterval = dummyBlockEntity.getFuelDrainInterval();
        int durationTicks = (int)Math.round(fuelAmount * (double)fuelInterval);
        return Component.m_237110_((String)"jei.cold_sweat.fuel_duration", (Object[])new Object[]{StringUtil.m_14404_((int)durationTicks)});
    }
}

