/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionTempData
extends ConfigData {
    final NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions;
    final double min;
    final double max;
    final Temperature.Units units;
    final boolean isOffset;
    public static final Codec<DimensionTempData> CODEC = DimensionTempData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrHolderCodec(Registries.f_256787_)).fieldOf("dimensions").forGetter(DimensionTempData::dimensions), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.fieldOf("temperature"), (MapCodec)Codec.DOUBLE.fieldOf("min_temp")).xmap(either -> (Double)either.map(left -> left, right -> right), Either::right).forGetter(DimensionTempData::min), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.fieldOf("temperature"), (MapCodec)Codec.DOUBLE.fieldOf("max_temp")).xmap(either -> (Double)either.map(left -> left, right -> right), Either::right).forGetter(DimensionTempData::max), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(DimensionTempData::units), (App)Codec.BOOL.optionalFieldOf("is_offset", (Object)false).forGetter(DimensionTempData::isOffset)).apply((Applicative)instance, DimensionTempData::new)));

    public DimensionTempData(NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions, double min, double max, Temperature.Units units, boolean isOffset, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.dimensions = dimensions;
        this.min = min;
        this.max = max;
        this.units = units;
        this.isOffset = isOffset;
    }

    public DimensionTempData(NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions, double min, double max, Temperature.Units units, boolean isOffset) {
        this(dimensions, min, max, units, isOffset, new NegatableList<String>());
    }

    public DimensionTempData(Holder<DimensionType> dimension, double min, double max, Temperature.Units units, boolean isOffset) {
        this(new NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>>(Either.right(OptionalHolder.ofHolder(dimension))), min, max, units, isOffset);
    }

    public NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions() {
        return this.dimensions;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public double getMinTemp() {
        return Temperature.convert(this.min, this.units, Temperature.Units.MC, !this.isOffset);
    }

    public double getMaxTemp() {
        return Temperature.convert(this.max, this.units, Temperature.Units.MC, !this.isOffset);
    }

    @Nullable
    public static DimensionTempData fromToml(List<?> entry, boolean isOffset, RegistryAccess registryAccess) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing dimension config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions = ConfigHelper.parseRegistryItems(Registries.f_256787_, registryAccess, (String)entry.get(0));
        if (dimensions.isEmpty()) {
            return null;
        }
        double temp = ((Number)entry.get(1)).doubleValue();
        Temperature.Units units = entry.size() == 3 ? Temperature.Units.valueOf(((String)entry.get(2)).toUpperCase()) : Temperature.Units.MC;
        return new DimensionTempData(dimensions, temp, temp, units, isOffset);
    }

    public Codec<DimensionTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionTempData that = (DimensionTempData)obj;
        return super.equals(obj) && Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0 && this.isOffset == that.isOffset && this.dimensions.equals(that.dimensions) && this.units == that.units;
    }
}

