/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.item.ThermometerItem;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemFrameRenderer.class})
public class MixinItemFrameLabel {
    private static ItemStack ITEM = ItemStack.f_41583_;
    private static ItemFrame ENTITY = null;

    @Inject(method={"renderNameTag(Lnet/minecraft/world/entity/decoration/ItemFrame;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void storeItemStack(ItemFrame itemFrame, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        ITEM = itemFrame.m_31822_();
        ENTITY = itemFrame;
    }

    @ModifyArg(method={"renderNameTag(Lnet/minecraft/world/entity/decoration/ItemFrame;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderer;renderNameTag(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"))
    private Component modifyItemFrameLabel(Component original) {
        if (ITEM.m_41720_() instanceof ThermometerItem && Minecraft.m_91087_().f_91073_ != null && ENTITY != null) {
            double minTemp = ConfigSettings.MIN_TEMP.get();
            double maxTemp = ConfigSettings.MAX_TEMP.get();
            double worldTemp = WorldHelper.getTemperatureAt((Level)Minecraft.m_91087_().f_91073_, ENTITY.m_20183_());
            boolean celsius = ConfigSettings.CELSIUS.get();
            Style tempColor = Style.f_131099_.m_178520_(Overlays.getWorldTempColor(worldTemp, minTemp, maxTemp));
            int convertedTemp = (int)Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true) + ConfigSettings.TEMP_OFFSET.get();
            return Component.m_237113_((String)(convertedTemp + " " + (celsius ? Temperature.Units.C.getFormattedName() : Temperature.Units.F.getFormattedName()))).m_130948_(tempColor);
        }
        return original;
    }

    @Redirect(method={"shouldShowName(Lnet/minecraft/world/entity/decoration/ItemFrame;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hasCustomHoverName()Z"))
    private boolean alwaysShowThermometerName(ItemStack instance) {
        if (instance.m_41720_() instanceof ThermometerItem) {
            return true;
        }
        return instance.m_41788_();
    }
}

