/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.world;

import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class SpreadPath {
    public final Direction direction;
    public final BlockPos pos;
    public final int x;
    public final int y;
    public final int z;
    public boolean frozen = false;
    public BlockPos origin;

    public SpreadPath(BlockPos pos, Direction direction) {
        this.direction = direction;
        this.pos = pos;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
    }

    public SpreadPath(BlockPos pos) {
        this(pos, Direction.UP);
    }

    public SpreadPath(int x, int y, int z, Direction direction) {
        this.direction = direction;
        this.pos = new BlockPos(x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SpreadPath setOrigin(BlockPos origin) {
        this.origin = origin;
        return this;
    }

    public SpreadPath offset(int x, int y, int z) {
        return new SpreadPath(this.x + x, this.y + y, this.z + z, this.direction);
    }

    public SpreadPath offset(Direction dir) {
        return this.offset(dir, 1);
    }

    public SpreadPath offset(Direction dir, int steps) {
        return this.offset(dir.m_122429_() * steps, dir.m_122430_() * steps, dir.m_122431_() * steps);
    }

    public SpreadPath offset(BlockPos pos) {
        return this.offset(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public SpreadPath spreadTo(BlockPos pos) {
        return this.spreadTo(pos, CSMath.getDirectionFrom(this.pos, pos));
    }

    public SpreadPath spreadTo(Direction dir) {
        return this.spreadTo(this.pos.m_121945_(dir), dir);
    }

    public SpreadPath spreadTo(BlockPos pos, Direction dir) {
        SpreadPath path = new SpreadPath(pos, dir);
        path.setOrigin(this.origin);
        return path;
    }

    public boolean withinDistance(Vec3i vector, double distance) {
        return this.distanceSq(vector.m_123341_(), vector.m_123342_(), vector.m_123343_()) < distance * distance;
    }

    public double distanceSq(double x, double y, double z) {
        double d1 = (double)this.x - x;
        double d2 = (double)this.y - y;
        double d3 = (double)this.z - z;
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public boolean equals(Object o) {
        return o instanceof SpreadPath && this.pos.equals((Object)((SpreadPath)o).pos);
    }
}

