/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.entity;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DecreaseDropsEffect
extends TempEffect {
    public DecreaseDropsEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onDropItems(LivingDropsEvent event) {
        if (!this.test(event.getEntity())) {
            return;
        }
        Collection drops = event.getDrops();
        int totalCount = drops.stream().map(item -> item.m_32055_().m_41613_()).reduce(0, Integer::sum);
        int removedDrops = CSMath.ceil(CSMath.blend(0.0, (double)totalCount, this.getTemperature(), (double)this.bounds().min(), (double)this.bounds().max()));
        while (removedDrops > 0 && !drops.isEmpty()) {
            int index = (int)(Math.random() * (double)drops.size());
            ItemEntity drop = drops.stream().skip(index).findFirst().orElse(null);
            if (drop == null) continue;
            int count = drop.m_32055_().m_41613_();
            if (count <= removedDrops) {
                removedDrops -= count;
                drops.remove(drop);
                continue;
            }
            drop.m_32055_().m_41764_(count - removedDrops);
            removedDrops = 0;
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.SERVER;
    }
}

