/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class SoulStalkBlock
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final EnumProperty<Section> SECTION = EnumProperty.m_61587_((String)"section", Section.class);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape SHAPE_BUD = Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)14.0, (double)11.5);
    public static final int MAX_HEIGHT = 6;
    public static final DispenseItemBehavior GROWABLE_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Position position;
            BlockPos pos;
            ServerLevel level = source.m_7727_();
            BlockState state = level.m_8055_(pos = new BlockPos(position = DispenserBlock.m_52720_((BlockSource)source)));
            if (state.m_60713_(ModBlocks.SOUL_STALK)) {
                stack.m_41774_(1);
                SoulStalkBlock.applyGrowingItem((Level)level, pos);
                return stack;
            }
            return super.m_7498_(source, stack);
        }
    };

    public SoulStalkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(SECTION, (Comparable)((Object)Section.BUD)));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(SoundType.f_154670_).m_60913_(0.0f, 0.5f).m_60977_().m_60953_(state -> ((Section)((Object)((Object)state.m_61143_(SECTION)))).hasFruit() ? 4 : 0).m_60955_().m_60910_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT);
    }

    @SubscribeEvent
    public static void registerDispenserBehaviors(ServerStartedEvent event) {
        for (Item item : ForgeRegistries.ITEMS.tags().getTag(ModItemTags.GROWS_SOUL_STALK)) {
            DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)GROWABLE_DISPENSE_BEHAVIOR);
        }
    }

    public static Section getRandomMidsection() {
        return Math.random() < 0.5 ? Section.MIDDLE_SPROUT : Section.MIDDLE;
    }

    public static int getRandomGrowth() {
        return new Random().nextInt(1, 4);
    }

    protected void ensureProperState(LevelAccessor level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (aboveState.m_60713_((Block)this)) {
            if (belowState.m_60713_((Block)this)) {
                this.ensureSectionAt(level, pos, SoulStalkBlock.getRandomMidsection());
            } else {
                this.ensureSectionAt(level, pos, Section.BASE);
            }
        } else if (belowState.m_60713_((Block)this)) {
            this.ensureSectionAt(level, pos, Section.TOP);
        } else {
            this.ensureSectionAt(level, pos, Section.BUD);
        }
    }

    private void ensureSectionAt(LevelAccessor level, BlockPos pos, Section section) {
        BlockState oldState = level.m_8055_(pos);
        if (!oldState.m_60713_((Block)this)) {
            return;
        }
        Section oldSection = (Section)((Object)oldState.m_61143_(SECTION));
        if (section.isMiddle() ? !oldSection.isMiddle() : oldSection != section) {
            level.m_7731_(pos, (BlockState)oldState.m_61124_(SECTION, (Comparable)((Object)section)), 3);
        }
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (level.m_46859_(pos.m_7494_())) {
            int baseY;
            int topY = SoulStalkBlock.getTopY((Level)level, pos);
            if (topY - (baseY = SoulStalkBlock.getBaseY((Level)level, pos)) + 1 >= 6) {
                return;
            }
            double minTemp = ConfigSettings.MIN_TEMP.get();
            double maxTemp = ConfigSettings.MAX_TEMP.get();
            double tempAtBase = WorldHelper.getRoughTemperatureAt((Level)level, pos.m_175288_(baseY));
            if (rand.nextDouble() < 0.05 + CSMath.blend(0.0, 0.95, tempAtBase, minTemp, maxTemp) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                SoulStalkBlock.grow((Level)level, pos, 1);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack holding = player.m_21120_(hand);
        if (!level.f_46443_ && holding.m_204117_(ModItemTags.GROWS_SOUL_STALK)) {
            if (SoulStalkBlock.getHeight(level, pos) >= 6) {
                return super.m_6227_(state, level, pos, player, hand, rayTraceResult);
            }
            boolean grew = SoulStalkBlock.applyGrowingItem(level, pos);
            if (!player.m_150110_().f_35937_) {
                holding.m_41774_(1);
            }
            Vec3 centerPos = CSMath.getCenterPos(pos);
            player.m_21011_(hand, true);
            if (grew) {
                WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.f_123746_, centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_, 0.75, 0.75, 0.75, 5.0, 0.01);
                level.m_5594_(null, pos, SoundEvents.f_12456_, SoundSource.BLOCKS, 1.0f, 0.8f);
            } else {
                level.m_5594_(null, pos, SoundEvents.f_12137_, SoundSource.BLOCKS, 0.6f, 1.5f);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, rayTraceResult);
    }

    public static boolean applyGrowingItem(Level level, BlockPos pos) {
        int baseY;
        int topY = SoulStalkBlock.getTopY(level, pos);
        if (topY - (baseY = SoulStalkBlock.getBaseY(level, pos)) + 1 >= 6) {
            return false;
        }
        return SoulStalkBlock.grow(level, pos.m_175288_(topY), SoulStalkBlock.getRandomGrowth());
    }

    public static boolean grow(Level level, BlockPos pos, int growth) {
        BlockState state = level.m_8055_(pos);
        BlockState defaultState = state.m_60734_().m_49966_();
        int age = (Integer)state.m_61143_((Property)AGE) + growth;
        Section section = (Section)((Object)state.m_61143_(SECTION));
        if (age >= 4) {
            if (section == Section.TOP) {
                level.m_46597_(pos, (BlockState)((BlockState)defaultState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())));
                level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)defaultState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(SECTION, (Comparable)((Object)Section.TOP)));
            } else if (section == Section.BUD) {
                level.m_46597_(pos, (BlockState)((BlockState)defaultState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(SECTION, (Comparable)((Object)Section.BASE)));
                level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)defaultState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(SECTION, (Comparable)((Object)Section.TOP)));
            }
            return true;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
        return false;
    }

    public static int getHeight(Level level, BlockPos pos) {
        return SoulStalkBlock.getTopY(level, pos) - SoulStalkBlock.getBaseY(level, pos) + 1;
    }

    public static int getTopY(Level level, BlockPos pos) {
        int aboveHeight = 1;
        while (level.m_8055_(pos.m_6630_(aboveHeight)).m_60713_(ModBlocks.SOUL_STALK)) {
            ++aboveHeight;
        }
        return pos.m_123342_() + aboveHeight - 1;
    }

    public static int getBaseY(Level level, BlockPos pos) {
        int belowHeight = 1;
        while (level.m_8055_(pos.m_6625_(belowHeight)).m_60713_(ModBlocks.SOUL_STALK)) {
            ++belowHeight;
        }
        return pos.m_123342_() - belowHeight + 1;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        return context.m_43725_().m_8055_(pos.m_7495_()).m_60734_() == this ? (BlockState)this.m_49966_().m_61124_(SECTION, (Comparable)((Object)Section.TOP)) : (this.m_7898_(this.m_49966_(), (LevelReader)context.m_43725_(), pos) ? this.m_49966_() : null);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (level.m_5776_()) {
            return state;
        }
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction == Direction.UP) {
            boolean isUnderSelf = otherState.m_60734_() == this;
            Section section = (Section)((Object)state.m_61143_(SECTION));
            switch (section) {
                case TOP: {
                    return isUnderSelf ? (BlockState)state.m_61124_(SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())) : state;
                }
                case BUD: {
                    return isUnderSelf ? (BlockState)state.m_61124_(SECTION, (Comparable)((Object)Section.BASE)) : state;
                }
            }
            if (!isUnderSelf) {
                return Blocks.f_50016_.m_49966_();
            }
        }
        this.ensureProperState(level, pos);
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return state.m_61143_(SECTION) == Section.BUD ? SHAPE_BUD : SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, SECTION});
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        return this.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        return below.m_204336_(ModBlockTags.SOUL_STALK_PLACEABLE_ON) || below.m_60734_() == this;
    }

    public static enum Section implements StringRepresentable
    {
        BASE("base"),
        MIDDLE("middle"),
        MIDDLE_SPROUT("middle_sprout"),
        TOP("top"),
        BUD("bud");

        private final String name;

        private Section(String name) {
            this.name = name;
        }

        public boolean hasFruit() {
            return this == TOP || this == MIDDLE_SPROUT || this == BUD;
        }

        public boolean isMiddle() {
            return this == MIDDLE || this == MIDDLE_SPROUT;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

