/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.fluid;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public class ModFluidAttributes
extends FluidAttributes {
    private final BlockColor colorGetter;
    private final Supplier<SoundEvent> fillSound;
    private final Supplier<SoundEvent> emptySound;

    public ModFluidAttributes(CustomBuilder builder, Fluid fluid) {
        super((FluidAttributes.Builder)builder, fluid);
        this.colorGetter = builder.colorGetter;
        this.fillSound = builder.fillSound;
        this.emptySound = builder.emptySound;
    }

    public int getColor(BlockAndTintGetter level, BlockPos pos) {
        return this.colorGetter.getColor(level.m_8055_(pos), level, pos, 0);
    }

    public SoundEvent getEmptySound() {
        return this.emptySound != null ? this.emptySound.get() : super.getEmptySound();
    }

    public SoundEvent getFillSound() {
        return this.fillSound != null ? this.fillSound.get() : super.getFillSound();
    }

    public static CustomBuilder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return new CustomBuilder(stillTexture, flowingTexture, ModFluidAttributes::new);
    }

    public static class CustomBuilder
    extends FluidAttributes.Builder {
        private BlockColor colorGetter = (state, level, pos, index) -> -1;
        private Supplier<SoundEvent> fillSound;
        private Supplier<SoundEvent> emptySound;

        protected CustomBuilder(ResourceLocation stillTexture, ResourceLocation flowingTexture, BiFunction<CustomBuilder, Fluid, ModFluidAttributes> factory) {
            super(stillTexture, flowingTexture, (builder, fluid) -> {
                if (builder instanceof CustomBuilder) {
                    CustomBuilder customBuilder = (CustomBuilder)((Object)builder);
                    return (FluidAttributes)factory.apply(customBuilder, (Fluid)fluid);
                }
                return null;
            });
        }

        public CustomBuilder color(BlockColor colorGetter) {
            this.colorGetter = colorGetter;
            return this;
        }

        public CustomBuilder sound(Supplier<SoundEvent> fillSound, Supplier<SoundEvent> emptySound) {
            this.fillSound = fillSound;
            this.emptySound = emptySound;
            return this;
        }
    }

    public static interface BlockColor {
        public int getColor(BlockState var1, @Nullable BlockAndTintGetter var2, @Nullable BlockPos var3, int var4);

        @OnlyIn(value=Dist.CLIENT)
        default public net.minecraft.client.color.block.BlockColor toMinecraft() {
            return new net.minecraft.client.color.block.BlockColor(){

                public int m_92566_(BlockState state, BlockAndTintGetter level, BlockPos pos, int tintIndex) {
                    return this.m_92566_(state, level, pos, tintIndex);
                }
            };
        }
    }
}

