/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.fluid;

import com.momosoftworks.coldsweat.common.fluid.ModFluidAttributes;
import com.momosoftworks.coldsweat.core.init.BlockInit;
import com.momosoftworks.coldsweat.core.init.FluidInit;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.core.init.SoundInit;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class SlushFluid
extends ForgeFlowingFluid {
    private static final ResourceLocation SLUSH_STILL = new ResourceLocation("cold_sweat", "block/slush_still");
    private static final ResourceLocation SLUSH_FLOW = new ResourceLocation("cold_sweat", "block/slush_flow");

    protected SlushFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static BlockBehaviour.Properties getBlockProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60977_().m_60978_(100.0f);
    }

    public static ForgeFlowingFluid.Properties getForgeProperties() {
        return new ForgeFlowingFluid.Properties(FluidInit.SLUSH, FluidInit.FLOWING_SLUSH, ModFluidAttributes.builder(SLUSH_STILL, SLUSH_FLOW).color((state, level, pos, index) -> {
            if (level == null || pos == null) {
                return -1;
            }
            int color = BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos);
            int red = FastColor.ARGB32.m_13665_((int)color);
            int green = FastColor.ARGB32.m_13667_((int)color);
            int blue = FastColor.ARGB32.m_13669_((int)color);
            int alphaColor = FastColor.ARGB32.m_13660_((int)240, (int)red, (int)green, (int)blue);
            int white = FastColor.ARGB32.m_13660_((int)240, (int)255, (int)255, (int)255);
            return CSMath.blendColors(alphaColor, white, 0.65f);
        }).sound((Supplier<SoundEvent>)SoundInit.BUCKET_FILL_SLUSH, (Supplier<SoundEvent>)SoundInit.BUCKET_EMPTY_SLUSH).translationKey("block.cold_sweat.slush").temperature(280).viscosity(2000)).bucket(ItemInit.SLUSH_BUCKET).block(BlockInit.SLUSH);
    }

    protected boolean m_6760_() {
        return false;
    }

    protected int m_6719_(LevelReader worldIn) {
        return 2;
    }

    protected int m_6713_(LevelReader worldIn) {
        return 2;
    }

    public int m_6718_(LevelReader level) {
        return 30;
    }

    protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        FluidState targetFluidState = level.m_6425_(pos);
        if (targetFluidState.m_205070_(FluidTags.f_13131_)) {
            BlockState resultBlock = Blocks.f_50127_.m_49966_();
            if (blockState.m_60734_() instanceof LiquidBlock) {
                level.m_7731_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (BlockState)resultBlock), 3);
            }
            SlushFluid.fizz(level, pos);
            return;
        }
        super.m_6364_(level, pos, blockState, direction, fluidState);
    }

    public static void fizz(LevelAccessor ilevel, BlockPos pos) {
        if (ilevel instanceof Level) {
            Level level = (Level)ilevel;
            Vec3 centerPos = CSMath.getCenterPos(pos);
            BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50127_.m_49966_());
            WorldHelper.spawnParticleBatch(level, (ParticleOptions)particleData, centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_, 0.6, 0.6, 0.6, 15.0, 0.1);
            level.m_5594_(null, pos, SoundEvents.f_12474_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static class Source
    extends SlushFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends SlushFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

