/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.init.FetchSeasonsModsEvent;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.item.ThermometerItem;
import com.momosoftworks.coldsweat.compat.create.ColdSweatDisplayBehaviors;
import com.momosoftworks.coldsweat.compat.curios.EquipableCurio;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.BlockInit;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.tag.ModInsulatorTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.infrastructure.ponder.AllPonderTags;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.content.purity.ContainerWithPurity;
import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import sereneseasons.season.SeasonHooks;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.capability.CurioItemCapability;
import top.theillusivec4.curios.common.capability.ItemizedCurioCapability;
import weather2.ServerTickHandler;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;

@Mod.EventBusSubscriber
public class CompatManager {
    private static final boolean BOP_LOADED = CompatManager.modLoaded("biomesoplenty");
    private static final boolean SERENE_SEASONS_LOADED = CompatManager.modLoaded("sereneseasons");
    private static final boolean CURIOS_LOADED = CompatManager.modLoaded("curios");
    private static final boolean SPIRIT_LOADED = CompatManager.modLoaded("spirit");
    private static final boolean BYG_LOADED = CompatManager.modLoaded("byg");
    private static final boolean CREATE_LOADED = CompatManager.modLoaded("create", "0.5.1");
    private static final boolean ATMOSPHERIC_LOADED = CompatManager.modLoaded("atmospheric");
    private static final boolean ENVIRONMENTAL_LOADED = CompatManager.modLoaded("environmental");
    private static final boolean TERRALITH_LOADED = CompatManager.modLoaded("terralith");
    private static final boolean WEATHER_LOADED = CompatManager.modLoaded("weather2");
    private static final boolean WYTHERS_LOADED = CompatManager.modLoaded("wwoo");
    private static final boolean TOOLTIPS_LOADED = CompatManager.modLoaded("legendarytooltips");
    private static final boolean PRIMAL_WINTER_LOADED = CompatManager.modLoaded("primalwinter");
    private static final boolean THIRST_LOADED = CompatManager.modLoaded("thirst", "1.18.2-1.3.11");
    private static final boolean ICEBERG_LOADED = CompatManager.modLoaded("iceberg");
    private static final boolean SPOILED_LOADED = CompatManager.modLoaded("spoiled");
    private static final boolean SUPPLEMENTARIES_LOADED = CompatManager.modLoaded("supplementaries");
    private static final boolean VALKYRIEN_SKIES_LOADED = CompatManager.modLoaded("valkyrienskies");
    private static final boolean TOUGH_AS_NAILS_LOADED = CompatManager.modLoaded("toughasnails");
    private static final boolean TWILIGHT_FOREST_LOADED = CompatManager.modLoaded("twilightforest");
    private static final boolean AETHER_LOADED = CompatManager.modLoaded("aether");
    private static final boolean REGIONS_UNEXPLORED_LOADED = CompatManager.modLoaded("regions_unexplored");
    private static final List<String> SEASONS_MODS = new ArrayList<String>();
    public static boolean USING_BACKTANK = false;

    public static boolean modLoaded(String modID, String minVersion, String maxVersion) {
        List<String> disabledMods = ConfigSettings.DISABLED_MOD_COMPAT.get();
        if (disabledMods.contains(modID)) {
            return false;
        }
        ModFileInfo mod = FMLLoader.getLoadingModList().getModFileById(modID);
        if (mod == null) {
            return false;
        }
        ArtifactVersion version = ((IModInfo)mod.getMods().get(0)).getVersion();
        if (!minVersion.isEmpty() && version.compareTo((Object)new DefaultArtifactVersion(minVersion)) < 0) {
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or higher for compat to be enabled! (found {})", (Object)modID, (Object)minVersion, (Object)version);
            return false;
        }
        if (!maxVersion.isEmpty() && version.compareTo((Object)new DefaultArtifactVersion(maxVersion)) > 0) {
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or lower for compat to be enabled! (found {})", (Object)modID, (Object)maxVersion, (Object)version);
            return false;
        }
        return true;
    }

    public static boolean modLoaded(String modID, String minVersion) {
        return CompatManager.modLoaded(modID, minVersion, "");
    }

    public static boolean modLoaded(String modID) {
        return CompatManager.modLoaded(modID, "");
    }

    private static List<String> fetchSeasonsMods() {
        if (SEASONS_MODS.isEmpty()) {
            FetchSeasonsModsEvent event = new FetchSeasonsModsEvent();
            if (SERENE_SEASONS_LOADED) {
                event.addSeasonsMod("sereneseasons");
            }
            MinecraftForge.EVENT_BUS.post((Event)event);
            SEASONS_MODS.addAll(event.getSeasonsMods());
        }
        return SEASONS_MODS;
    }

    public static List<String> getSeasonsMods() {
        return CompatManager.fetchSeasonsMods();
    }

    public static boolean isBiomesOPlentyLoaded() {
        return BOP_LOADED;
    }

    public static boolean isSereneSeasonsLoaded() {
        return SERENE_SEASONS_LOADED;
    }

    public static boolean isCuriosLoaded() {
        return CURIOS_LOADED;
    }

    public static boolean isSpiritLoaded() {
        return SPIRIT_LOADED;
    }

    public static boolean isBiomesYoullGoLoaded() {
        return BYG_LOADED;
    }

    public static boolean isCreateLoaded() {
        return CREATE_LOADED;
    }

    public static boolean isAtmosphericLoaded() {
        return ATMOSPHERIC_LOADED;
    }

    public static boolean isEnvironmentalLoaded() {
        return ENVIRONMENTAL_LOADED;
    }

    public static boolean isTerralithLoaded() {
        return TERRALITH_LOADED;
    }

    public static boolean isWeather2Loaded() {
        return WEATHER_LOADED;
    }

    public static boolean isWythersLoaded() {
        return WYTHERS_LOADED;
    }

    public static boolean isLegendaryTooltipsLoaded() {
        return TOOLTIPS_LOADED;
    }

    public static boolean isPrimalWinterLoaded() {
        return PRIMAL_WINTER_LOADED;
    }

    public static boolean isThirstLoaded() {
        return THIRST_LOADED;
    }

    public static boolean isIcebergLoaded() {
        return ICEBERG_LOADED;
    }

    public static boolean isSpoiledLoaded() {
        return SPOILED_LOADED;
    }

    public static boolean isSupplementariesLoaded() {
        return SUPPLEMENTARIES_LOADED;
    }

    public static boolean isValkyrienSkiesLoaded() {
        return VALKYRIEN_SKIES_LOADED;
    }

    public static boolean isToughAsNailsLoaded() {
        return TOUGH_AS_NAILS_LOADED;
    }

    public static boolean isTwilightForestLoaded() {
        return TWILIGHT_FOREST_LOADED;
    }

    public static boolean isAetherLoaded() {
        return AETHER_LOADED;
    }

    public static boolean isRegionsUnexploredLoaded() {
        return REGIONS_UNEXPLORED_LOADED;
    }

    public static void registerEventHandlers() {
        if (CURIOS_LOADED) {
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onCurioChange(CurioChangeEvent event) {
                    EntityTempManager.updateInsulationAttributeModifiers(event.getEntityLiving(), event.getFrom(), event.getTo(), Insulation.Slot.CURIO);
                }
            });
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void registerEquipableCurios(AttachCapabilitiesEvent<ItemStack> event) {
                    ItemStack item = (ItemStack)event.getObject();
                    if (!(item.m_41720_() instanceof ThermometerItem)) {
                        return;
                    }
                    EquipableCurio itemCurio = new EquipableCurio();
                    ItemizedCurioCapability itemizedCapability = new ItemizedCurioCapability((ICurioItem)itemCurio, item);
                    event.addCapability(CuriosCapability.ID_ITEM, CurioItemCapability.createProvider((ICurio)itemizedCapability));
                }
            });
        }
    }

    @SubscribeEvent
    public static void drainCreateBacktank(TickEvent.PlayerTickEvent event) {
        double maxTemp;
        double minTemp;
        Player player = event.player;
        if (!CompatManager.isCreateLoaded()) {
            return;
        }
        double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
        if (CSMath.betweenExclusive(worldTemp, minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT), maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT))) {
            return;
        }
        if (worldTemp < minTemp && !ConfigSettings.COLD_DRAINS_BACKTANK.get().booleanValue()) {
            return;
        }
        if (worldTemp > maxTemp && !ConfigSettings.HEAT_DRAINS_BACKTANK.get().booleanValue()) {
            return;
        }
        ItemStack backTank = player.m_6844_(EquipmentSlot.CHEST);
        if (USING_BACKTANK && player.f_19853_.f_46443_) {
            player.getPersistentData().m_128405_("VisualBacktankAir", Math.round(BacktankUtil.getAir((ItemStack)backTank)) - 1);
        }
        if (player.f_19797_ % 20 != 0 || event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!player.m_7500_() && !player.m_20077_() && backTank.m_41720_() instanceof BacktankItem) {
            List<InsulatorData> drainingInsulators = ConfigHelper.getTaggedConfigsFor(backTank.m_41720_(), ModInsulatorTags.DRAINS_BACKTANK, ConfigSettings.INSULATING_ARMORS.get(), player.f_19853_.m_5962_());
            if (drainingInsulators.stream().noneMatch(insulator -> insulator.test((Entity)player, backTank))) {
                return;
            }
            if (player.f_19853_.f_46443_) {
                USING_BACKTANK = true;
            }
            if (CSMath.getIfNotNull(backTank.m_41783_(), tag -> tag.m_128451_("Air"), 0) > 0) {
                BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)backTank, (float)1.0f);
                if (player.f_19853_.f_46443_) {
                    player.getPersistentData().m_128405_("VisualBacktankAir", Math.round(BacktankUtil.getAir((ItemStack)backTank)) - 1);
                }
            }
        } else if (player.f_19853_.f_46443_) {
            USING_BACKTANK = false;
        }
    }

    @Mod.EventBusSubscriber(modid="cold_sweat", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void addThirstDrinks(FMLCommonSetupEvent event) {
            if (CompatManager.isThirstLoaded()) {
                ThirstHelper.addDrink((Item)ModItems.FILLED_WATERSKIN, (int)6, (int)12);
                WaterPurity.addContainer((ContainerWithPurity)new ContainerWithPurity(ModItems.WATERSKIN.m_7968_(), ModItems.FILLED_WATERSKIN.m_7968_()));
            }
            if (CompatManager.isCreateLoaded()) {
                new Object(){

                    public void registerDisplayBehaviors() {
                        ColdSweatDisplayBehaviors.THERMOLITH = AllDisplayBehaviours.register((ResourceLocation)new ResourceLocation("cold_sweat", "thermolith"), (DisplayBehaviour)new ColdSweatDisplayBehaviors.Thermolith());
                        AllDisplayBehaviours.assignBlock((DisplayBehaviour)ColdSweatDisplayBehaviors.THERMOLITH, (Block)ModBlocks.THERMOLITH);
                    }
                }.registerDisplayBehaviors();
            }
        }

        @SubscribeEvent
        public static void setupModClientEvents(FMLClientSetupEvent event) {
            if (CompatManager.isCreateLoaded()) {
                new Object(){

                    public void registerPonderTags() {
                        PonderRegistry.TAGS.forTag(AllPonderTags.DISPLAY_SOURCES).add((ItemLike)BlockInit.THERMOLITH.get());
                    }
                }.registerPonderTags();
            }
        }
    }

    public static abstract class Valkyrien {
        public static Vec3 translateToShipCoords(Vec3 pos, Ship ship) {
            if (ship != null) {
                Vector3d posVec = VectorConversionsMCKt.toJOML((Vec3)pos);
                ship.getWorldToShip().transformPosition(posVec);
                return VectorConversionsMCKt.toMinecraft((Vector3dc)posVec);
            }
            return pos;
        }

        public static AABB transformIfShipPos(Level level, AABB aabb) {
            AtomicReference<AABB> translated = new AtomicReference<AABB>(aabb);
            VSGameUtilsKt.transformFromWorldToNearbyShipsAndWorld((Level)level, (AABB)aabb, translated::set);
            return translated.get();
        }

        public static BlockPos transformIfShipPos(Level level, BlockPos pos) {
            if (VALKYRIEN_SKIES_LOADED) {
                List shipTransforms = VSGameUtilsKt.transformToNearbyShipsAndWorld((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)1.0);
                if (shipTransforms.isEmpty()) {
                    return pos;
                }
                Vector3d shipCoords = (Vector3d)shipTransforms.get(0);
                return new BlockPos(VectorConversionsMCKt.toMinecraft((Vector3dc)shipCoords));
            }
            return pos;
        }
    }

    public static abstract class Thirst {
        public static boolean hasPurity(ItemStack stack) {
            if (THIRST_LOADED) {
                return WaterPurity.hasPurity((ItemStack)stack);
            }
            return false;
        }

        public static int getPurity(ItemStack stack) {
            if (THIRST_LOADED) {
                return WaterPurity.getPurity((ItemStack)stack);
            }
            return 0;
        }

        public static ItemStack setPurity(ItemStack stack, int purity) {
            if (THIRST_LOADED) {
                return WaterPurity.addPurity((ItemStack)stack, (int)purity);
            }
            return stack;
        }

        public static ItemStack setPurityFromBlock(ItemStack item, BlockPos pos, Level level) {
            if (THIRST_LOADED) {
                return WaterPurity.addPurity((ItemStack)item, (BlockPos)pos, (Level)level);
            }
            return item;
        }
    }

    public static abstract class Weather2 {
        public static boolean isRainstormAt(Level level, BlockPos pos) {
            if (WEATHER_LOADED) {
                WeatherManagerServer weatherManager = ServerTickHandler.getWeatherManagerFor((ResourceKey)level.m_46472_());
                if (weatherManager == null) {
                    return false;
                }
                StormObject rainStorm = weatherManager.getClosestStormAny(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), 250.0);
                if (rainStorm == null) {
                    return false;
                }
                if (WorldHelper.canSeeSky((LevelAccessor)level, pos, 60) && rainStorm.isPrecipitating() && rainStorm.levelTemperature > 0.0f && Math.sqrt(Math.pow((double)pos.m_123341_() - rainStorm.pos.f_82479_, 2.0) + Math.pow((double)pos.m_123341_() - rainStorm.pos.f_82479_, 2.0)) < (double)rainStorm.getSize()) {
                    return true;
                }
            }
            return false;
        }

        public static Object getClosestStorm(Level level, BlockPos pos) {
            if (WEATHER_LOADED) {
                WeatherManagerServer weatherManager = ServerTickHandler.getWeatherManagerFor((ResourceKey)level.m_46472_());
                if (weatherManager == null) {
                    return null;
                }
                double distance = Double.MAX_VALUE;
                WeatherObject closestStorm = null;
                for (WeatherObject stormObject : weatherManager.getStormObjects()) {
                    double newDistance = stormObject.pos.m_82554_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                    if (!(newDistance < distance)) continue;
                    distance = newDistance;
                    closestStorm = stormObject;
                }
                return closestStorm;
            }
            return null;
        }
    }

    public static abstract class SereneSeasons {
        public static boolean isColdEnoughToSnow(Level level, BlockPos pos) {
            return SERENE_SEASONS_LOADED && SeasonHooks.coldEnoughToSnowHook((Biome)((Biome)level.m_204166_(pos).m_203334_()), (BlockPos)pos, (LevelReader)level);
        }
    }

    public static abstract class Create {
        public static boolean isFluidPipe(BlockState state) {
            return CompatManager.isCreateLoaded() && (state.m_60734_() instanceof FluidPipeBlock || state.m_60734_() instanceof GlassFluidPipeBlock || state.m_60734_() instanceof EncasedPipeBlock);
        }
    }

    public static abstract class Curios {
        public static boolean hasCurio(LivingEntity player, Item curio) {
            return CURIOS_LOADED && Curios.getCurios(player).stream().map(ItemStack::m_41720_).anyMatch(item -> item == curio);
        }

        public static boolean hasCurio(LivingEntity player, ItemStack curio) {
            return CURIOS_LOADED && Curios.getCurios(player).contains(curio);
        }

        public static List<ItemStack> getCurios(LivingEntity entity) {
            if (!CURIOS_LOADED) {
                return new ArrayList<ItemStack>();
            }
            return entity.getCapability(CuriosCapability.INVENTORY).map(handler -> handler.getCurios().values()).stream().flatMap(Collection::stream).map(ICurioStacksHandler::getStacks).map(stacks -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    list.add(stacks.getStackInSlot(i));
                }
                return list;
            }).flatMap(Collection::stream).toList();
        }
    }
}

