/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.core.advancement.trigger.TriggerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class BlockAffectTempTrigger
extends SimpleCriterionTrigger<Instance> {
    static final ResourceLocation ID = new ResourceLocation("cold_sweat", "block_affects_temperature");

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext context) {
        double distance = json.has("distance") ? json.get("distance").getAsDouble() : 0.0;
        double totalEffect = json.has("total_effect") ? json.get("total_effect").getAsDouble() : 0.0;
        BlockPredicate block = BlockPredicate.m_17917_((JsonElement)json.get("blocks"));
        ArrayList<TriggerHelper.TempCondition> conditions = new ArrayList<TriggerHelper.TempCondition>();
        if (json.has("temperature")) {
            JsonArray tempList = json.get("temperature").getAsJsonArray();
            for (JsonElement element : tempList) {
                JsonObject entry = element.getAsJsonObject();
                Temperature.Trait trait = Temperature.Trait.fromID(entry.get("type").getAsString());
                TriggerHelper.getTempValueOrRange(entry).ifLeft(either -> conditions.add(new TriggerHelper.TempCondition(trait, (double)either, (double)either))).ifRight(pair -> conditions.add(new TriggerHelper.TempCondition(trait, (Double)pair.getFirst(), (Double)pair.getSecond())));
            }
        }
        return new Instance(player, block, distance, totalEffect, conditions);
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, BlockPos pos, double distance, double totalEffect) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(player, pos, distance, totalEffect));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        BlockPredicate block;
        MinMaxBounds.Doubles distance;
        MinMaxBounds.Doubles totalEffect;
        List<TriggerHelper.TempCondition> conditions;

        public Instance(EntityPredicate.Composite player, BlockPredicate block, double distance, double totalEffect, List<TriggerHelper.TempCondition> conditions) {
            super(ID, player);
            this.block = block;
            this.distance = distance > 0.0 ? MinMaxBounds.Doubles.m_154808_((double)distance) : MinMaxBounds.Doubles.m_154804_((double)0.0);
            this.totalEffect = totalEffect < 0.0 ? MinMaxBounds.Doubles.m_154808_((double)totalEffect) : MinMaxBounds.Doubles.m_154804_((double)totalEffect);
            this.conditions = conditions;
        }

        public boolean matches(ServerPlayer player, BlockPos pos, double distance, double totalEffect) {
            Map<Temperature.Trait, Double> temps = Temperature.getTemperatures((LivingEntity)player);
            return this.distance.m_154810_(distance) && this.totalEffect.m_154810_(totalEffect) && this.block.m_17914_(player.m_183503_(), pos) && this.conditions.stream().allMatch(condition -> condition.matches(temps.getOrDefault((Object)condition.trait(), 0.0)));
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject obj = super.m_7683_(context);
            obj.add("distance", this.distance.m_55328_());
            obj.add("total_effect", this.totalEffect.m_55328_());
            obj.add("blocks", this.block.m_17913_());
            return obj;
        }
    }
}

