/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.google.common.collect.ImmutableMap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.util.FunctionalSpawnerData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class AddEntitySpawns {
    private static final Field SPAWNERS = ObfuscationReflectionHelper.findField(MobSpawnSettings.class, (String)"f_48329_");

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoading(ServerAboutToStartEvent event) {
        RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
        if (registryAccess == null) {
            return;
        }
        for (Holder biome : registryAccess.m_175515_(Registry.f_122885_).m_203611_().toList()) {
            HashMap spawnerMap;
            try {
                spawnerMap = new HashMap((Map)SPAWNERS.get(((Biome)biome.m_203334_()).m_47518_()));
            }
            catch (IllegalAccessException e) {
                return;
            }
            CSMath.doIfNotNull(ConfigSettings.ENTITY_SPAWN_BIOMES.get(registryAccess).get((Object)biome), spawns -> {
                for (SpawnBiomeData spawn : spawns) {
                    RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ENTITIES, spawn.entities()).forEach(entityType -> {
                        ArrayList<MobSpawnSettings.SpawnerData> spawners = new ArrayList<MobSpawnSettings.SpawnerData>(((Biome)biome.m_203334_()).m_47518_().m_151798_(spawn.category()).m_146338_());
                        FunctionalSpawnerData spawnerData = new FunctionalSpawnerData((EntityType<?>)entityType, spawn.weight(), spawn.count().min(), spawn.count().max(), (level, structureManager, chunkGenerator, category, data, pos) -> spawn.location().test(rq -> rq.test((Level)level, pos)));
                        spawners.removeIf(oldData -> oldData.f_48404_ == entityType);
                        spawners.add(spawnerData);
                        spawnerMap.put(spawn.category(), WeightedRandomList.m_146328_(spawners));
                    });
                }
            });
            try {
                SPAWNERS.set(((Biome)biome.m_203334_()).m_47518_(), ImmutableMap.copyOf(spawnerMap));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        SPAWNERS.setAccessible(true);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegisterSpawnPlacements {
        @SubscribeEvent
        public static void registerSpawnPlacements(FMLCommonSetupEvent event) {
            SpawnPlacements.m_21754_(ModEntities.CHAMELEON, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        }
    }
}

