/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FuelData
extends ConfigData
implements RequirementHolder,
IForgeRegistryEntry<FuelData> {
    final NegatableList<ItemRequirement> item;
    final FuelType type;
    final Double fuel;
    public static final Codec<FuelData> CODEC = FuelData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.codec(ItemRequirement.CODEC).optionalFieldOf("item", new NegatableList()).forGetter(FuelData::item), (App)FuelType.CODEC.fieldOf("type").forGetter(FuelData::fuelType), (App)Codec.DOUBLE.fieldOf("fuel").forGetter(FuelData::fuel)).apply((Applicative)instance, FuelData::new)));

    public FuelData(NegatableList<ItemRequirement> item, FuelType type, Double fuel, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.type = type;
        this.fuel = fuel;
        this.item = item;
    }

    public FuelData(NegatableList<ItemRequirement> item, FuelType type, Double fuel) {
        this(item, type, fuel, new NegatableList<String>());
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public FuelType fuelType() {
        return this.type;
    }

    public Double fuel() {
        return this.fuel;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T req) -> req.test(stack, true));
    }

    @Nullable
    public static FuelData fromToml(List<?> entry, FuelType fuelType) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing fuel config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        double fuel = ((Number)entry.get(1)).doubleValue();
        NbtRequirement nbtRequirement = entry.size() > 2 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)entry.get(3))) : new NbtRequirement(new CompoundTag());
        ItemRequirement itemRequirement = new ItemRequirement(items, nbtRequirement);
        FuelData result = new FuelData(new NegatableList<ItemRequirement>(itemRequirement), fuelType, fuel);
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    public Codec<FuelData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FuelData that = (FuelData)obj;
        return super.equals(obj) && this.fuel.equals(that.fuel) && this.item.equals(that.item);
    }

    public FuelData setRegistryName(ResourceLocation name) {
        return null;
    }

    public ResourceLocation getRegistryName() {
        return null;
    }

    public Class<FuelData> getRegistryType() {
        return FuelData.class;
    }

    public static enum FuelType implements StringRepresentable
    {
        BOILER("boiler"),
        ICEBOX("icebox"),
        HEARTH("hearth"),
        SOUL_LAMP("soulspring_lamp");

        public static Codec<FuelType> CODEC;
        private final String name;

        private FuelType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static FuelType byName(String name) {
            return (FuelType)EnumHelper.byName((Enum[])FuelType.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])FuelType.values());
        }
    }
}

