/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InsulatorData
extends ConfigData
implements RequirementHolder,
IForgeRegistryEntry<InsulatorData> {
    final NegatableList<ItemRequirement> item;
    final Insulation.Slot slot;
    final List<Insulation> insulation;
    final NegatableList<EntityRequirement> entity;
    final AttributeModifierMap attributes;
    final Map<ResourceLocation, Double> immuneTempModifiers;
    final boolean fillSlots;
    final boolean hideIfUnmet;
    final Optional<HintText> hint;
    private static final Codec<List<Insulation>> INSULATION_CODEC = Codec.either((Codec)Insulation.getCodec().listOf(), Insulation.getCodec()).xmap(either -> (List)either.map(left -> left.stream().filter(insul -> !insul.isEmpty()).toList(), right -> right.isEmpty() ? List.of() : List.of(right)), list -> list.size() == 1 ? Either.right((Object)((Insulation)list.get(0))) : Either.left((Object)list));
    public static final Codec<InsulatorData> CODEC = InsulatorData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.codec(ItemRequirement.CODEC).optionalFieldOf("item", new NegatableList()).forGetter(InsulatorData::item), (App)Insulation.Slot.CODEC.fieldOf("type").forGetter(InsulatorData::slot), (App)INSULATION_CODEC.fieldOf("insulation").forGetter(InsulatorData::insulation), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(InsulatorData::entity), (App)AttributeModifierMap.CODEC.optionalFieldOf("attributes", (Object)new AttributeModifierMap()).forGetter(InsulatorData::attributes), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.DOUBLE).optionalFieldOf("immune_temp_modifiers", new HashMap()).forGetter(InsulatorData::immuneTempModifiers), (App)Codec.BOOL.optionalFieldOf("fill_slots", (Object)true).forGetter(InsulatorData::fillSlots), (App)Codec.BOOL.optionalFieldOf("hide_if_unmet", (Object)false).forGetter(InsulatorData::hideIfUnmet), (App)HintText.CODEC.optionalFieldOf("hint").forGetter(InsulatorData::hint)).apply((Applicative)instance, InsulatorData::new)));

    public InsulatorData(NegatableList<ItemRequirement> item, Insulation.Slot slot, List<Insulation> insulation, NegatableList<EntityRequirement> entity, AttributeModifierMap attributes, Map<ResourceLocation, Double> immuneTempModifiers, boolean fillSlots, boolean hideIfUnmet, Optional<HintText> hint, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.item = item;
        this.slot = slot;
        this.insulation = insulation;
        this.entity = entity;
        this.attributes = attributes;
        this.immuneTempModifiers = immuneTempModifiers;
        this.fillSlots = fillSlots;
        this.hideIfUnmet = hideIfUnmet;
        this.hint = hint;
    }

    public InsulatorData(NegatableList<ItemRequirement> item, Insulation.Slot slot, List<Insulation> insulation, NegatableList<EntityRequirement> entity, AttributeModifierMap attributes, Map<ResourceLocation, Double> immuneTempModifiers, boolean fillSlots, boolean hideIfUnmet, Optional<HintText> hint) {
        this(item, slot, insulation, entity, attributes, immuneTempModifiers, fillSlots, hideIfUnmet, hint, new NegatableList<String>());
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public Insulation.Slot slot() {
        return this.slot;
    }

    public List<Insulation> insulation() {
        return this.insulation;
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public AttributeModifierMap attributes() {
        return this.attributes;
    }

    public Map<ResourceLocation, Double> immuneTempModifiers() {
        return this.immuneTempModifiers;
    }

    public boolean fillSlots() {
        return this.fillSlots;
    }

    public boolean hideIfUnmet() {
        return this.hideIfUnmet;
    }

    public Optional<HintText> hint() {
        return this.hint;
    }

    public double getCold() {
        return this.insulation.stream().mapToDouble(Insulation::getCold).sum();
    }

    public double getHeat() {
        return this.insulation.stream().mapToDouble(Insulation::getHeat).sum();
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T rq) -> rq.test(stack, true));
    }

    @Override
    public boolean test(Entity entity) {
        return entity == null || this.entity.test((T rq) -> rq.test(entity));
    }

    @Nullable
    public static InsulatorData fromToml(List<?> entry, Insulation.Slot slot) {
        if (entry.size() < 3) {
            ColdSweat.LOGGER.error("Error parsing {} insulator config: not enough arguments", (Object)slot.m_7912_());
            return null;
        }
        NegatableList<Either<TagKey<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        boolean adaptive = entry.size() > 3 && entry.get(3).equals("adaptive");
        ArrayList<Insulation> insulation = new ArrayList<Insulation>();
        if (!adaptive) {
            List list;
            Object obj;
            if (!(entry.get(1) instanceof Number || (obj = entry.get(1)) instanceof List && (list = (List)obj).stream().allMatch(val -> val instanceof Number))) {
                ColdSweat.LOGGER.error("Error parsing {} insulator config: invalid cold insulation value: {}", (Object)slot.m_7912_(), entry.get(1));
                return null;
            }
            if (!(entry.get(2) instanceof Number || (obj = entry.get(2)) instanceof List && (list = (List)obj).stream().allMatch(val -> val instanceof Number))) {
                ColdSweat.LOGGER.error("Error parsing {} insulator config: invalid heat insulation valueL {}", (Object)slot.m_7912_(), entry.get(2));
                return null;
            }
            List<Number> insulVal1 = entry.get(1) instanceof List ? (List<Number>)entry.get(1) : List.of((Number)entry.get(1));
            List<Number> insulVal2 = entry.get(2) instanceof List ? (List<Number>)entry.get(2) : List.of((Number)entry.get(2));
            List<Insulation> coldList = insulVal1.stream().map(val -> new StaticInsulation(val.doubleValue(), 0.0)).collect(Collectors.toList());
            List<Insulation> hotList = insulVal2.stream().map(val -> new StaticInsulation(0.0, val.doubleValue())).collect(Collectors.toList());
            insulation.addAll(Insulation.combine(coldList, hotList));
        } else {
            insulation.add(new AdaptiveInsulation(((Number)entry.get(1)).doubleValue(), ((Number)entry.get(2)).doubleValue()));
        }
        CompoundTag tag = entry.size() > 4 ? NBTHelper.parseCompoundNbt((String)entry.get(4)) : new CompoundTag();
        boolean fillSlots = entry.size() <= 5 || (Boolean)entry.get(5) != false;
        ItemRequirement itemRequirement = new ItemRequirement(items, new NbtRequirement(tag));
        InsulatorData result = new InsulatorData(new NegatableList<ItemRequirement>(itemRequirement), slot, insulation, new NegatableList<EntityRequirement>(), new AttributeModifierMap(), new HashMap<ResourceLocation, Double>(), fillSlots, false, Optional.empty());
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    public InsulatorData copy() {
        return new InsulatorData(this.item, this.slot, Insulation.deepCopy(this.insulation), this.entity, this.attributes, new HashMap<ResourceLocation, Double>(this.immuneTempModifiers), this.fillSlots, this.hideIfUnmet, this.hint);
    }

    public Codec<InsulatorData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsulatorData that = (InsulatorData)obj;
        return super.equals(obj) && this.slot == that.slot && this.insulation.equals(that.insulation) && this.item.equals(that.item) && this.entity.equals(that.entity) && this.attributes.equals(that.attributes) && this.immuneTempModifiers.equals(that.immuneTempModifiers);
    }

    public InsulatorData setRegistryName(ResourceLocation name) {
        return this;
    }

    public ResourceLocation getRegistryName() {
        return new ResourceLocation("coldsweat", "insulators");
    }

    public Class<InsulatorData> getRegistryType() {
        return InsulatorData.class;
    }

    public static final class HintText {
        private final Optional<String> key;
        private final Optional<String> text;
        public static final Codec<HintText> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("key").forGetter(HintText::key), (App)Codec.STRING.optionalFieldOf("text").forGetter(HintText::text)).apply((Applicative)instance, HintText::new));

        public HintText(Optional<String> key, Optional<String> text) {
            this.key = key;
            this.text = text;
        }

        public Optional<String> key() {
            return this.key;
        }

        public Optional<String> text() {
            return this.text;
        }

        public MutableComponent getText() {
            return this.key.map(TranslatableComponent::new).orElse((MutableComponent)this.text.map(TextComponent::new).orElse(new TextComponent("")));
        }
    }
}

