/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class StructureTempData
extends ConfigData
implements IForgeRegistryEntry<StructureTempData> {
    NegatableList<Either<TagKey<ConfiguredStructureFeature<?, ?>>, OptionalHolder<ConfiguredStructureFeature<?, ?>>>> structures;
    double temperature;
    Temperature.Units units;
    boolean isOffset;
    public static final Codec<StructureTempData> CODEC = StructureTempData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrHolderCodec(Registry.f_122882_)).fieldOf("structures").forGetter(StructureTempData::structures), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(StructureTempData::temperature), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(StructureTempData::units), (App)Codec.BOOL.optionalFieldOf("offset", (Object)false).forGetter(StructureTempData::isOffset)).apply((Applicative)instance, StructureTempData::new)));

    public StructureTempData(NegatableList<Either<TagKey<ConfiguredStructureFeature<?, ?>>, OptionalHolder<ConfiguredStructureFeature<?, ?>>>> structures, double temperature, Temperature.Units units, boolean isOffset, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.structures = structures;
        this.temperature = temperature;
        this.units = units;
        this.isOffset = isOffset;
    }

    public StructureTempData(NegatableList<Either<TagKey<ConfiguredStructureFeature<?, ?>>, OptionalHolder<ConfiguredStructureFeature<?, ?>>>> structures, double temperature, Temperature.Units units, boolean isOffset) {
        this(structures, temperature, units, isOffset, new NegatableList<String>());
    }

    public StructureTempData(OptionalHolder<ConfiguredStructureFeature<?, ?>> structure, double temperature, Temperature.Units units, boolean isOffset) {
        this(new NegatableList(Either.right(structure)), temperature, units, isOffset);
    }

    public NegatableList<Either<TagKey<ConfiguredStructureFeature<?, ?>>, OptionalHolder<ConfiguredStructureFeature<?, ?>>>> structures() {
        return this.structures;
    }

    public double temperature() {
        return this.temperature;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public double getTemperature() {
        return Temperature.convert(this.temperature, this.units, Temperature.Units.MC, this.isOffset);
    }

    @Nullable
    public static StructureTempData fromToml(List<?> entry, boolean isOffset, RegistryAccess registryAccess) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing structure config: {} does not have enough arguments", entry);
            return null;
        }
        NegatableList<Either<TagKey<ConfiguredStructureFeature<?, ?>>, OptionalHolder<ConfiguredStructureFeature<?, ?>>>> structures = ConfigHelper.parseRegistryItems(Registry.f_122882_, registryAccess, (String)entry.get(0));
        if (structures.isEmpty()) {
            return null;
        }
        double temp = ((Number)entry.get(1)).doubleValue();
        Temperature.Units units = entry.size() == 3 ? Temperature.Units.valueOf(((String)entry.get(2)).toUpperCase()) : Temperature.Units.MC;
        StructureTempData result = new StructureTempData(structures, temp, units, isOffset);
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    public Codec<StructureTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructureTempData that = (StructureTempData)obj;
        return super.equals(obj) && Double.compare(that.temperature, this.temperature) == 0 && this.isOffset == that.isOffset && this.structures.equals(that.structures) && this.units == that.units;
    }

    public StructureTempData setRegistryName(ResourceLocation name) {
        return null;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return null;
    }

    public Class<StructureTempData> getRegistryType() {
        return null;
    }
}

