/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.impl;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.momosoftworks.coldsweat.api.annotation.Internal;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public abstract class ConfigData {
    protected UUID id = UUID.randomUUID();
    protected Type configType = Type.JSON;
    protected NegatableList<String> requiredMods;
    protected ResourceKey registryKey;
    public static final Codec<NegatableList<String>> REQUIRED_MODS_CODEC = NegatableList.listCodec(Codec.STRING, true);
    public static final Codec<UUID> UUID_CODEC = Codec.STRING.xmap(UUID::fromString, UUID::toString);
    public static final Codec<Type> TYPE_CODEC = Type.CODEC;

    public ConfigData(NegatableList<String> requiredMods, Type configType, UUID id) {
        this.requiredMods = requiredMods;
        this.configType = configType;
        this.id = id;
    }

    public ConfigData(NegatableList<String> requiredMods) {
        this.requiredMods = requiredMods;
    }

    public abstract <T> Codec<T> getCodec();

    protected static <T extends ConfigData> Codec<T> createCodec(final MapCodec<T> child) {
        return new MapCodec<T>(){

            public <O> RecordBuilder<O> encode(T input, DynamicOps<O> ops, RecordBuilder<O> prefix) {
                RecordBuilder builder = child.encode(input, ops, prefix);
                builder.add("required_mods", ((ConfigData)input).requiredMods(), REQUIRED_MODS_CODEC).add("config_type", (Object)((ConfigData)input).configType(), TYPE_CODEC).add("id", (Object)((ConfigData)input).uuid(), UUID_CODEC);
                if (((ConfigData)input).registryKey != null) {
                    builder.add("registry_name", (Object)((ConfigData)input).registryKey().m_211136_(), (Encoder)ResourceLocation.f_135803_);
                    builder.add("registry_key", (Object)((ConfigData)input).registryKey().m_135782_(), (Encoder)ResourceLocation.f_135803_);
                }
                return builder;
            }

            public <O> DataResult<T> decode(DynamicOps<O> ops, MapLike<O> input) {
                return child.decode(ops, input).flatMap(instance -> {
                    instance.requiredMods = ConfigData.decodeFromMap("required_mods", ops, input, REQUIRED_MODS_CODEC, new NegatableList());
                    instance.configType = ConfigData.decodeFromMap("config_type", ops, input, TYPE_CODEC, Type.JSON);
                    instance.id = ConfigData.decodeFromMap("id", ops, input, UUID_CODEC, null);
                    ResourceLocation registry = ConfigData.decodeFromMap("registry_name", ops, input, ResourceLocation.f_135803_, null);
                    ResourceLocation key = ConfigData.decodeFromMap("registry_key", ops, input, ResourceLocation.f_135803_, null);
                    if (registry != null && key != null) {
                        instance.registryKey = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)registry), (ResourceLocation)key);
                    }
                    return DataResult.success((Object)instance);
                });
            }

            public <O> Stream<O> keys(DynamicOps<O> ops) {
                return Stream.of("required_mods", "config_type", "id").map(arg_0 -> ops.createString(arg_0));
            }
        }.codec();
    }

    private static <T, O> T decodeFromMap(String key, DynamicOps<O> ops, MapLike<O> input, Codec<T> codec, T defaultValue) {
        return (T)codec.decode(ops, input.get(key)).result().map(Pair::getFirst).orElse(defaultValue);
    }

    public UUID uuid() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public Type configType() {
        return this.configType;
    }

    public NegatableList<String> requiredMods() {
        return this.requiredMods;
    }

    public <T> ResourceKey<T> registryKey() {
        return this.registryKey;
    }

    public <D extends ConfigData> Optional<? extends Holder<D>> getHolder(RegistryAccess registryAccess) {
        if (this.registryKey == null) {
            return Optional.empty();
        }
        ResourceKey<? extends Registry<? extends ConfigData>> regKey = ModRegistries.getRegistryKey(this.registryKey().m_211136_());
        Registry registry = registryAccess.m_175515_(regKey);
        return registry.m_203636_(this.registryKey());
    }

    @Internal
    public void setId(UUID id) {
        this.id = id;
    }

    @Internal
    public void setConfigType(Type configType) {
        this.configType = configType;
    }

    @Internal
    public void setRegistryKey(ResourceKey<? extends ConfigData> registryKey) {
        this.registryKey = registryKey;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("");
    }

    public boolean areRequiredModsLoaded() {
        return this.requiredMods.test(mod -> mod.equals("minecraft") || CompatManager.modLoaded(mod));
    }

    public boolean equals(Object obj) {
        ConfigData data;
        return obj instanceof ConfigData && (data = (ConfigData)obj).requiredMods().equals(this.requiredMods());
    }

    public static enum Type implements StringRepresentable
    {
        TOML("toml"),
        JSON("json"),
        KUBEJS("kubejs");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        @Nullable
        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.m_7912_().equals(name)) continue;
                return type;
            }
            return null;
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Type.values());
        }
    }
}

