/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.loot.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.data.codec.LootEntry;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public class AddPiglinBartersModifier
extends LootModifier {
    private final List<LootEntry> additions;
    static ResourceLocation PIGLIN_BARTER_LOCATION = new ResourceLocation("gameplay/piglin_bartering");
    static Field POOLS = ObfuscationReflectionHelper.findField(LootTable.class, (String)"f_79109_");
    static Field ENTRIES = ObfuscationReflectionHelper.findField(LootPool.class, (String)"f_79023_");

    protected AddPiglinBartersModifier(LootItemCondition[] conditions, List<LootEntry> additions) {
        super(conditions);
        this.additions = additions;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, final LootContext context) {
        try {
            ArrayList<1> entries = new ArrayList<1>();
            MutableInt totalWeight = new MutableInt();
            for (LootPool pool : (List)POOLS.get(context.m_78940_(PIGLIN_BARTER_LOCATION))) {
                for (LootPoolEntryContainer container : (LootPoolEntryContainer[])ENTRIES.get(pool)) {
                    container.m_6562_(context, entry -> {
                        entries.add(entry);
                        totalWeight.add(entry.m_7067_(context.m_78945_()));
                    });
                }
            }
            for (final LootEntry addition : this.additions) {
                entries.add(new LootPoolEntry(){

                    public int m_7067_(float luck) {
                        return CSMath.floor((float)addition.weight() * (1.0f + context.m_78945_()));
                    }

                    public void m_6941_(Consumer<ItemStack> consumer, LootContext context1) {
                        consumer.accept(new ItemStack((ItemLike)addition.item(), context.m_78933_().nextInt(addition.count().min(), addition.count().max() + 1)));
                    }
                });
                totalWeight.add(addition.weight());
            }
            AtomicReference<ItemStack> stack = new AtomicReference<ItemStack>(ItemStack.f_41583_);
            int j = context.m_78933_().nextInt(totalWeight.intValue());
            for (LootPoolEntry lootPoolEntry : entries) {
                if ((j -= lootPoolEntry.m_7067_(context.m_78945_())) >= 0) continue;
                lootPoolEntry.m_6941_(stack::set, context);
                return ObjectArrayList.wrap((Object[])new ItemStack[]{stack.get()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generatedLoot;
    }

    static {
        POOLS.setAccessible(true);
        ENTRIES.setAccessible(true);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddPiglinBartersModifier> {
        public AddPiglinBartersModifier read(@Nonnull ResourceLocation location, JsonObject object, LootItemCondition[] conditionsIn) {
            ArrayList<LootEntry> additions = new ArrayList<LootEntry>();
            for (JsonElement addition : GsonHelper.m_13832_((JsonObject)object, (String)"additions", (JsonArray)new JsonArray())) {
                JsonObject additionObject = addition.getAsJsonObject();
                Optional<CompoundTag> tag = additionObject.has("tag") ? Optional.of((CompoundTag)CompoundTag.f_128325_.parse((DynamicOps)JsonOps.INSTANCE, (Object)additionObject.get("tag")).getOrThrow(false, s -> {})) : Optional.empty();
                JsonObject count = GsonHelper.m_13841_((JsonObject)additionObject, (String)"count", (JsonObject)new JsonObject());
                additions.add(new LootEntry((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)additionObject, (String)"item"))), tag, new IntegerBounds(GsonHelper.m_13824_((JsonObject)count, (String)"min", (int)1), GsonHelper.m_13824_((JsonObject)count, (String)"max", (int)1)), GsonHelper.m_13824_((JsonObject)additionObject, (String)"weight", (int)1)));
            }
            return new AddPiglinBartersModifier(conditionsIn, additions);
        }

        public JsonObject write(AddPiglinBartersModifier instance) {
            JsonObject object = new JsonObject();
            JsonArray additions = new JsonArray();
            for (LootEntry addition : instance.additions) {
                JsonObject additionObject = new JsonObject();
                additionObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)addition.item()).toString());
                JsonObject count = new JsonObject();
                count.addProperty("min", (Number)addition.count().min());
                count.addProperty("max", (Number)addition.count().max());
                additionObject.add("count", (JsonElement)count);
                additionObject.addProperty("weight", (Number)addition.weight());
                addition.tag().ifPresent(tag -> additionObject.add("nbt", (JsonElement)CompoundTag.f_128325_.encodeStart((DynamicOps)JsonOps.INSTANCE, tag).result().orElseThrow(RuntimeException::new)));
                additions.add((JsonElement)additionObject);
            }
            object.add("additions", (JsonElement)additions);
            return object;
        }
    }
}

