/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public class MixinItemTooltip {
    ItemStack stack = (ItemStack)this;
    private static EquipmentSlot CURRENT_SLOT_QUERY = null;
    private static Multimap<Attribute, AttributeModifier> INSULATION_MODIFIERS = new FastMultiMap<Attribute, AttributeModifier>();
    private static Multimap<Attribute, AttributeModifier> UNMET_MODIFIERS = new FastMultiMap<Attribute, AttributeModifier>();
    private static Attribute ATTRIBUTE = null;
    private static AttributeModifier MODIFIER = null;

    @Inject(method={"getTooltipLines"}, at={@At(value="FIELD", target="Lnet/minecraft/world/item/ItemStack$TooltipPart;MODIFIERS:Lnet/minecraft/world/item/ItemStack$TooltipPart;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectBeforeAttributes(Player player, TooltipFlag advanced, CallbackInfoReturnable<List<MutableComponent>> cir, List<MutableComponent> tooltip) {
        ItemStack stack = (ItemStack)this;
        AttributeModifierMap insulatorAttributes = new AttributeModifierMap();
        AttributeModifierMap unmetInsulatorAttributes = new AttributeModifierMap();
        for (InsulatorData insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.m_41720_())) {
            if (TooltipHandler.passesRequirement(insulator)) {
                insulatorAttributes.putAll(insulator.attributes());
                continue;
            }
            unmetInsulatorAttributes.putAll(insulator.attributes());
        }
        if (!insulatorAttributes.isEmpty() || !unmetInsulatorAttributes.isEmpty()) {
            tooltip.add((MutableComponent)new TextComponent(""));
            tooltip.add(new TranslatableComponent("item.modifiers.insulation").m_130940_(ChatFormatting.GRAY));
            TooltipHandler.addModifierTooltipLines(tooltip, insulatorAttributes, true, false);
            TooltipHandler.addModifierTooltipLines(tooltip, unmetInsulatorAttributes, true, true);
        }
        AttributeModifierMap curioAttributes = new AttributeModifierMap();
        AttributeModifierMap unmetCurioAttributes = new AttributeModifierMap();
        for (InsulatorData insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)stack.m_41720_())) {
            if (TooltipHandler.passesRequirement(insulator)) {
                curioAttributes.putAll(insulator.attributes());
                continue;
            }
            unmetCurioAttributes.putAll(insulator.attributes());
        }
        if (!curioAttributes.isEmpty() || !unmetCurioAttributes.isEmpty()) {
            tooltip.add((MutableComponent)new TextComponent(""));
            tooltip.add(new TranslatableComponent("item.modifiers.curio").m_130940_(ChatFormatting.GRAY));
            TooltipHandler.addModifierTooltipLines(tooltip, curioAttributes, true, false);
            TooltipHandler.addModifierTooltipLines(tooltip, unmetCurioAttributes, true, true);
        }
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setCurrentSlot(Player player, TooltipFlag advanced, CallbackInfoReturnable<List<MutableComponent>> cir, List<MutableComponent> tooltip, MutableComponent name, int hideFlags, EquipmentSlot[] allSlots, int var7, int var8, EquipmentSlot slot) {
        CURRENT_SLOT_QUERY = slot;
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    private Multimap<Attribute, AttributeModifier> modifyAttributeModifiers(Multimap<Attribute, AttributeModifier> original, Player player, TooltipFlag advanced) {
        INSULATION_MODIFIERS.clear();
        UNMET_MODIFIERS.clear();
        ListMultimap modifiers = MultimapBuilder.linkedHashKeys().arrayListValues().build(original);
        if (LivingEntity.m_147233_((ItemStack)this.stack) == CURRENT_SLOT_QUERY) {
            for (InsulatorData insulator : ConfigSettings.INSULATING_ARMORS.get().get((Object)this.stack.m_41720_())) {
                if (TooltipHandler.passesRequirement(insulator)) {
                    INSULATION_MODIFIERS.putAll(insulator.attributes().getMap());
                } else {
                    if (insulator.hideIfUnmet()) continue;
                    UNMET_MODIFIERS.putAll(insulator.attributes().getMap());
                }
                modifiers.putAll(insulator.attributes().getMap());
            }
            ItemInsulationManager.getInsulationCap(this.stack).ifPresent(arg_0 -> MixinItemTooltip.lambda$modifyAttributeModifiers$1((Multimap)modifiers, arg_0));
        }
        return modifiers;
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")}, slice={@Slice(from=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7), to=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9))}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setupCustomAttributeDisplay(Player pPlayer, TooltipFlag pIsAdvanced, CallbackInfoReturnable<List<Component>> cir, List<Component> tooltip, MutableComponent name, int hideFlags, EquipmentSlot[] var6, int var7, int var8, EquipmentSlot equipmentslot, Multimap<Attribute, AttributeModifier> attributeMap, Iterator<AttributeModifier> entryIterator, Map.Entry<Attribute, AttributeModifier> entry) {
        ATTRIBUTE = entry.getKey();
        MODIFIER = entry.getValue();
    }

    @ModifyArg(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7), to=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9)))
    private <E> E customAttributeFormatting(E obj) {
        if (obj instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)obj;
            if (ATTRIBUTE != null && MODIFIER != null) {
                boolean isFromInsulation;
                boolean hasUnmetRequirements = UNMET_MODIFIERS.remove((Object)ATTRIBUTE, (Object)MODIFIER);
                boolean bl = isFromInsulation = INSULATION_MODIFIERS.remove((Object)ATTRIBUTE, (Object)MODIFIER) || hasUnmetRequirements;
                if (EntityTempManager.isTemperatureAttribute(ATTRIBUTE)) {
                    MutableComponent newline = TooltipHandler.getFormattedAttributeModifier(ATTRIBUTE, MODIFIER.m_22218_(), MODIFIER.m_22217_(), isFromInsulation, hasUnmetRequirements);
                    for (Component sibling : component.m_7360_()) {
                        newline = newline.m_7220_(sibling);
                    }
                    return (E)newline;
                }
                return (E)TooltipHandler.addTooltipFlags(component, isFromInsulation, hasUnmetRequirements);
            }
        }
        return obj;
    }

    private static /* synthetic */ void lambda$modifyAttributeModifiers$1(Multimap modifiers, IInsulatableCap cap) {
        cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> {
            for (InsulatorData insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)item.m_41720_())) {
                if (TooltipHandler.passesRequirement(insulator)) {
                    INSULATION_MODIFIERS.putAll(insulator.attributes().getMap());
                } else {
                    if (insulator.hideIfUnmet()) continue;
                    UNMET_MODIFIERS.putAll(insulator.attributes().getMap());
                }
                modifiers.putAll(insulator.attributes().getMap());
            }
        });
    }
}

